/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CVUCheckSkipper {
    private static CVUCheckSkipper m_instance = null;
    private Set<Pattern> m_taskIdPatterns = new HashSet<Pattern>();

    private CVUCheckSkipper() {
        String cvuVar = "ORA_DISABLED_CVU_CHECKS";
        String taskIds = System.getProperty(cvuVar);
        Trace.out((int)1, (String)(cvuVar + " from java property " + taskIds));
        if (taskIds == null) {
            taskIds = VerificationUtil.getVariableValue(cvuVar);
            Trace.out((int)1, (String)(cvuVar + " from CVU variable " + taskIds));
            if (taskIds == null) {
                taskIds = VerificationUtil.getEnv(cvuVar);
                Trace.out((int)1, (String)(cvuVar + " from OS ENV " + taskIds));
            }
        }
        if (!VerificationUtil.isStringGood(taskIds)) {
            Trace.out((int)1, (String)(cvuVar + " is not in CVU variables. set " + cvuVar + " environment variable with comma seperated list of task ids that needs to be disabled"));
            return;
        }
        for (String taskId : taskIds.split(",")) {
            String regexp = taskId.replaceAll("\\*", ".*");
            Trace.out((String)("adding " + taskId + " to the m_taskIdPatterns"));
            Pattern p = Pattern.compile(regexp);
            this.m_taskIdPatterns.add(p);
        }
    }

    public static CVUCheckSkipper getInstance() {
        if (m_instance == null) {
            m_instance = new CVUCheckSkipper();
        }
        return m_instance;
    }

    public boolean isSkipTask(Task task) {
        String id = task.getTaskID();
        Trace.out((int)1, (String)("checking task id " + id));
        for (Pattern p : this.m_taskIdPatterns) {
            if (!p.matcher(id).matches()) continue;
            return true;
        }
        return false;
    }
}

