/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.NodeRole;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.ASMPresence;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class CVUHelperUtil
implements CVUHelperConstants {
    private static String HELPER_VERSION_11107 = "11107";
    private static String HELPER_VERSION_10205 = "10205";
    private static String HELPER_VERSION_11201 = "11201";
    private static String HELPER_VERSION_11202 = "11202";
    private static String HELPER_VERSION_11203 = "11203";
    private static String HELPER_VERSION_12101 = "12101";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static String GET_CRSUSER_HELPER_ARG = "-getCRSUser";
    private static String CHECK_DEFAULT_LISTENER_HELPER_ARG = "-checkDefaultListener";
    private static String GET_GNS_DOMAIN_VIP_ARG = "-getGNSDomainAndVip";
    private static String CHECK_VIP_ARG = "-vipExists";
    private static String GET_NET_CONFIG_ARG = "-getNetworkInfo";
    private static String GET_CSSMODE_HELPER_ARG = "-getCSSMode";
    private static String GET_ASM_ATTRIBUTE = "-getASMResourceAttribute";
    private static String PRESENCE = "PRESENCE";
    private static String ASM_COUNT = "ASM_INSTANCE_COUNT";
    private static String GET_NODE_ROLE = "-getNodeRole";
    private static String GET_NODE_NAMES = "-getNodeNames";
    private static String GET_ASM_HOME = "-getASMhome";
    private static String GET_ASM_INSTANCE = "-getASMsid";
    private static String VALIDATE_GNS_CREDENTIAL = "-validateGNSCredential";
    private static String ACTIVE = "ACTIVE";
    private static String CONFIGURED = "CONFIGURED";
    private static String CVU_HELPER_JAR_PREFIX = "cvuhelper";
    private static String CVU_HELPER_JAR_SUFFIX = ".jar";
    private static final char[] cmdSepArrNT = new char[]{',', ';'};
    private static ASMPresence m_asmPresence = null;
    private static boolean m_isSIHA = false;

    public static String getHelperVersion(String crsHome, String methodName) {
        String version = null;
        version = !m_isSIHA ? VerificationUtil.getCRSReleaseVersion(crsHome, false) : VerificationUtil.getSIHAReleaseVersion(true);
        if (version == null) {
            Trace.out((String)"unable to determine version");
            return HELPER_VERSION_12101;
        }
        if (VerificationUtil.isVersionPre(version = version.toLowerCase(), "11.1")) {
            return HELPER_VERSION_10205;
        }
        if (VerificationUtil.isVersionPre(version, "11.2")) {
            return HELPER_VERSION_11107;
        }
        if (version.startsWith("11.2.0.3")) {
            return HELPER_VERSION_11203;
        }
        if (version.startsWith("11.2.0.2")) {
            Trace.out((String)"using cvuhelper 11.2.0.2");
            return HELPER_VERSION_11202;
        }
        if (version.startsWith("11.2.0.1")) {
            Trace.out((String)"using cvuhelper 11.2.0.1");
            return HELPER_VERSION_11201;
        }
        if (version.startsWith("11.2")) {
            Trace.out((String)"using cvuhelper 11.2.0.3 as latest");
            return HELPER_VERSION_11203;
        }
        return HELPER_VERSION_12101;
    }

    public static CVUHelperExec runCVUHelper(String[] args, String[] env) throws CVUHelperException {
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null && (crsHome = VerificationUtil.getHAHome()) != null) {
            m_isSIHA = true;
        }
        if (crsHome == null) {
            Trace.out((String)"Crshome couldn't be obtained");
            String errMsg = s_msgBundle.getMessage("5301", true);
            throw new CVUHelperException(errMsg);
        }
        Trace.out((String)("crshome obtained is" + crsHome));
        return CVUHelperUtil.runCVUHelper(args, env, crsHome);
    }

    public static String getHelperJarFullPath(String helperVersion) {
        String helperJarFile = CVU_HELPER_JAR_PREFIX;
        String fullPath = null;
        String[] allPathArr = new String[]{"jlib" + FSEP, ".." + FSEP + "ext" + FSEP + "jlib" + FSEP, "opsm" + FSEP + "jlib" + FSEP};
        helperJarFile = helperVersion != null ? helperJarFile + helperVersion.substring(0, 3) : helperJarFile + "121";
        helperJarFile = helperJarFile + CVU_HELPER_JAR_SUFFIX;
        for (String path : allPathArr) {
            fullPath = CVUAutoUpdateManager.getCVUFileLocation(path + helperJarFile);
            File file = new File(fullPath);
            if (!file.exists()) continue;
            return fullPath;
        }
        return fullPath;
    }

    public static CVUHelperExec runCVUHelper(String[] args, String[] env, String crsHome) throws CVUHelperException {
        int i;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnix = nativeSystem.isUnixSystem();
        String cvuHelper = nativeSystem.getScriptFileName("cvuhelper");
        if (args.length < 1) {
            String errMsg = s_gMsgBundle.getMessage("1001", true, (Object[])new String[]{cvuHelper});
            throw new CVUHelperException(errMsg);
        }
        String m_cvuHelperCmd = CVUAutoUpdateManager.getCVUFileLocation("cv" + FSEP + "remenv" + FSEP + cvuHelper);
        Trace.out((String)("About to run" + m_cvuHelperCmd));
        String[] execArgs = new String[args.length + 5];
        execArgs[0] = m_cvuHelperCmd;
        execArgs[1] = crsHome;
        execArgs[2] = CVUHelperUtil.getHelperVersion(crsHome, args[0]);
        execArgs[3] = CVUHelperUtil.getHelperJarFullPath(execArgs[2]);
        execArgs[4] = CVUAutoUpdateManager.getDerivedCVUHome();
        if (isUnix) {
            for (i = 0; i < args.length; ++i) {
                execArgs[i + 5] = args[i];
            }
        } else {
            for (i = 0; i < args.length; ++i) {
                boolean addQuote = false;
                for (int j = 0; j < cmdSepArrNT.length; ++j) {
                    if (args[i].indexOf(cmdSepArrNT[j]) == -1) continue;
                    addQuote = true;
                    break;
                }
                execArgs[i + 5] = addQuote ? "\"" + args[i] + "\"" : args[i];
            }
        }
        CVUHelperExec cvExec = new CVUHelperExec(execArgs, env);
        cvExec.runCommand();
        Trace.out((String)("after execution of cvu helper for " + args[0]));
        return cvExec;
    }

    public static int fetchVerificationStatus(String sfmtd) {
        String tagValue = VerificationUtil.fetchTextByTags(sfmtd, null, "<CVH_VRES>", "</CVH_VRES>");
        if (tagValue == null) {
            tagValue = VerificationUtil.fetchTextByTags(sfmtd, null, "<CVH_ERES>", "</CVH_ERES>");
        }
        return Integer.parseInt(tagValue);
    }

    public static String[] fetchError(String[] sfmtd) {
        return CVUHelperUtil.fetchArrayByTags(sfmtd, "<CVH_EMSG>", "</CVH_EMSG>");
    }

    public static String[] fetchWarning(String[] sfmtd) {
        return CVUHelperUtil.fetchArrayByTags(sfmtd, "<CVH_WMSG>", "</CVH_WMSG>");
    }

    public static String[] fetchOutput(String[] sfmtd) {
        return CVUHelperUtil.fetchArrayByTags(sfmtd, "<CVH_OUT>", "</CVH_OUT>");
    }

    public static String[] fetchArrayByTags(String[] sfmtd, String tagStart, String tagEnd) {
        int i = 0;
        ArrayList<String> resultList = new ArrayList<String>();
        block0: while (i < sfmtd.length) {
            while (i < sfmtd.length) {
                Trace.out((String)("###" + sfmtd[i] + "###"));
                if (!sfmtd[i].equalsIgnoreCase(tagStart)) {
                    Trace.out((String)("starting tag not found : " + i));
                    ++i;
                    continue;
                }
                Trace.out((String)("Starting tag found : " + ++i));
                break;
            }
            while (i < sfmtd.length) {
                if (sfmtd[i].equalsIgnoreCase(tagEnd)) {
                    Trace.out((String)("found end tag at : " + ++i));
                    continue block0;
                }
                Trace.out((String)("adding " + sfmtd[i]));
                resultList.add(sfmtd[i]);
                ++i;
            }
        }
        return resultList.toArray(new String[0]);
    }

    public static String getCRSUser() {
        String[] args = new String[]{GET_CRSUSER_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get crsuser" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return outArr[0];
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static void checkDefaultListener(Result listenerResult) {
        String[] output;
        String localNode = null;
        String resourceRunningNode = null;
        if (null == listenerResult) {
            localNode = VerificationUtil.getLocalHostName();
            listenerResult = new Result(localNode);
        } else {
            localNode = listenerResult.getNode();
        }
        listenerResult.setExpectedValue(localNode);
        String[] args = new String[]{CHECK_DEFAULT_LISTENER_HELPER_ARG, localNode};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException che) {
            Trace.out((String)("cvuhelper couldn't be executed " + che.getMessage()));
            listenerResult.addErrorDescription(new ErrorDescription(che.getMessage()));
            listenerResult.setStatus(2);
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            if (VerificationUtil.isStringGood(helperExec.getErrorString())) {
                listenerResult.addErrorDescription(new ErrorDescription(helperExec.getErrorString()));
            }
            listenerResult.setStatus(2);
        }
        if ((output = helperExec.getOutput()).length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("Default listener for node " + localNode + " was not found configured \n" + helperExec.getErrorString()));
                listenerResult.setStatus(3);
            } else {
                String[] outArr = CVUHelperUtil.fetchOutput(output);
                if (outArr.length > 0 && VerificationUtil.isStringGood(outArr[0])) {
                    resourceRunningNode = outArr[0];
                    if (resourceRunningNode.equalsIgnoreCase(localNode)) {
                        listenerResult.setStatus(1);
                    } else {
                        listenerResult.setStatus(4);
                    }
                    listenerResult.setActualValue(resourceRunningNode);
                    listenerResult.setHasResultValues(true);
                } else {
                    Trace.out((String)"no output from cvuhelper");
                    if (VerificationUtil.isStringGood(helperExec.getErrorString())) {
                        listenerResult.addErrorDescription(new ErrorDescription(helperExec.getErrorString()));
                    }
                    listenerResult.setStatus(2);
                }
            }
        } else {
            Trace.out((String)"cvuhelper produced no output");
            if (VerificationUtil.isStringGood(helperExec.getErrorString())) {
                listenerResult.addErrorDescription(new ErrorDescription(helperExec.getErrorString()));
            }
            listenerResult.setStatus(2);
        }
    }

    public static boolean getGNSDomainAndVIP(ResultSet rs, String node) {
        return CVUHelperUtil.getGNSDomainAndVIP(rs, node, false);
    }

    public static boolean getGNSDomainAndVIP(ResultSet rs, String node, boolean mute) {
        String gnsDomainName = null;
        String gnsVIP = null;
        String[] args = new String[]{GET_GNS_DOMAIN_VIP_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                rs.addResult(node, 2);
                rs.addErrorDescription(errorDesc);
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                rs.addResult(node, 2);
                rs.addErrorDescription(errorDesc);
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                if (!mute) {
                    errorArray = CVUHelperUtil.fetchError(output);
                    String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                    ReportUtil.printError(errMsg);
                }
                return false;
            }
            Trace.out((String)"gns details collected");
            String[] gnsDetails = CVUHelperUtil.fetchOutput(output);
            gnsDomainName = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<GNS_DOMAIN_NAME>", "</GNS_DOMAIN_NAME>");
            gnsVIP = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<GNS_VIP_NAME>", "</GNS_VIP_NAME>");
            VerificationUtil.setVariableValue("GNS_SUB_DOMAIN", gnsDomainName);
            VerificationUtil.setVariableValue("GNS_VIP_ADDRESS", gnsVIP);
            Trace.out((String)("domain=" + gnsDomainName));
            Trace.out((String)("vip=" + gnsVIP));
            return true;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        if (!mute) {
            String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            rs.addResult(node, 2);
            rs.addErrorDescription(node, errorDesc);
            ReportUtil.printError(errMsg);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkASMRunning(String[] nodeList, List<String> runningASMNodes, List<String> failedASMNodes, ResultSet resultSet) {
        String[] validNodeArr = nodeList;
        Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT = new Hashtable<String, List<ASMDiskGroup>>();
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        try {
            asmdg.checkASMRunning(nodeList, runningASMNodes, failedASMNodes);
        }
        catch (ASMDiskGroupsUtilException e1) {
            resultSet.addResult(nodeList, 2);
            for (String node : nodeList) {
                failedASMNodes.add(node);
            }
            Trace.out((int)5, (String)("Error checking if ASM running on all nodes." + e1));
        }
        if (failedASMNodes.size() > 0) {
            String[] failedNodeArr = failedASMNodes.toArray(new String[0]);
            resultSet.addResult(failedNodeArr, 3);
            if (runningASMNodes.size() <= 0) {
                ReportUtil.printError(LSEP + s_msgBundle.getMessage("4194", true) + LSEP);
                return false;
            }
            ReportUtil.printError(LSEP + s_msgBundle.getMessage("4193", true) + LSEP);
            ReportUtil.sureprintNodelist(failedASMNodes.toArray(new String[0]));
            validNodeArr = runningASMNodes.toArray(new String[0]);
            resultSet.addResult(validNodeArr, 1);
        } else {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5108", false));
            resultSet.addResult(validNodeArr, 1);
        }
        try {
            asmdg.getDiskGroups(validNodeArr, resultSet, asmDiskGroupHT);
            return true;
        }
        catch (ASMDiskGroupsUtilException e2) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5131", true));
            return false;
        }
    }

    public static String getASMhome(Result result) {
        String[] args = new String[]{GET_ASM_HOME, VerificationUtil.getLocalHostName()};
        String[] env = null;
        CVUHelperExec helperExec = null;
        result.setStatus(1);
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to get ASM home");
                String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(3);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                Trace.out((String)("Fetched ASM home successfully; returning '" + outArr[0] + "'"));
                return outArr[0];
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(3);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }

    public static void checkVIPExists(String nodeName, ResultSet resultSet) {
        String[] args = new String[]{CHECK_VIP_ARG, nodeName};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            return;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get vip" + helperExec.getErrorString()));
            } else if (status == 1) {
                Trace.out((String)("no vips exist on node " + nodeName));
                String errMsg = s_msgBundle.getMessage("4858", false, (Object[])new String[]{nodeName});
                ReportUtil.printWarning(errMsg + LSEP);
                resultSet.addErrorDescription(new ErrorDescription(errMsg));
            } else {
                Trace.out((String)("vips exists on the node" + nodeName));
            }
        } else {
            Trace.out((String)"cvuhelper produced no output");
        }
    }

    public static boolean getNeworkConfig(int networkNumber, boolean mute) {
        String networkInterconnect = null;
        String[] args = new String[]{GET_NET_CONFIG_ARG, Integer.toString(networkNumber)};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1010", true, (Object[])new String[]{"cvuhelper", Integer.toString(networkNumber)}) + LSEP + e.getMessage();
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1010", true, (Object[])new String[]{helperExec.getCommandString(), Integer.toString(networkNumber)}) + LSEP + helperExec.getErrorString();
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                if (!mute) {
                    errorArray = CVUHelperUtil.fetchError(output);
                    String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                    ReportUtil.printError(errMsg);
                }
                return false;
            }
            Trace.out((String)"gns details collected");
            String[] gnsDetails = CVUHelperUtil.fetchOutput(output);
            String netSubDomain = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<NET_SUBDOMAIN>", "</NET_SUBDOMAIN>");
            String netInterface = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<NET_INTERFACE>", "</NET_INTERFACE>");
            String netClass = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<NET_CLASS>", "</NET_CLASS>");
            networkInterconnect = netInterface == null || netInterface.length() == 0 ? "\"*\":" : "\"" + netInterface + "\":";
            networkInterconnect = networkInterconnect + netSubDomain + ":" + netClass;
            VerificationUtil.setVariableValue("INTERCONNECT_LIST", networkInterconnect);
            Trace.out((String)("network interconnect=" + networkInterconnect));
            return true;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        if (!mute) {
            String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ReportUtil.printError(errMsg);
        }
        return false;
    }

    public static CSSMode getCSSMode() {
        String[] args = new String[]{GET_CSSMODE_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get crsuser" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                if (CSSMode.cssBCCLUSTERED.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssBCCLUSTERED;
                }
                if (CSSMode.cssCLUSTERED.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssCLUSTERED;
                }
                if (CSSMode.cssEXCLUSIVE.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssEXCLUSIVE;
                }
                if (CSSMode.cssLOCALONLY.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssLOCALONLY;
                }
                return CSSMode.cssNULL;
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static ASMPresence getASMPresence() {
        if (m_asmPresence != null) {
            return m_asmPresence;
        }
        String[] args = new String[]{GET_ASM_ATTRIBUTE, PRESENCE};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                try {
                    m_asmPresence = ASMPresence.getEnumMember(outArr[0]);
                }
                catch (EnumConstNotFoundException e) {
                    Trace.out((String)("output for asm presence was " + outArr[0]));
                }
                return m_asmPresence;
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static int getASMCount() {
        String[] args = new String[]{GET_ASM_ATTRIBUTE, ASM_COUNT};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return -1;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return -1;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return -1;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return Integer.parseInt(outArr[0]);
            }
            Trace.out((String)"no output from cvuhelper");
            return -1;
        }
        Trace.out((String)"cvuhelper produced no output");
        return -1;
    }

    public static NodeRole getNodeConfiguredRole(String node) {
        String roleType = "CONFIGURED";
        String[] args = new String[]{GET_NODE_ROLE, roleType, node};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                int role = Integer.parseInt(outArr[0]);
                return NodeRole.getEnumMember((int)role);
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static NodeRole getNodeActiveRole(String node, boolean active) {
        String roleType = "ACTIVE";
        String[] args = new String[]{GET_NODE_ROLE, roleType, node};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        Object scanDetailsArr = null;
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = VerificationUtil.strArr2List(output);
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
                String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                Trace.out((String)errMsg);
            } else {
                int role = Integer.parseInt(VerificationUtil.strArr2List(CVUHelperUtil.fetchOutput(output)));
                return NodeRole.getEnumMember((int)role);
            }
        }
        return null;
    }

    public static String[] getNodeNames(NodeRole nodeRole) {
        String[] args = new String[]{GET_NODE_NAMES, nodeRole.getRole() + ""};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return VerificationUtil.string2strArr(outArr[0]);
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static boolean isASMLocal() {
        return CVUHelperUtil.getASMPresence() == ASMPresence.LOCAL;
    }

    public static boolean isASMFar() {
        return CVUHelperUtil.getASMPresence() == ASMPresence.FAR;
    }

    public static boolean isASMNear() {
        return CVUHelperUtil.getASMPresence() == ASMPresence.NEAR;
    }

    public static String validateGNSCredential(String gnsCredFile) {
        String[] args = new String[]{VALIDATE_GNS_CREDENTIAL, gnsCredFile};
        String[] env = null;
        String gnsDomain = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() != 0) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get GNS subdomain " + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                gnsDomain = VerificationUtil.fetchTextByTags(outArr[0], "<GNS_DOMAIN_NAME>", "</GNS_DOMAIN_NAME>");
                return gnsDomain;
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        return null;
    }

    public static String getASMSid(Result result) {
        String[] args = new String[]{GET_ASM_INSTANCE, VerificationUtil.getLocalHostName()};
        String[] env = null;
        CVUHelperExec helperExec = null;
        result.setStatus(1);
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to get ASM sid");
                String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(3);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                Trace.out((String)("Fetched ASM instance successfully; returning '" + outArr[0] + "'"));
                return outArr[0];
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(3);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }
}

