/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CommandsUtil {
    protected String m_osName = null;
    protected String m_awk = "/bin/awk";
    protected String m_grep = "/bin/grep";
    protected String m_nslookup = "/usr/bin/nslookup";
    protected String m_cat = "/bin/cat";
    protected String m_df = "/bin/df";
    protected String m_ping = "/bin/ping";
    protected String m_cp = "/bin/cp";
    protected String m_ls = "/bin/ls";
    protected String m_nsswitch = "/etc/nsswitch.conf";
    protected String m_groups = "/bin/groups";
    protected String m_sudo = "/usr/local/bin/sudo";
    protected String m_chkconfig = null;

    public CommandsUtil() {
        Trace.out((String)"Commands defined");
        this.m_osName = VerificationUtil.getCurrentOS();
        if (this.m_osName.equalsIgnoreCase("Linux")) {
            this.m_chkconfig = "/sbin/chkconfig";
        } else if (this.m_osName.equalsIgnoreCase("Solaris")) {
            this.m_nslookup = "/usr/sbin/nslookup";
        } else if (this.m_osName.equalsIgnoreCase("SunOS")) {
            this.m_nslookup = "/usr/sbin/nslookup";
        } else if (!(this.m_osName.equalsIgnoreCase("HP-UX") || this.m_osName.equalsIgnoreCase("HP_UX") || this.m_osName.equalsIgnoreCase("Digital Unix"))) {
            if (this.m_osName.equalsIgnoreCase("AIX")) {
                this.m_nsswitch = "/etc/netsvc.conf";
            } else if (this.m_osName.equalsIgnoreCase("intel_solaris") || this.m_osName.equalsIgnoreCase("sinix_y") || this.m_osName.equalsIgnoreCase("reliantunix_m") || this.m_osName.equalsIgnoreCase("unix_alpha") || this.m_osName.equalsIgnoreCase("dynix") || this.m_osName.equalsIgnoreCase("dynix/ptx") || this.m_osName.equalsIgnoreCase("unixware") || this.m_osName.equalsIgnoreCase("nec") || this.m_osName.equalsIgnoreCase("ux/4800") || this.m_osName.equalsIgnoreCase("hitachi_ux") || this.m_osName.equalsIgnoreCase("iris") || this.m_osName.equalsIgnoreCase("ncos") || this.m_osName.equalsIgnoreCase("OpenVMS") || this.m_osName.equalsIgnoreCase("ibm_mvs")) {
                // empty if block
            }
        }
    }

    public String getAwk() {
        Trace.out((String)("Returning '" + this.m_grep + "'"));
        return this.m_awk;
    }

    public String getGrep() {
        Trace.out((String)("Returning '" + this.m_grep + "'"));
        return this.m_grep;
    }

    public String getNslookup() {
        return this.m_nslookup;
    }

    public String getNsswitch() {
        return this.m_nsswitch;
    }

    public String getCat() {
        return this.m_cat;
    }

    public String getDf() {
        return this.m_df;
    }

    public String getPing() {
        return this.m_ping;
    }

    public String getCp() {
        return this.m_cp;
    }

    public String getLs() {
        return this.m_ls;
    }

    public String getGroups() {
        return this.m_groups;
    }

    public String getSudo() {
        return this.m_sudo;
    }

    public String getChkConfig() {
        return this.m_chkconfig;
    }
}

