/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import oracle.cluster.verification.common.CVUException;
import oracle.cluster.wallet.CLSWAliasNotExistException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.CVUDatabaseWallet;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HeavyWeightVerificationUtil
implements VerificationConstants {
    private static MessageBundle m_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle m_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static Util s_AlertLogContext = null;

    public static void printGlobalAlertLog(int msgNumber, String[] args) {
        StringBuilder sb = new StringBuilder();
        for (String msg : args) {
            int sbLen = sb.length();
            if (sbLen + msg.length() + 1 > 750) {
                Trace.out((String)"writing to alert log");
                boolean skipMsg = false;
                if (sbLen == 0) {
                    Trace.out((String)(msg + " greater than max alert message length"));
                    sb.append(msg);
                    skipMsg = true;
                }
                HeavyWeightVerificationUtil.writeToAlertLog(msgNumber, sb);
                if (skipMsg) continue;
                Trace.out((String)"starting a new sb");
                sb = new StringBuilder(msg);
                continue;
            }
            sb.append(msg);
            sb.append(VerificationConstants.LINE_SEPARATOR);
        }
        if (sb.length() != 0) {
            HeavyWeightVerificationUtil.writeToAlertLog(msgNumber, sb);
        }
    }

    public static String getDBPassword(String database, String userName) throws CVUException {
        if (!"DBSNMP".equalsIgnoreCase(userName)) {
            Trace.out((String)("userName=" + userName + " passed. supported user is " + "DBSNMP"));
            throw new CVUException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        String password = null;
        try {
            CVUDatabaseWallet wallet = CVUDatabaseWallet.getInstance();
            wallet.open();
            password = wallet.getPassword(database);
            wallet.close();
        }
        catch (CLSWAliasNotExistException CLSWAEx) {
            Trace.out((String)("CLSWAliasNotExistException occured: msg=" + CLSWAEx.getMessage()));
            throw new CVUException(m_prvgMsgBundle, "11415", userName, database);
        }
        catch (CLSWException CLSWEx) {
            Trace.out((String)("CLSWException occured: msg" + CLSWEx.getMessage()));
            throw new CVUException(CLSWEx);
        }
        return password;
    }

    private static void writeToAlertLog(int msgNumber, StringBuilder sb) {
        try {
            if (s_AlertLogContext == null) {
                s_AlertLogContext = new Util();
            }
            s_AlertLogContext.writeToAlertLog(msgNumber, sb.toString());
            Trace.out((String)"after write alert log");
        }
        catch (UtilException e) {
            Trace.out((String)"Util exception writing to alert log");
            ReportUtil.sureprintln(sb.toString() + VerificationConstants.LINE_SEPARATOR + e.getMessage());
        }
    }

    protected void finalize() {
        if (s_AlertLogContext != null) {
            try {
                Trace.out((String)"closing alert log context");
                s_AlertLogContext.terminateAlertLogContext();
            }
            catch (UtilException e) {
                Trace.out((String)"Util exception closing alert log context");
                Trace.out((String)e.getMessage());
            }
        }
    }
}

