/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.Vector;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;

class OraInvHome {
    public static final int CRS_HOME = 1;
    public static final int ORACLE_HOME = 2;
    private int MIN_TYPE = 1;
    private int MAX_TYPE = 2;
    String m_name;
    String m_location;
    int m_type;
    Vector m_nodelist;

    OraInvHome(String name, String loc, int type, Vector nodelist) throws InvalidOUIInventoryDataException {
        if (name == null || name.trim().length() <= 0 || loc == null || loc.trim().length() <= 0 || type < this.MIN_TYPE || type > this.MAX_TYPE || nodelist == null) {
            throw new InvalidOUIInventoryDataException("Invalid data for OraInvHome");
        }
        this.m_name = name;
        this.m_location = loc;
        this.m_type = type;
        this.m_nodelist = nodelist;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLocation() {
        return this.m_location;
    }

    public int getType() {
        return this.m_type;
    }

    public Vector getNodelist() {
        return (Vector)this.m_nodelist.clone();
    }

    public String[] getNodelistAsStrArr() {
        String[] nodes = new String[this.m_nodelist.size()];
        for (int i = 0; i < this.m_nodelist.size(); ++i) {
            nodes[i] = (String)this.m_nodelist.get(i);
        }
        return nodes;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        String type = this.m_type == 1 ? "CRS-HOME" : "ORACLE-HOME";
        StringBuffer sb = new StringBuffer("Oracle home properties: " + lineSep);
        sb.append("Name     : " + this.m_name + lineSep);
        sb.append("Type     : " + type + lineSep);
        sb.append("Location : " + this.m_location + lineSep);
        sb.append("Node list: " + this.m_nodelist.toString() + lineSep);
        return sb.toString();
    }
}

