/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RootUserCredentials {
    private static UserInfo m_userInfo = null;
    private static ConfigurationSetup.ConfigMethod m_execMode = null;
    private static boolean m_isRootAccessConfigured = false;
    private static String m_location = null;
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public RootUserCredentials(ConfigurationSetup.ConfigMethod execMode, UserInfo creds) {
        m_userInfo = creds;
        m_execMode = execMode;
        m_isRootAccessConfigured = true;
        if (m_execMode == ConfigurationSetup.ConfigMethod.SUDO || m_execMode == ConfigurationSetup.ConfigMethod.PBRUN) {
            m_location = new CommandsUtil().getSudo();
        }
    }

    public RootUserCredentials(ConfigurationSetup.ConfigMethod execMode, UserInfo creds, String location) {
        m_userInfo = creds;
        m_execMode = execMode;
        m_location = location;
        m_isRootAccessConfigured = true;
    }

    public static boolean isRootCredentialsAvailable() {
        return m_isRootAccessConfigured;
    }

    public static ConfigurationSetup.ConfigMethod getRootExecutionMode() throws RootAutomationNotConfiguredException {
        if (!m_isRootAccessConfigured) {
            throw new RootAutomationNotConfiguredException(s_gMsgBundle.getMessage("11304", true));
        }
        return m_execMode;
    }

    public static UserInfo getRootUserCredentials() throws RootAutomationNotConfiguredException {
        if (!m_isRootAccessConfigured) {
            throw new RootAutomationNotConfiguredException(s_gMsgBundle.getMessage("11304", true));
        }
        return m_userInfo;
    }

    public static String getSudoPbrunLocation() throws RootAutomationNotConfiguredException {
        if (!m_isRootAccessConfigured) {
            throw new RootAutomationNotConfiguredException(s_gMsgBundle.getMessage("11304", true));
        }
        return m_location;
    }
}

