/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ops.mgmt.trace.Trace;

public class VerificationLogData {
    public static final int FINE_LOG = 1;
    public static final int INFO_LOG = 2;
    public static final int WARNING_LOG = 3;
    public static final int ERROR_LOG = 4;
    public static final int SEVERE_LOG = 5;
    private static boolean s_packageVerificationLogDataEnabled = true;
    private static Hashtable s_packageVerificationLogDataTable = new Hashtable();
    private static String[] s_packageNames = new String[]{"oracle.ops.mgmt.asm", "oracle.ops.mgmt.cluster", "oracle.ops.mgmt.daemon", "oracle.ops.mgmt.command", "oracle.ops.mgmt.command.db", "oracle.ops.mgmt.command.file", "oracle.ops.mgmt.command.listener", "oracle.ops.mgmt.command.service", "oracle.ops.mgmt.command.registry", "oracle.ops.mgmt.command.daemon", "oracle.ops.mgmt.command.util", "oracle.ops.mgmt.synchronize", "oracle.ops.mgmt.database", "oracle.ops.mgmt.nativesystem", "oracle.ops.mgmt.nodeapps", "oracle.ops.mgmt.rawdevice", "oracle.ops.mgmt.operation", "oracle.ops.mgmt.operation.ha"};
    private static String s_strVerificationLogDataFileName;
    private static String s_strJavaNewLine;
    private static String s_strFinalizer;
    private static Throwable s_thVerificationLogData;
    private static List<String> m_loggerData;

    public static void setPackageLogging(String packageNames, boolean packageLogging) {
        s_packageVerificationLogDataEnabled = packageLogging;
        if (packageNames != null && packageNames.length() != 0) {
            s_packageVerificationLogDataEnabled = true;
            StringTokenizer st = new StringTokenizer(packageNames, ",");
            while (st.hasMoreTokens()) {
                String singlePackageName = st.nextToken();
                if (singlePackageName == null || singlePackageName.length() == 0) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                Integer integer = (Integer)s_packageVerificationLogDataTable.get(singlePackageName);
                if (integer == null) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                s_packageVerificationLogDataTable.put(singlePackageName, new Integer(1));
            }
        } else {
            s_packageVerificationLogDataEnabled = false;
        }
    }

    public static synchronized void setVerificationLogData(List<String> logData) {
        m_loggerData = logData;
    }

    public static synchronized List<String> getVerificationLogData() {
        return m_loggerData;
    }

    public static void log(String strText) {
        VerificationLogData.internalLog(strText, 2);
    }

    public static void logFine(String strText) {
        VerificationLogData.internalLog(strText, 1);
    }

    public static void logInfo(String strText) {
        VerificationLogData.internalLog(strText, 2);
    }

    public static void logWarning(String strText) {
        VerificationLogData.internalLog(strText, 3);
    }

    public static void logError(String strText) {
        VerificationLogData.internalLog(strText, 4);
    }

    public static void logSevere(String strText) {
        VerificationLogData.internalLog(strText, 5);
    }

    public static void traceLogData() {
        Trace.out((String)"======================================================================\n===================== VERIFICATION LOG DATA ==========================\n======================================================================");
        for (String err : m_loggerData) {
            Trace.out((String)err);
        }
    }

    private static synchronized void internalLog(String strText, int level) {
        int numFramesToSkip;
        String logPrefix = "";
        switch (level) {
            case 1: {
                logPrefix = new String("FINE: ");
                break;
            }
            case 2: {
                logPrefix = new String("INFO: ");
                break;
            }
            case 3: {
                logPrefix = new String("WARNING: ");
                break;
            }
            case 4: {
                logPrefix = new String("ERROR: ");
                break;
            }
            case 5: {
                logPrefix = new String("SEVERE: ");
                break;
            }
            default: {
                logPrefix = new String("UNKNOWN: ");
            }
        }
        s_thVerificationLogData = new Throwable();
        StackTraceElement[] elements = s_thVerificationLogData.getStackTrace();
        if (elements.length == 0) {
            m_loggerData.add(logPrefix + strText);
            return;
        }
        for (numFramesToSkip = 0; numFramesToSkip < elements.length && elements[numFramesToSkip].getClassName().endsWith("VerificationLogData"); ++numFramesToSkip) {
        }
        StackTraceElement stElem = elements[numFramesToSkip];
        String log_info_line = stElem.toString();
        String packageName = VerificationLogData.extractPackageName(log_info_line);
        String className = stElem.getClassName();
        logPrefix = logPrefix + "[" + (className.length() > packageName.length() ? className.substring(packageName.length() + 1) : className) + "." + (stElem.isNativeMethod() ? "Native" : stElem.getMethodName() + ":" + stElem.getLineNumber()) + "]  ";
        strText = logPrefix + strText;
        m_loggerData.add(strText);
    }

    private static String getStackTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] elements = throwable.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                sb.append(s_strJavaNewLine + elements[i].toString());
                continue;
            }
            sb.append(elements[i].toString());
        }
        return sb.toString();
    }

    private static String extractPackageName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        int count = st.countTokens();
        StringBuffer buf = new StringBuffer();
        String packagename = null;
        for (int i = 0; i < count - 4; ++i) {
            String newtoken = st.nextToken();
            buf.append(newtoken + ".");
        }
        buf.append(st.nextToken());
        packagename = buf.toString();
        return packagename;
    }

    static {
        s_strJavaNewLine = System.getProperty("line.separator");
        s_strFinalizer = "[* Finalizer *] ";
        m_loggerData = new ArrayList<String>();
        for (int i = 0; i < s_packageNames.length; ++i) {
            s_packageVerificationLogDataTable.put(s_packageNames[i], new Integer(0));
        }
        String packageNames = System.getProperty("TRACING.PACKAGE");
        if (packageNames != null && packageNames.length() != 0) {
            StringTokenizer st = new StringTokenizer(packageNames, ",");
            while (st.hasMoreTokens()) {
                String singlePackageName = st.nextToken();
                if (singlePackageName == null || singlePackageName.length() == 0) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                Integer integer = (Integer)s_packageVerificationLogDataTable.get(singlePackageName);
                if (integer == null) {
                    s_packageVerificationLogDataEnabled = false;
                    break;
                }
                s_packageVerificationLogDataTable.put(singlePackageName, new Integer(1));
            }
        } else {
            s_packageVerificationLogDataEnabled = false;
        }
    }
}

