/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.REF;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class ArrayDescriptor
extends TypeDescriptor
implements Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public ArrayDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super(oracleTypeCOLLECTION, connection);
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super(sQLName, oracleTypeCOLLECTION, connection);
    }

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        ArrayDescriptor arrayDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        if ((arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection)).getName())) == null) {
            arrayDescriptor = new ArrayDescriptor(sQLName, connection);
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "  ";
            ++n2;
        }
        String string2 = String.valueOf(string) + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        int n3 = this.getBaseType();
        if (n3 == 2002 || n3 == 2008) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.getBaseName(), this.m_conn);
            structDescriptor.descType(stringBuffer, n + 1);
        } else if (n3 == 2003) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.getBaseName(), this.m_conn);
            arrayDescriptor.descType(stringBuffer, n + 1);
        } else if (n3 == 2007) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(this.getBaseName(), this.m_conn);
            opaqueDescriptor.descType(stringBuffer, n + 1);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(this.getBaseName());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int getArrayType() throws SQLException {
        return ((OracleTypeCOLLECTION)this.m_pickler).getUserCode();
    }

    public String getBaseName() throws SQLException {
        switch (this.getBaseType()) {
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMBER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 91: {
                return "DATE";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.m_pickler).getElementType();
                return oracleNamedType.getFullName();
            }
            case 2006: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.m_pickler).getElementType();
                return "REF " + ((OracleTypeREF)oracleNamedType).getFullName();
            }
        }
        return null;
    }

    public int getBaseType() throws SQLException {
        return ((OracleTypeCOLLECTION)this.m_pickler).getElementType().getTypeCode();
    }

    public static int getCacheStyle(ARRAY aRRAY) throws SQLException {
        if (aRRAY.getAutoIndexing() && (aRRAY.getAccessDirection() == 2 || aRRAY.getAccessDirection() == 3)) {
            return 1;
        }
        return 2;
    }

    private OracleType getElementType() throws SQLException {
        return ((OracleTypeCOLLECTION)this.m_pickler).getElementType();
    }

    public long getMaxLength() throws SQLException {
        return this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.m_pickler).getMaxLength() : 0L;
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        return (OracleTypeCOLLECTION)this.m_pickler;
    }

    public int getTypeCode() throws SQLException {
        return 2003;
    }

    private void initPickler() throws SQLException {
        try {
            OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getName(), this.m_conn);
            oracleTypeADT.init((OracleConnection)this.m_conn);
            this.m_pickler = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DBError.throwSqlException(60, "Unable to resolve type: \"" + this.getName() + "\"");
        }
    }

    public int length(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.m_conn, byArray);
        return this.toLength(aRRAY);
    }

    public static Object[] makeJavaArray(int n, int n2) throws SQLException {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return new BigDecimal[n];
            }
            case 1: 
            case 12: {
                return new String[n];
            }
            case 91: 
            case 92: 
            case 93: {
                return new Timestamp[n];
            }
            case 2002: 
            case 2008: {
                return new Object[n];
            }
            case -13: {
                return new BFILE[n];
            }
            case 2004: {
                return new BLOB[n];
            }
            case 2005: {
                return new CLOB[n];
            }
            case -3: 
            case -2: {
                return new byte[n][];
            }
            case 2006: {
                return new REF[n];
            }
            case 2003: {
                return new Object[n];
            }
        }
        DBError.check_error(1, "makeJavaArray doesn't support type " + n2);
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("ArrayDescriptor::readObject");
        }
    }

    public Datum[] toArray(Object object) throws SQLException {
        return this.toOracleArray(object, 1L, -1);
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        ARRAY aRRAY = new ARRAY(this, this.m_conn, byArray);
        return this.toOracleArray(aRRAY, 1L, -1, false);
    }

    private Object[] toArrayFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        int n2 = this.toLengthFromLocator(byArray);
        int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
        if (n3 <= 0) {
            return ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, map);
        int n4 = 0;
        while (resultSet.next()) {
            objectArray[n4] = ((OracleResultSet)resultSet).getObject(2, map);
            ++n4;
        }
        resultSet.close();
        return objectArray;
    }

    byte[] toBytes(ARRAY aRRAY, boolean bl) throws SQLException {
        byte[] byArray = aRRAY.shareBytes();
        if (byArray == null) {
            if (aRRAY.m_datumArray != null || aRRAY.m_locator != null) {
                byArray = this.m_pickler.linearize(aRRAY);
                if (!bl) {
                    aRRAY.setShareBytes(null);
                }
            } else if (aRRAY.m_objArray != null) {
                aRRAY.m_datumArray = this.toOracleArray(aRRAY.m_objArray, 1L, -1);
                byArray = this.m_pickler.linearize(aRRAY);
                if (!bl) {
                    aRRAY.m_datumArray = null;
                    aRRAY.setShareBytes(null);
                }
            } else {
                DBError.throwSqlException(1, "Array is in inconsistent status");
            }
        } else if (aRRAY.m_imgLength != 0L && (aRRAY.m_imgOffset != 0L || aRRAY.m_imgLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)aRRAY.m_imgLength];
            System.arraycopy(byArray, (int)aRRAY.m_imgOffset, byArray2, 0, (int)aRRAY.m_imgLength);
            aRRAY.setImage(byArray2, 0L, 0L);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.m_conn, datumArray);
        return this.m_pickler.linearize(aRRAY);
    }

    Object[] toJavaArray(ARRAY aRRAY, long l, int n, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (aRRAY.m_objArray != null) {
            objectArray = (Object[])((Object[])aRRAY.m_objArray).clone();
            int n2 = objectArray.length;
            int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
            if (n3 <= 0) {
                return ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
            }
            objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
            System.arraycopy(aRRAY.m_objArray, (int)l - 1, objectArray, 0, n3);
        } else {
            if (aRRAY.m_datumArray != null) {
                objectArray = (Object[])this.toJavaArray(aRRAY.m_datumArray, l, n, map);
            } else if (aRRAY.m_locator != null) {
                objectArray = this.toArrayFromLocator(aRRAY.m_locator, l, n, map);
            } else if (aRRAY.shareBytes() != null) {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, l, n, 2, map);
                objectArray = aRRAY.m_locator != null ? this.toArrayFromLocator(aRRAY.m_locator, l, n, map) : (Object[])aRRAY.m_objArray;
            } else {
                DBError.throwSqlException(1);
            }
            aRRAY.m_objArray = bl && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objectArray != null ? objectArray.clone() : null;
        }
        return objectArray;
    }

    private Object toJavaArray(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        int n2 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
        if (n2 < 0) {
            n2 = 0;
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n2, this.getBaseType());
        if (this.getBaseType() == 2002) {
            STRUCT sTRUCT = null;
            int n3 = 0;
            while (n3 < n2) {
                sTRUCT = (STRUCT)datumArray[(int)l + n3 - 1];
                objectArray[n3] = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
                ++n3;
            }
        } else {
            Datum datum = null;
            int n4 = 0;
            while (n4 < n2) {
                datum = datumArray[(int)l + n4 - 1];
                objectArray[n4] = datum != null ? datum.toJdbc() : null;
                ++n4;
            }
        }
        return objectArray;
    }

    int toLength(ARRAY aRRAY) throws SQLException {
        if (aRRAY.m_numElems == -1) {
            if (aRRAY.m_datumArray != null) {
                aRRAY.m_numElems = aRRAY.m_datumArray.length;
            } else if (aRRAY.m_objArray != null) {
                if (aRRAY.m_objArray instanceof Object[]) {
                    aRRAY.m_numElems = ((Object[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof int[]) {
                    aRRAY.m_numElems = ((long[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof long[]) {
                    aRRAY.m_numElems = ((float[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof float[]) {
                    aRRAY.m_numElems = ((double[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof double[]) {
                    aRRAY.m_numElems = ((boolean[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof boolean[]) {
                    aRRAY.m_numElems = ((int[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof byte[]) {
                    aRRAY.m_numElems = ((byte[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof short[]) {
                    aRRAY.m_numElems = ((short[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof char[]) {
                    aRRAY.m_numElems = ((char[])aRRAY.m_objArray).length;
                }
            } else if (aRRAY.m_locator != null) {
                aRRAY.m_numElems = this.toLengthFromLocator(aRRAY.m_locator);
            } else if (aRRAY.shareBytes() != null) {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, 0, null);
                if (aRRAY.m_numElems == -1) {
                    if (aRRAY.m_locator != null) {
                        aRRAY.m_numElems = this.toLengthFromLocator(aRRAY.m_locator);
                    } else {
                        DBError.throwSqlException(1, "Unable to get array length");
                    }
                }
            } else {
                DBError.check_error(1, "Array is in inconsistent status");
            }
        }
        return aRRAY.m_numElems;
    }

    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.m_conn, null);
        aRRAY.setLocator(byArray);
        int n = 0;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.m_conn.prepareStatement("SELECT count(*) FROM TABLE( CAST(? AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (oracleResultSet.next()) {
            n = oracleResultSet.getInt(1);
        } else {
            DBError.check_error(1, "Fail to access array storage table");
        }
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n;
    }

    Object toNumericArray(ARRAY aRRAY, long l, int n, int n2, boolean bl) throws SQLException {
        if (!(this.getElementType() instanceof OracleTypeNUMBER) && !(this.getElementType() instanceof OracleTypeFLOAT)) {
            DBError.throwSqlException(23);
        }
        if (aRRAY.m_objArray != null) {
            if (n2 == 4 && aRRAY.m_objArray instanceof int[]) {
                int n3 = ((int[])aRRAY.m_objArray).length;
                if (l > (long)n3) {
                    return new int[0];
                }
                n3 = (int)(n == -1 ? (long)n3 - l + 1L : Math.min((long)n3 - l + 1L, (long)n));
                int[] nArray = new int[n3];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, nArray, 0, n3);
                return nArray;
            }
            if (n2 == 5 && aRRAY.m_objArray instanceof double[]) {
                int n4 = ((double[])aRRAY.m_objArray).length;
                if (l > (long)n4) {
                    return new double[0];
                }
                n4 = (int)(n == -1 ? (long)n4 - l + 1L : Math.min((long)n4 - l + 1L, (long)n));
                double[] dArray = new double[n4];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, dArray, 0, n4);
                return dArray;
            }
            if (n2 == 6 && aRRAY.m_objArray instanceof float[]) {
                int n5 = ((float[])aRRAY.m_objArray).length;
                if (l > (long)n5) {
                    return new float[0];
                }
                n5 = (int)(n == -1 ? (long)n5 - l + 1L : Math.min((long)n5 - l + 1L, (long)n));
                float[] fArray = new float[n5];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, fArray, 0, n5);
                return fArray;
            }
            if (n2 == 7 && aRRAY.m_objArray instanceof long[]) {
                int n6 = ((long[])aRRAY.m_objArray).length;
                if (l > (long)n6) {
                    return new long[0];
                }
                n6 = (int)(n == -1 ? (long)n6 - l + 1L : Math.min((long)n6 - l + 1L, (long)n));
                long[] lArray = new long[n6];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, lArray, 0, n6);
                return lArray;
            }
            if (n2 == 8 && aRRAY.m_objArray instanceof short[]) {
                int n7 = ((short[])aRRAY.m_objArray).length;
                if (l > (long)n7) {
                    return new short[0];
                }
                n7 = (int)(n == -1 ? (long)n7 - l + 1L : Math.min((long)n7 - l + 1L, (long)n));
                short[] sArray = new short[n7];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, sArray, 0, n7);
                return sArray;
            }
        }
        Object object = null;
        if (aRRAY.m_datumArray != null) {
            object = this.toNumericArray(aRRAY.m_datumArray, l, n, n2);
        } else if (aRRAY.m_locator != null) {
            object = this.toNumericArrayFromLocator(aRRAY.m_locator, l, n, n2);
        } else if (aRRAY.shareBytes() != null) {
            this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, l, n, n2, null);
            object = aRRAY.m_locator != null ? this.toNumericArrayFromLocator(aRRAY.m_locator, l, n, n2) : aRRAY.m_objArray;
        } else {
            DBError.throwSqlException(1);
        }
        if (!bl) {
            aRRAY.m_objArray = null;
        }
        return object;
    }

    private Object toNumericArray(Datum[] datumArray, long l, int n, int n2) throws SQLException {
        int n3 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 == 4) {
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                Datum datum = datumArray[(int)l + n4 - 1];
                if (datum != null) {
                    nArray[n4] = datum.intValue();
                }
                ++n4;
            }
            return nArray;
        }
        if (n2 == 5) {
            double[] dArray = new double[n3];
            int n5 = 0;
            while (n5 < n3) {
                Datum datum = datumArray[(int)l + n5 - 1];
                if (datum != null) {
                    dArray[n5] = datum.doubleValue();
                }
                ++n5;
            }
            return dArray;
        }
        if (n2 == 6) {
            float[] fArray = new float[n3];
            int n6 = 0;
            while (n6 < n3) {
                Datum datum = datumArray[(int)l + n6 - 1];
                if (datum != null) {
                    fArray[n6] = datum.floatValue();
                }
                ++n6;
            }
            return fArray;
        }
        if (n2 == 7) {
            long[] lArray = new long[n3];
            int n7 = 0;
            while (n7 < n3) {
                Datum datum = datumArray[(int)l + n7 - 1];
                if (datum != null) {
                    lArray[n7] = datum.longValue();
                }
                ++n7;
            }
            return lArray;
        }
        if (n2 == 8) {
            short[] sArray = new short[n3];
            int n8 = 0;
            while (n8 < n3) {
                Datum datum = datumArray[(int)l + n8 - 1];
                if (datum != null) {
                    sArray[n8] = ((NUMBER)datum).shortValue();
                }
                ++n8;
            }
            return sArray;
        }
        DBError.throwSqlException(23);
        return null;
    }

    private Object toNumericArrayFromLocator(byte[] byArray, long l, int n, int n2) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, null);
        int n4 = 0;
        if (n2 == 4) {
            int[] nArray = new int[n3];
            while (resultSet.next() && n4 < n3) {
                nArray[n4++] = ((OracleResultSet)resultSet).getInt(2);
            }
            resultSet.close();
            return nArray;
        }
        if (n2 == 5) {
            double[] dArray = new double[n3];
            while (resultSet.next() && n4 < n3) {
                dArray[n4++] = ((OracleResultSet)resultSet).getDouble(2);
            }
            resultSet.close();
            return dArray;
        }
        if (n2 == 6) {
            float[] fArray = new float[n3];
            while (resultSet.next() && n4 < n3) {
                fArray[n4++] = ((OracleResultSet)resultSet).getFloat(2);
            }
            resultSet.close();
            return fArray;
        }
        if (n2 == 7) {
            long[] lArray = new long[n3];
            while (resultSet.next() && n4 < n3) {
                lArray[n4++] = ((OracleResultSet)resultSet).getLong(2);
            }
            resultSet.close();
            return lArray;
        }
        if (n2 == 8) {
            short[] sArray = new short[n3];
            while (resultSet.next() && n4 < n3) {
                sArray[n4++] = ((OracleResultSet)resultSet).getShort(2);
            }
            resultSet.close();
            return sArray;
        }
        DBError.throwSqlException(23);
        return null;
    }

    Datum[] toOracleArray(Object object, long l, int n) throws SQLException {
        if (object == null) {
            return null;
        }
        OracleType oracleType = this.getElementType();
        return oracleType.toDatumArray(object, (OracleConnection)this.m_conn, l, n);
    }

    Datum[] toOracleArray(ARRAY aRRAY, long l, int n, boolean bl) throws SQLException {
        Datum[] datumArray = aRRAY.m_datumArray;
        if (datumArray == null) {
            if (aRRAY.m_objArray != null) {
                datumArray = this.toOracleArray(aRRAY.m_objArray, l, n);
            } else if (aRRAY.m_locator != null) {
                datumArray = this.toOracleArrayFromLocator(aRRAY.m_locator, l, n, null);
            } else if (aRRAY.shareBytes() != null) {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, l, n, 1, null);
                datumArray = aRRAY.m_locator != null ? this.toOracleArrayFromLocator(aRRAY.m_locator, l, n, null) : aRRAY.m_datumArray;
                if (!bl) {
                    aRRAY.m_datumArray = null;
                }
            } else {
                DBError.throwSqlException(1);
            }
        } else {
            if (l > (long)datumArray.length) {
                return new Datum[0];
            }
            int n2 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
            datumArray = new Datum[n2];
            System.arraycopy(aRRAY.m_datumArray, (int)l - 1, datumArray, 0, n2);
        }
        if (bl) {
            aRRAY.m_datumArray = datumArray;
            return (Datum[])datumArray.clone();
        }
        return datumArray;
    }

    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        int n2 = this.toLengthFromLocator(byArray);
        int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
        if (n3 <= 0) {
            return new Datum[0];
        }
        Datum[] datumArray = new Datum[n3];
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, map);
        int n4 = 0;
        while (resultSet.next()) {
            datumArray[n4] = ((OracleResultSet)resultSet).getOracleObject(2);
            ++n4;
        }
        resultSet.close();
        return datumArray;
    }

    public ResultSet toResultSet(ARRAY aRRAY, long l, int n, Map map, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        if (aRRAY.m_datumArray != null) {
            resultSet = this.toResultSet(aRRAY.m_datumArray, l, n, map);
        } else if (aRRAY.m_locator != null) {
            resultSet = this.toResultSetFromLocator(aRRAY.m_locator, l, n, map);
        } else if (aRRAY.m_objArray != null) {
            resultSet = this.toResultSet(this.toOracleArray(aRRAY.m_objArray, l, n), 1L, -1, map);
        } else if (aRRAY.shareBytes() != null) {
            if (((OracleTypeCOLLECTION)this.m_pickler).isInlineImage(aRRAY.shareBytes(), (int)aRRAY.m_imgOffset)) {
                resultSet = this.toResultSetFromImage(aRRAY, l, n, map);
            } else {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, 1, null);
                if (aRRAY.m_locator != null) {
                    resultSet = this.toResultSetFromLocator(aRRAY.m_locator, l, n, map);
                } else {
                    DBError.throwSqlException(1);
                }
            }
        }
        if (resultSet == null) {
            DBError.check_error(1, "Unable to create array ResultSet");
        }
        return resultSet;
    }

    public ResultSet toResultSet(byte[] byArray, long l, int n, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        ARRAY aRRAY = (ARRAY)this.m_pickler.unlinearize(byArray, 0L, null, 1, null);
        return this.toResultSet(aRRAY, l, n, map, false);
    }

    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        ARRAY aRRAY = (ARRAY)this.m_pickler.unlinearize(byArray, 0L, null, 1, null);
        return this.toResultSet(aRRAY, 1L, -1, map, false);
    }

    public ResultSet toResultSet(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        if (n == -1) {
            return new ArrayDataResultSet((OracleConnection)this.m_conn, datumArray, l, datumArray.length, map);
        }
        return new ArrayDataResultSet((OracleConnection)this.m_conn, datumArray, l, n, map);
    }

    public ResultSet toResultSetFromImage(ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        return new ArrayDataResultSet((OracleConnection)this.m_conn, aRRAY, l, n, map);
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        return new ArrayLocatorResultSet((OracleConnection)this.m_conn, this, byArray, l, n, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("ArrayDescriptor::writeObject");
        }
    }
}

