/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.ConverterArchive;

public abstract class CharacterConverter
implements Serializable {
    static final String CONVERTERNAMEPREFIX = "converter_xcharset/CharacterConverter";
    static final String CONVERTERIDPREFIX = "0000";
    static final String EX_MAP_ORACLE_TO_UCS = "Cannot map Oracle character to Unicode.";
    static final String EX_MAP_UCS_TO_ORACLE = "Cannot map Unicode to Oracle character.";
    static final int STORE_INCREMENT = 10;
    public static final int CHARCONV1BYTEID = 0;
    public static final int CHARCONV12BYTEID = 1;
    public static final int CHARCONVJAEUCID = 2;
    public static final int CHARCONVLCFIXEDID = 3;
    public static final int CHARCONVSJISID = 4;
    public static final int CHARCONVZHTEUCID = 5;
    public static final int CHARCONV2BYTEFIXEDID = 6;
    public static final int CHARCONVSHIFTID = 7;
    public static final int CHARCONVLCID = 8;
    public static final int CHARCONVGB18030ID = 9;
    static CharacterConverter[] m_converterStore;
    public int m_groupId;
    public int m_oracleId;

    public abstract void buildUnicodeToOracleMapping();

    public abstract void extractCodepoints(Vector var1);

    public abstract void extractExtraMappings(Vector var1);

    public int getGroupId() {
        return this.m_groupId;
    }

    public static final CharacterConverter getInstance(int n) {
        String string;
        String string2;
        ConverterArchive converterArchive;
        CharacterConverter characterConverter = null;
        int n2 = 0;
        int n3 = 0;
        if (m_converterStore != null) {
            n3 = m_converterStore.length;
            n2 = 0;
            while (n2 < n3) {
                characterConverter = m_converterStore[n2];
                if (characterConverter == null) break;
                if (characterConverter.getOracleId() == n) {
                    return characterConverter;
                }
                ++n2;
            }
        }
        if ((characterConverter = (CharacterConverter)(converterArchive = new ConverterArchive()).readObj(String.valueOf(string2 = CONVERTERNAMEPREFIX + CONVERTERIDPREFIX.substring(0, 4 - (string = Integer.toHexString(n)).length()) + string) + ".glb")) == null) {
            return null;
        }
        characterConverter.buildUnicodeToOracleMapping();
        if (n2 == n3) {
            int n4 = n3 + 10;
            CharacterConverter[] characterConverterArray = new CharacterConverter[n4];
            if (n3 > 0) {
                System.arraycopy(m_converterStore, 0, characterConverterArray, 0, n3);
            }
            m_converterStore = characterConverterArray;
        }
        CharacterConverter.m_converterStore[n2] = characterConverter;
        return characterConverter;
    }

    public abstract char getOraChar1ByteRep();

    public abstract char getOraChar2ByteRep();

    public int getOracleId() {
        return this.m_oracleId;
    }

    public abstract char getUCS2CharRep();

    public abstract boolean hasExtraMappings();

    public abstract byte[] toOracleString(String var1) throws SQLException;

    public abstract byte[] toOracleStringWithReplacement(String var1);

    public abstract String toUnicodeString(byte[] var1, int var2, int var3) throws SQLException;

    public abstract String toUnicodeStringWithReplacement(byte[] var1, int var2, int var3);
}

