/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class OUILdap {
    public static String rootOracleContextDN = "cn=OracleContext";
    public static String commonDN = "cn=Common,cn=Products,cn=OracleContext";

    public static PropertySetCollection getEntryDetails(DirContext dirContext, String string, String string2, int n, String[] stringArray) throws NamingException {
        return (PropertySetCollection)OUILdap.getEntryDetails(dirContext, string, string2, n, stringArray, true);
    }

    public static Object getEntryDetails(DirContext dirContext, String string, String string2, int n, String[] stringArray, boolean bl) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(n);
        searchControls.setReturningAttributes(stringArray);
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, string2, searchControls);
        if (bl) {
            return new PropertySetCollection(string, namingEnumeration);
        }
        return namingEnumeration;
    }

    public static int ldapCompare(DirContext dirContext, String string, String string2, Object object) throws UtilException {
        String string3 = (String)object;
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[0]);
        searchControls.setSearchScope(0);
        try {
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string, "(" + string2 + "=" + string3 + ")", searchControls);
            if (namingEnumeration.hasMore()) {
                return 0;
            }
            return 1;
        }
        catch (NamingException namingException) {
            return 2;
        }
    }

    public static PropertySetCollection getOwnership(DirContext dirContext, String string, String[] stringArray, boolean bl) throws UtilException {
        PropertySetCollection propertySetCollection = null;
        propertySetCollection = bl ? OUILdap.getGroups(dirContext, string, stringArray, "owner") : OUILdap.getDirectGroupMembership(dirContext, string, stringArray, "owner");
        return propertySetCollection;
    }

    public static PropertySetCollection getGroupMembership(DirContext dirContext, String string, String[] stringArray, boolean bl) throws UtilException {
        PropertySetCollection propertySetCollection = null;
        propertySetCollection = bl ? OUILdap.getGroups(dirContext, string, stringArray, "uniquemember") : OUILdap.getDirectGroupMembership(dirContext, string, stringArray, "uniquemember");
        return propertySetCollection;
    }

    private static PropertySetCollection getDirectGroupMembership(DirContext dirContext, String string, String[] stringArray, String string2) throws UtilException {
        return OUILdap.getDirectGroupMembershipVector(dirContext, string, stringArray, string2);
    }

    private static PropertySetCollection getDirectGroupMembershipVector(DirContext dirContext, String string, String[] stringArray, String string2) throws UtilException {
        Vector vector = new Vector();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(stringArray);
        try {
            return OUILdap.getEntryDetails(dirContext, "", "(" + string2 + "=" + string + ")", 2, stringArray);
        }
        catch (NamingException namingException) {
            return new PropertySetCollection();
        }
    }

    private static PropertySetCollection getGroups(DirContext dirContext, String string, String[] stringArray, String string2) throws UtilException {
        PropertySetCollection propertySetCollection = OUILdap.getDirectGroupMembershipVector(dirContext, string, stringArray, string2);
        PropertySetCollection propertySetCollection2 = new PropertySetCollection();
        return OUILdap.getGroupsRecursive(dirContext, string, stringArray, string2, propertySetCollection2, propertySetCollection);
    }

    private static PropertySetCollection getGroupsRecursive(DirContext dirContext, String string, String[] stringArray, String string2, PropertySetCollection propertySetCollection, PropertySetCollection propertySetCollection2) throws UtilException {
        if (propertySetCollection2.size() == 0) {
            return propertySetCollection;
        }
        PropertySet propertySet = propertySetCollection2.remove(0);
        if (OUILdap.contains(propertySet, propertySetCollection)) {
            return OUILdap.getGroupsRecursive(dirContext, string, stringArray, string2, propertySetCollection, propertySetCollection2);
        }
        PropertySetCollection propertySetCollection3 = OUILdap.getDirectGroupMembershipVector(dirContext, propertySet.getDN(), stringArray, string2);
        int n = 0;
        while (n < propertySetCollection3.size()) {
            if (!OUILdap.contains(propertySetCollection3.getPropertySet(n), propertySetCollection)) {
                propertySetCollection2.add(propertySetCollection3.getPropertySet(n));
            }
            ++n;
        }
        PropertySetCollection propertySetCollection4 = new PropertySetCollection();
        int n2 = 0;
        while (n2 < propertySetCollection.size()) {
            propertySetCollection4.add(propertySetCollection.getPropertySet(n2));
            ++n2;
        }
        propertySetCollection4.add(propertySet);
        return OUILdap.getGroupsRecursive(dirContext, string, stringArray, string2, propertySetCollection4, propertySetCollection2);
    }

    protected static String[] vector2StrArray(Vector vector) {
        if (vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    private static boolean contains(PropertySet propertySet, PropertySetCollection propertySetCollection) throws UtilException {
        String string = OUILdap.normalizeDN(propertySet.getDN());
        int n = 0;
        while (n < propertySetCollection.size()) {
            String string2 = propertySetCollection.getPropertySet(n).getDN();
            if (string.equals(OUILdap.normalizeDN(string2))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String normalizeDN(String string, String[] stringArray) throws UtilException {
        return OUILdap.normalizeDN(string, 0, stringArray, null);
    }

    private static String normalizeDN(String string, int n, String[] stringArray, DirContext dirContext) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n2 = n;
        String string2 = "";
        String string3 = string;
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        if (n2 == 3) {
            vector = new Vector<String>();
            vector2 = new Vector<String>();
        }
        while (string3.length() > 0) {
            int n3;
            Object var15_15 = null;
            if (bl) {
                n3 = string3.indexOf("=");
                if (n3 <= 0) break;
                String string4 = string3.substring(0, n3).trim().toLowerCase();
                if (n2 == 3) {
                    vector.addElement(string4);
                }
                if (stringArray != null) {
                    // empty if block
                }
                string2 = string2 + string4 + "=";
                string3 = string3.substring(n3 + 1).trim();
                bl = false;
                bl2 = true;
            } else if (bl2) {
                if (string3.startsWith("\"")) {
                    n3 = string3.indexOf("\"", 1);
                    string2 = string2 + string3.substring(0, n3 + 1);
                    if (n2 == 3) {
                        vector2.addElement(string3.substring(0, n3 + 1));
                    }
                    string3 = string3.substring(n3 + 1).trim();
                    bl3 = true;
                } else {
                    bl3 = false;
                }
                bl2 = false;
            } else {
                n3 = string3.indexOf(",");
                if (n3 >= 0) {
                    string2 = string2 + string3.substring(0, n3).trim().toLowerCase() + ",";
                    if (n2 == 3 && !bl3) {
                        vector2.addElement(string3.substring(0, n3).trim().toLowerCase());
                    }
                    string3 = string3.substring(n3 + 1);
                    bl = true;
                } else {
                    string2 = string2 + string3.trim().toLowerCase();
                    if (n2 == 3 && !bl3) {
                        vector2.addElement(string3.trim().toLowerCase());
                    }
                    string3 = "";
                    bl = true;
                    bl4 = true;
                }
            }
            if (n2 == 0) continue;
            if (bl && n2 == 1) {
                if (string2.endsWith(",")) {
                    return string2.substring(0, string2.length() - 1);
                }
                return string2;
            }
            if (!bl || n2 != 2) continue;
            string2 = "";
            n2 = 0;
        }
        return string2;
    }

    public static String normalizeDN(String string) throws UtilException {
        if (string == null) {
            return null;
        }
        return OUILdap.normalizeDN(string, 0, null, null);
    }

    public static void printResults(PropertySetCollection propertySetCollection) {
        int n = 0;
        while (n < propertySetCollection.size()) {
            PropertySet propertySet = propertySetCollection.getPropertySet(n);
            Object object = null;
            System.out.println("dn: " + propertySet.getDN());
            int n2 = 0;
            while (n2 < propertySet.size()) {
                Property property = propertySet.getProperty(n2);
                int n3 = 0;
                while (n3 < property.size()) {
                    object = property.getValue(n3);
                    if (object instanceof String) {
                        System.out.println(property.getName() + ": " + (String)object);
                    } else if (object instanceof byte[]) {
                        System.out.println(property.getName() + ": NON ASCII");
                    }
                    ++n3;
                }
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public static String getIAC_DNFromFQHN(String string) throws UtilException {
        if (string != null) {
            String string2 = new String();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() < 2) {
                throw new UtilException("Domain name too short to create identity administration context");
            }
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.countTokens() > 1 ? string2 + "dc=" + stringTokenizer.nextToken() + "," : string2 + "dc=" + stringTokenizer.nextToken();
            }
            return string2;
        }
        return null;
    }

    public static String getParentDN(String string) throws UtilException {
        return OUILdap.normalizeDN(string, 2, null, null);
    }

    public static String getRDN(String string) throws UtilException {
        return OUILdap.normalizeDN(string, 1, null, null);
    }

    static boolean dnExists(DirContext dirContext, String string) {
        PropertySetCollection propertySetCollection = OUILdap.dnExists(dirContext, string, new String[0]);
        return propertySetCollection != null;
    }

    static PropertySetCollection dnExists(DirContext dirContext, String string, String[] stringArray) {
        try {
            PropertySetCollection propertySetCollection = OUILdap.getEntryDetails(dirContext, string, "(objectclass=*)", 0, stringArray);
            return propertySetCollection;
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public static void addUniquemember(DirContext dirContext, String string, String string2) throws UtilException {
        try {
            BasicAttributes basicAttributes = new BasicAttributes("uniquemember", string2);
            dirContext.modifyAttributes(string, 1, (Attributes)basicAttributes);
        }
        catch (NamingException namingException) {
            throw new UtilException("NamingException encountered in addUniqueMember", namingException);
        }
    }

    public static void removeUniquemember(DirContext dirContext, String string, String string2) throws UtilException {
        try {
            ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("uniquemember", string2))};
            dirContext.modifyAttributes(string, modificationItemArray);
        }
        catch (NamingException namingException) {
            throw new UtilException("NamingException encountered in removeUniqueMember", namingException);
        }
    }

    public static void bulkDelete(DirContext dirContext, String string, boolean bl) throws NamingException {
        try {
            Vector vector;
            PropertySetCollection propertySetCollection = OUILdap.getEntryDetails(dirContext, string, "(objectclass=*)", 2, new String[0]);
            Vector vector2 = new Vector(30);
            int n = 0;
            while (n < 30) {
                vector2.insertElementAt(new Vector(), n);
                ++n;
            }
            int n2 = new StringTokenizer(string, ",").countTokens() - 1;
            int n3 = 0;
            while (n3 < propertySetCollection.size()) {
                String string2 = propertySetCollection.getPropertySet(n3).getDN();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                vector = (Vector)vector2.elementAt(stringTokenizer.countTokens() - 1 - n2);
                vector.add(string2);
                ++n3;
            }
            int n4 = bl ? 0 : 1;
            int n5 = 29;
            while (n5 >= n4) {
                vector = (Vector)vector2.elementAt(n5);
                if (!vector.isEmpty()) {
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        dirContext.destroySubcontext((String)vector.elementAt(n6));
                        ++n6;
                    }
                }
                --n5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getAttrOfRDN(String string) {
        return string.substring(0, string.indexOf("="));
    }

    public static String getAttrValueOfRDN(String string) {
        return string.substring(string.indexOf("=") + 1);
    }

    public static PropertySetCollection ldapSearch(DirContext dirContext, String string, String string2, int n, String[] stringArray) throws UtilException {
        try {
            return OUILdap.getEntryDetails(dirContext, string, string2, n, stringArray);
        }
        catch (NamingException namingException) {
            throw new UtilException("NamingException encountered in ldapSearch", namingException);
        }
    }

    public void ldapDelete(DirContext dirContext, String string) throws UtilException {
        try {
            dirContext.destroySubcontext(string);
        }
        catch (NamingException namingException) {
            throw new UtilException("NamingException encountered in ldapDelete", namingException);
        }
    }

    public boolean isMember(DirContext dirContext, String string, String string2, boolean bl) throws UtilException {
        String string3 = OUILdap.normalizeDN(string2);
        PropertySetCollection propertySetCollection = OUILdap.getGroupMembership(dirContext, string, new String[0], bl);
        int n = 0;
        while (n < propertySetCollection.size()) {
            if (string3.equals(OUILdap.normalizeDN(propertySetCollection.getPropertySet(n).getDN()))) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

