/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;

public class PropertySet {
    private String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private Vector attributeVector = null;
    private String DN = null;
    private Attributes attributeSet = null;

    protected PropertySet() {
        this.attributeVector = new Vector();
    }

    protected PropertySet(String string, Attributes attributes, Vector vector) {
        this.DN = new String(string);
        this.attributeSet = attributes;
        this.attributeVector = vector;
    }

    protected PropertySet(String string, SearchResult searchResult) {
        this.attributeVector = new Vector();
        this.DN = searchResult.getName().length() > 0 ? (string.equals("") ? new String(searchResult.getName()) : new String(searchResult.getName() + "," + string)) : new String(string);
        this.attributeSet = searchResult.getAttributes();
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = this.attributeSet.getAll();
            while (namingEnumeration.hasMore()) {
                this.attributeVector.addElement(namingEnumeration.next());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public final boolean isEmpty() {
        return this.attributeVector.isEmpty();
    }

    public final int size() {
        return this.attributeVector.size();
    }

    public final String[] getAttributeNames() {
        int n = this.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((Attribute)this.attributeVector.elementAt(n2)).getID();
            ++n2;
        }
        return stringArray;
    }

    public final Property getProperty(int n) {
        return new Property((Attribute)this.attributeVector.elementAt(n));
    }

    public final Property getProperty(String string) {
        Property property = null;
        Attribute attribute = this.attributeSet.get(string);
        if (attribute != null) {
            property = new Property(attribute);
        }
        return property;
    }

    public final String getDN() {
        return this.DN;
    }

    protected void mergePropertySet(PropertySet propertySet) {
        Attributes attributes = propertySet.getAttributeSet();
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMore()) {
                Attribute attribute = namingEnumeration.next();
                this.attributeVector.addElement(attribute);
                this.attributeSet.put(attribute);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    protected String[] getMissingAttributes(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            Attribute attribute = this.attributeSet.get(stringArray[n]);
            System.out.println("curAttr:  " + stringArray[n]);
            if (attribute == null) {
                vector.add(stringArray[n]);
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    protected PropertySet returnPropertySet(String[] stringArray) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        Vector<Attribute> vector = new Vector<Attribute>();
        int n = 0;
        while (n < stringArray.length) {
            Attribute attribute = this.attributeSet.get(stringArray[n]);
            if (attribute != null) {
                vector.addElement(attribute);
                basicAttributes.put(attribute);
            }
            ++n;
        }
        return new PropertySet(this.getDN(), basicAttributes, vector);
    }

    protected Attributes getAttributeSet() {
        return this.attributeSet;
    }

    protected PropertySet doSearch(DirContext dirContext, String[] stringArray) throws UtilException {
        try {
            String[] stringArray2 = this.getMissingAttributes(stringArray);
            PropertySetCollection propertySetCollection = null;
            if (stringArray2.length > 0) {
                propertySetCollection = OUILdap.getEntryDetails(dirContext, this.DN, "(objectclass=*)", 0, stringArray2);
                this.mergePropertySet(propertySetCollection.getPropertySet(0));
            }
            return this.returnPropertySet(stringArray);
        }
        catch (NamingException namingException) {
            throw new UtilException("error in property set doSearch: " + this.DN, namingException);
        }
    }
}

