/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionCloneCapable;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilCommitException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilUndoException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OcfsFormat
implements OiilAction,
OiilActionCloneCapable {
    public String getDescription(Vector inputs) {
        return "Formats the selected drive, if successful: " + this.retItem(inputs, "DriveLetter");
    }

    public void cloneAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        this.installAction(inputs, outLogObjects);
    }

    public void installAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        String[] DriveLetter;
        String[] env = null;
        String[] input = null;
        String ExString = "Drive letter NOT available or does not exist";
        String Args1 = new String("/f");
        String Args2 = new String("/m");
        String ExeName = new String(System.getProperty("oracle.installer.NatLibDir") + "ocfsformat.exe");
        String DriveLetterInput = this.retItem(inputs, "DriveLetter");
        String AllocationUnit = this.retItem(inputs, "AllocationUnit");
        StringTokenizer st = new StringTokenizer(DriveLetterInput, "|");
        int driveCounter = 0;
        int numberOfDrives = 0;
        if (st != null) {
            numberOfDrives = st.countTokens();
        }
        if (numberOfDrives != 0) {
            DriveLetter = new String[numberOfDrives];
            while (st.hasMoreTokens()) {
                DriveLetter[driveCounter++] = st.nextToken();
            }
        } else {
            System.out.println("Error during ocfsformat: No Drives to Format");
            throw new OiilActionException("CouldNotFormatDrive", ExString);
        }
        String[] cmd = new String[6];
        cmd[0] = ExeName;
        cmd[1] = Args1;
        cmd[2] = Args2;
        cmd[4] = new String("/c");
        cmd[5] = AllocationUnit;
        try {
            for (int i = 0; i < DriveLetter.length; ++i) {
                cmd[3] = DriveLetter[i];
                System.out.println("DriveLetter[" + i + "]:" + DriveLetter[i]);
                RuntimeExec runtimeExec = new RuntimeExec(cmd, input, env);
                int returnVal = runtimeExec.runCommand();
                String[] output = runtimeExec.getOutput();
                String[] error = runtimeExec.getError();
                System.out.println("Return Value is:" + returnVal);
                if (returnVal < 1) continue;
                System.out.println("Error during ocfsformat for Drive:" + cmd[3] + "==>" + returnVal);
                throw new OiilActionException("CouldNotFormatDrive", ExString);
            }
        }
        catch (OiilActionException ne) {
            System.out.println("Error during ocfsformat " + (Object)((Object)ne));
        }
    }

    public void deinstallAction(Vector inputs, Vector inLogObjects) throws OiilDeinstallException {
    }

    public void saveAndInstallAction(Vector inputs, Vector outLogObjects, Vector outBackupObjects) throws OiilActionException {
    }

    public void saveAndDeinstallAction(Vector inputs, Vector inLogObjects, Vector outLogObjects, Vector outBackupObjects) throws OiilDeinstallException {
    }

    public void undoInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilUndoException {
    }

    public void undoDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilUndoException {
    }

    public void commitInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilCommitException {
    }

    public void commitDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilCommitException {
    }

    private String retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return (String)aie.getObject();
    }

    public static void main(String[] args) {
        OcfsFormat testfmt = new OcfsFormat();
        String drive = "e:|h:|";
        String Alunit = "1024";
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        Vector output = new Vector();
        inputs.addElement(new OiilActionInputElement("DriveLetter", (Object)drive));
        inputs.addElement(new OiilActionInputElement("AllocationUnit", (Object)Alunit));
        try {
            testfmt.installAction(inputs, output);
        }
        catch (OiilActionException e) {
            // empty catch block
        }
    }
}

