/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.asm.bean.ASMInputValidationErrorCode;
import oracle.install.asm.bean.DiskGroupSettings;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.DiskGroupInitPurpose;
import oracle.install.asm.util.Redundancy;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.util.CRSConstants;
import oracle.install.library.util.DBConstants;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.PlatformInfo;

public class ASMInputValidationHelper {
    private static final int ASM_DISKGROUP_NAME_SIZE = 30;
    private static Logger logger = Logger.getLogger(ASMInputValidationHelper.class.getName());

    private static int getMinimumDiskCount(DiskGroupInitPurpose purpose, Redundancy redundancy) {
        int diskCount = 0;
        if (redundancy != null) {
            if (purpose == DiskGroupInitPurpose.METADATA) {
                switch (redundancy) {
                    case EXTERNAL: {
                        diskCount = 1;
                        break;
                    }
                    case NORMAL: {
                        diskCount = 3;
                        break;
                    }
                    case HIGH: {
                        diskCount = 5;
                    }
                }
            } else {
                diskCount = redundancy.getValue();
            }
        }
        return diskCount;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskGroup(String diskGroupName, boolean isOradataOnASM, boolean isBackupRecoveryOnASM, boolean isContainerDB) {
        StatusMessages errorMessages = new StatusMessages();
        try {
            ASMUtility asmUtility = ASMUtility.getInstance();
            ASMInstance asmInstance = asmUtility.getASMInstance();
            if (asmInstance == null) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_INSTANCE_NOT_FOUND, new Object[0]));
            }
            if (diskGroupName == null || diskGroupName.trim().length() == 0) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.NO_ASM_DISKGROUP_SELECTED, new Object[0]));
            }
            if (asmInstance != null) {
                List<DiskGroup> diskGroups = asmUtility.getDiskGroups(asmInstance);
                if (diskGroups == null || diskGroups.isEmpty()) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.NO_ASM_DISKGROUP_FOUND, new Object[]{asmInstance.getSid()}));
                } else {
                    DiskGroup selectedDiskGroup = null;
                    for (DiskGroup diskGroup : diskGroups) {
                        if (!diskGroupName.equals(diskGroup.getName())) continue;
                        selectedDiskGroup = diskGroup;
                        break;
                    }
                    if (selectedDiskGroup == null) {
                        errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.UNKNOWN_ASM_DISKGROUP, new Object[]{diskGroupName}));
                    } else {
                        ValidationStatusMessage errMessage = ASMInputValidationHelper.validateFreeSpace(selectedDiskGroup, isOradataOnASM, isBackupRecoveryOnASM, isContainerDB);
                        if (errMessage != null) {
                            errorMessages.add((StatusMessage)errMessage);
                        }
                    }
                }
            }
        }
        catch (ASMUtilityException e) {
            ExceptionManager.handle((Throwable)((Object)e));
        }
        return errorMessages;
    }

    public static ValidationStatusMessage validateFreeSpace(DiskGroup diskGroup, boolean oradataOnASM, boolean backupRecoveryOnASM) {
        return ASMInputValidationHelper.validateFreeSpace(diskGroup, oradataOnASM, backupRecoveryOnASM, false);
    }

    public static ValidationStatusMessage validateFreeSpace(DiskGroup diskGroup, boolean oradataOnASM, boolean backupRecoveryOnASM, boolean isContainerDB) {
        ValidationStatusMessage errorMessage = null;
        if (diskGroup != null) {
            Redundancy redundancy = diskGroup.getRedundancy();
            long freeSpaceRequired = ASMInputValidationHelper.getFreeSpaceRequired(oradataOnASM, backupRecoveryOnASM, isContainerDB, redundancy);
            if (diskGroup.getFreeSpace() < freeSpaceRequired) {
                errorMessage = new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_ASM_DISKGROUP, new Object[]{String.valueOf(freeSpaceRequired)});
            }
        }
        return errorMessage;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskGroupSettings(DiskGroupSettings diskGroupSettings) {
        return ASMInputValidationHelper.validateDiskGroupSettings(diskGroupSettings, DiskGroupInitPurpose.USERDATA, 1);
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskGroupSettings(DiskGroupSettings diskGroupSettings, DiskGroupInitPurpose purpose, int nodeCount) {
        StatusMessages errorMessageList = null;
        if (diskGroupSettings != null) {
            errorMessageList = new StatusMessages();
            errorMessageList.addAll(ASMInputValidationHelper.validateDiskDiscoveryString(diskGroupSettings.getDiskDiscoveryString()));
            StatusMessages<ValidationStatusMessage> errorMessages = ASMInputValidationHelper.validateGroupName(diskGroupSettings.getGroupName(), diskGroupSettings.getDiskDiscoveryString());
            if (errorMessages != null) {
                errorMessageList.addAll(errorMessages);
            }
            if ((errorMessages = ASMInputValidationHelper.validateAUSize(diskGroupSettings.getAUSize())) != null) {
                errorMessageList.addAll(errorMessages);
            }
            errorMessageList.addAll(ASMInputValidationHelper.validateDiskPaths(diskGroupSettings.getDiskPaths(), diskGroupSettings.getRedundancy(), purpose, nodeCount));
        }
        return errorMessageList;
    }

    public static StatusMessages<ValidationStatusMessage> validateAUSize(int AUSize) {
        StatusMessages errorMessages = new StatusMessages();
        if (!Arrays.asList(CRSConstants.AUSizes).contains(AUSize)) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_DISKGROUP_AUSIZE_NOT_VALID, new Object[]{Arrays.toString((Object[])CRSConstants.AUSizes)}));
        }
        return errorMessages;
    }

    public static StatusMessages<ValidationStatusMessage> validateGroupName(String groupName, String diskDiscoveryString) {
        StatusMessages errorMessages;
        block8: {
            errorMessages = new StatusMessages();
            if (groupName == null || groupName.trim().length() == 0) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_DISKGROUP_NAME_EXPECTED, new Object[0]));
            } else {
                Set<String> sql_reserved_words;
                String badChars = ASMInputValidationHelper.getBadCharsForDiskGroupName();
                String strFoundBadChar = GenericValidation.validateBadCharGetString(badChars, groupName);
                Pattern pattern = Pattern.compile("[a-zA-Z]");
                Matcher matcher = pattern.matcher(Character.toString(groupName.charAt(0)));
                if (strFoundBadChar != null && strFoundBadChar.length() > 0 || !matcher.matches()) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_ASM_DISKGROUP_NAME, new Object[0]));
                }
                if (groupName.length() > 30) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.DISKGROUP_NAME_SIZE_EXCEEDED, new Object[]{30}));
                }
                if ((sql_reserved_words = ASMInputValidationHelper.getReservedWordsForSQL()).contains(groupName)) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INCORRECT_ASM_DISKGROUP_NAME, new Object[0]));
                }
                try {
                    ASMUtility asmUtility = ASMUtility.getInstance();
                    List<String> discoveredGroups = asmUtility.findDiskgroupsFromHeader(diskDiscoveryString);
                    if (discoveredGroups == null || discoveredGroups.size() <= 0) break block8;
                    for (String diskgroup : discoveredGroups) {
                        if (!diskgroup.equalsIgnoreCase(groupName)) continue;
                        errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.NON_UNIQUE_ASM_DISKS, new Object[0]));
                        break;
                    }
                }
                catch (ASMUtilityException e) {
                    ExceptionManager.handle((Throwable)((Object)e));
                }
            }
        }
        return errorMessages.size() > 0 ? errorMessages : null;
    }

    private static String getBadCharsForDiskGroupName() {
        String badChars = null;
        badChars = PlatformInfo.getInstance().isWindows() ? "!@%^&*-()+=|/`~[{]};'\",<>?." : "!@%^&*()+=-|`~[{]};:'\",<>?\\.";
        return badChars;
    }

    private static Set<String> getReservedWordsForSQL() {
        String[] sql_reserved_Words = CRSConstants.sql_reserved_words;
        TreeSet<String> sql_reserved_words_set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < sql_reserved_Words.length; ++i) {
            sql_reserved_words_set.add(sql_reserved_Words[i]);
        }
        return sql_reserved_words_set;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskDiscoveryString(String diskDiscoveryString) {
        StatusMessages errorMessages = new StatusMessages();
        String badChars = null;
        if (!PlatformInfo.getInstance().isWindows() && diskDiscoveryString != null && diskDiscoveryString.length() > 0) {
            String[] pathList = diskDiscoveryString.split(",");
            badChars = "\\?$";
            if (pathList.length > 0) {
                for (String path : pathList) {
                    String strFoundBadChar = GenericValidation.validateBadCharGetString(badChars, path);
                    if (strFoundBadChar == null || strFoundBadChar.length() <= 0) continue;
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_DISK_DISCOVERY_STRING, new Object[0]));
                    break;
                }
            }
        }
        return errorMessages;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskPaths(List<String> diskPaths, Redundancy redundancy) {
        return ASMInputValidationHelper.validateDiskPaths(diskPaths, redundancy, DiskGroupInitPurpose.USERDATA, 1);
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskPaths(List<String> diskPaths, Redundancy redundancy, DiskGroupInitPurpose purpose, int nodeCount) {
        int minimumDiskCount;
        StatusMessages errorMessages = new StatusMessages();
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        int validDiskCount = 0;
        if (diskPaths == null || diskPaths.isEmpty()) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.EMPTY_ASM_DISKGROUP, new Object[0]));
        } else {
            try {
                ASMUtility asmUtility = ASMUtility.getInstance();
                List<Disk> disks = asmUtility.findDisks(diskPaths.toArray(new String[0]));
                String invalidDisks = null;
                if (disks == null) {
                    invalidDisks = diskPaths.toString();
                } else {
                    ArrayList<String> diskPathsCopy = new ArrayList<String>();
                    if (platformInfo.isWindows()) {
                        for (String diskPath : diskPaths) {
                            diskPathsCopy.add(diskPath.toUpperCase());
                        }
                    } else {
                        diskPathsCopy.addAll(diskPaths);
                    }
                    for (Disk disk : disks) {
                        diskPathsCopy.remove(platformInfo.isWindows() ? disk.getPath().toUpperCase() : disk.getPath());
                    }
                    invalidDisks = diskPathsCopy.isEmpty() ? null : diskPathsCopy.toString();
                    validDiskCount = diskPaths.size() - diskPathsCopy.size();
                }
                if (invalidDisks != null) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_ASM_DISKS, new Object[]{invalidDisks}));
                }
            }
            catch (ASMUtilityException e) {
                ExceptionManager.handle((Throwable)((Object)e));
            }
        }
        if (validDiskCount > 0 && redundancy != null && validDiskCount < (minimumDiskCount = ASMInputValidationHelper.getMinimumDiskCount(purpose, redundancy))) {
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            String redundancyString = resource.getString(redundancy.name(), redundancy.name(), new Object[0]);
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_MEMBER_DISKS, new Object[]{redundancyString, String.valueOf(minimumDiskCount)}));
        }
        return errorMessages;
    }

    public static long getDiskSize(List<String> diskPaths) {
        long size = 0L;
        if (diskPaths != null) {
            try {
                ASMUtility asmUtility = ASMUtility.getInstance();
                List<Disk> disks = asmUtility.findDisks(diskPaths.toArray(new String[0]));
                if (disks != null && disks.size() > 0) {
                    for (Disk disk : disks) {
                        size += disk.getSize();
                    }
                }
            }
            catch (ASMUtilityException e) {
                ExceptionManager.handle((Throwable)((Object)e));
            }
        }
        return size;
    }

    public static StatusMessages<ValidationStatusMessage> checkASMFreeSpaceRequired(List<String> diskPaths, Redundancy redundancy, DiskGroupInitPurpose purpose, int nodeCount, int additionRequiredSpace) {
        StatusMessages errorMessages = new StatusMessages();
        long size = 0L;
        if (diskPaths != null) {
            long requiredSize = 0L;
            size = ASMInputValidationHelper.getDiskSize(diskPaths);
            if (purpose == DiskGroupInitPurpose.METADATA) {
                requiredSize = ASMInputValidationHelper.getRequiredSizeCRS(redundancy, diskPaths, nodeCount);
                logger.log(Level.FINEST, "Required CRS Size=" + requiredSize);
                logger.log(Level.FINEST, "Addition size=" + additionRequiredSpace);
                if (size < (requiredSize += (long)additionRequiredSpace)) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_ASM_DISKS, new Object[]{requiredSize}));
                }
            }
        }
        return errorMessages;
    }

    public static StatusMessages<ValidationStatusMessage> checkASMFreeSpaceRequired(List<String> diskPaths, long requiredSize) {
        StatusMessages errorMessages = new StatusMessages();
        long size = 0L;
        logger.log(Level.FINEST, "Required CRS Size=" + requiredSize);
        if (diskPaths != null && (size = ASMInputValidationHelper.getDiskSize(diskPaths)) < requiredSize) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_ASM_DISKS, new Object[]{requiredSize}));
        }
        return errorMessages;
    }

    private static long getRequiredSizeCRS(Redundancy redundancy, List<String> diskPaths, int nodeCount) {
        int diskCount = diskPaths.size();
        int vdMult = 1;
        int ocrMult = 1;
        switch (redundancy) {
            case EXTERNAL: {
                vdMult = 1;
                ocrMult = 1;
                break;
            }
            case NORMAL: {
                vdMult = 3;
                ocrMult = 2;
                break;
            }
            case HIGH: {
                vdMult = 5;
                ocrMult = 3;
            }
        }
        long dataSize = 300 * vdMult + 500 * ocrMult;
        long metaSize = 15 + 2 * diskCount + 126 * nodeCount;
        return dataSize + metaSize;
    }

    public static ValidationStatusMessage validateRedundancy(Redundancy redundancy) {
        ValidationStatusMessage errorMessage = null;
        if (redundancy == null) {
            errorMessage = new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_ASM_DISKGROUP_REDUNDANCY, new Object[0]);
        }
        return errorMessage;
    }

    public static long getFreeSpaceRequired(boolean isOradataOnASM, boolean isBackupRecoveryOnASM, boolean isContainerDB, Redundancy redundancy) {
        PlatformInfo platformInfo;
        boolean windows;
        long freeSpace = 0L;
        long defaultSize = DBConstants.ORADATA_SIZE_FOR_UNIX;
        if (isContainerDB) {
            defaultSize = DBConstants.ORADATA_WITH_CDB_SIZE_FOR_UNIX;
        }
        if (windows = (platformInfo = PlatformInfo.getInstance()).isWindows()) {
            defaultSize = DBConstants.ORADATA_SIZE_FOR_NT;
            if (isContainerDB) {
                defaultSize = DBConstants.ORADATA_WITH_CDB_SIZE_FOR_NT;
            }
        }
        if (isOradataOnASM) {
            freeSpace += defaultSize;
        }
        if (isBackupRecoveryOnASM) {
            freeSpace += defaultSize * 2L;
        }
        return freeSpace *= (long)redundancy.getValue();
    }

    public static void validateASMStorage() throws ValidationException {
        try {
            ASMUtility utility = ASMUtility.getInstance();
            ASMInstance asmInstance = utility.getASMInstance();
            if (asmInstance == null || !asmInstance.getOracleHome().exists() || asmInstance.getOracleHome().list() == null || asmInstance.getOracleHome().list().length == 0) {
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_NOT_COMPATIBLE, new Object[0]);
            }
        }
        catch (ASMUtilityException e) {
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_NOT_COMPATIBLE, new Object[0]);
        }
    }
}

