/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.util.ArrayList;
import java.util.List;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.util.Version;

class ClientsOpOutputParser
extends KFODOpOutputParser {
    private List<OracleService> clients = new ArrayList<OracleService>();

    public List<OracleService> getClients() {
        return this.clients;
    }

    @Override
    public void parseLine(String line) {
        String[] tokens = Helper.tokenize(line);
        if (tokens.length == 2) {
            try {
                String sid = tokens[0];
                Version version = Version.parseVersion((String)tokens[1]);
                OracleServiceRegistry registry = OracleServiceRegistry.getInstance();
                OracleService oracleService = registry.findServiceById(sid);
                if (oracleService != null) {
                    oracleService.setVersion(version);
                    this.clients.add(oracleService);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

