/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.asm.util.ASMUtilityErrorCode;
import oracle.install.commons.system.process.AbstractLineProcessor;

abstract class KFODOpOutputParser
extends AbstractLineProcessor {
    private static final Logger logger = Logger.getLogger(KFODOpOutputParser.class.getName());
    private boolean stopProcessing;
    private ASMUtilityErrorCode errorCode;

    KFODOpOutputParser() {
    }

    public void processLine(String line, int lineNumber) {
        if (!this.stopProcessing) {
            if (line.indexOf("kgxgncin") != -1) {
                this.stopProcessing = true;
                logger.log(Level.INFO, "Received output with token 'kgxgncin'. Stopping further parsing of stdout.");
            } else if (line.indexOf("ORA-01031") != -1) {
                this.errorCode = ASMUtilityErrorCode.ASM_ACCESS_DENIED;
                this.stopProcessing = true;
            } else {
                logger.log(Level.INFO, "Parsing {0}", line);
                this.parseLine(line.trim());
            }
        }
    }

    public abstract void parseLine(String var1);

    public ASMUtilityErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ASMUtilityErrorCode errorCode) {
        this.errorCode = errorCode;
    }
}

