/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.VerificationException;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerException;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.library.util.cvu.CVUHelper;

public class SupportedOSAction
extends DefaultAction {
    private static Logger logger = Logger.getLogger(SupportedOSAction.class.getName());

    public void execute(FlowContext flowContext) {
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
        String refDataFile = CVUHelper.getPrereqXML(autoBean.isApplyUpdates(), autoBean.getPatchDownloadLocation());
        try {
            CVUHelper cvuHelper = CVUHelper.getInstance();
            if (refDataFile != null && refDataFile.length() > 0) {
                logger.log(Level.FINEST, "Picking up cvu_prereq.xml from:" + refDataFile);
                cvuHelper.setPreReqXmlFile(refDataFile);
            }
        }
        catch (InvalidPathException e) {
            logger.log(Level.SEVERE, "Failed as cvu_prereq.xml is specified as " + refDataFile, e);
            ExceptionManager.handle((Throwable)new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.INVALID_PATH_OF_PREREQ_XML, new Object[]{refDataFile, e}));
        }
        catch (VerificationException e) {
            ExceptionManager.handle((Throwable)e);
        }
    }
}

