/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.util.List;
import java.util.Locale;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID;
import oracle.install.library.util.ProductInfo;

public class OracleInstaller
extends Installer {
    public static InstallerMode autoUpdatesMode;

    public OracleInstaller() {
        this.init();
    }

    protected void init() {
        ProductInfo productInfo = ProductInfo.getInstance();
        Locale locale = productInfo.getSuitableLocale();
        Locale.setDefault(locale);
        super.setLocale(locale);
    }

    public InstallerMode getInstallerMode() {
        return autoUpdatesMode;
    }

    public void setInstallerMode(InstallerMode autoUpdatesMode) {
        OracleInstaller.autoUpdatesMode = autoUpdatesMode;
    }

    protected void processArguments(List<String> args) throws IllegalArgumentException {
        if (args != null) {
            for (String s : args) {
                if (!s.equalsIgnoreCase("-downloadUpdates")) continue;
                this.setInstallerMode(InstallerMode.STANDALONE_DOWNLOAD_MODE);
                Resource resource = Application.getInstance().getResource("oracle.install.commons.base.resource.StringResourceBundle");
                String downloadText = resource.getString("wizard.btnDownload.text", null, new Object[0]);
                if (downloadText == null) break;
                resource.setProperty("wizard.btnFinish.text", (Object)downloadText);
                break;
            }
        }
        super.processArguments(args);
    }

    protected void run() {
        if (this.getInstallerMode() != null && this.getInstallerMode() == InstallerMode.STANDALONE_DOWNLOAD_MODE) {
            Resource autoUpdatesResource = Application.getInstance().getResource(AutoUpdatesDialogLabelResID.class.getName());
            String autoUpdatesOptionsText = autoUpdatesResource.getString("standAloneAutoUpdatesProvideMOSDetails.name", "Provide My Oracle Support credentials", new Object[0]);
            String autoUpdatesDownloadText = autoUpdatesResource.getString("standAloneAutoUpdatesDownload.name", "Download software updates", new Object[0]);
            Resource resource = Application.getInstance().getDefaultResource();
            resource.setProperty("AutoUpdatesOptionsUI.name", (Object)autoUpdatesOptionsText);
            resource.setProperty("UpdatesListUI.name", (Object)autoUpdatesDownloadText);
        }
        super.run();
    }

    public static enum InstallerMode {
        STANDALONE_DOWNLOAD_MODE;

    }
}

