/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.NodeScaler;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.library.util.InventoryInfo;

public class OracleNodeScaler
extends NodeScaler {
    private static Logger logger = Logger.getLogger(OracleNodeScaler.class.getName());
    private static NodeScaler scaler;
    public static final String DB_FLOW_CONFIG = "/oracle/install/ivw/db/resource/db-nodescaler-flow-config.xml";
    public static final String CRS_APPLICATION_CONFIG = "/oracle/install/ivw/crs/resource/crs-nodescaler-application-config.xml";
    public static final String CRS_FLOW_CONFIG = "/oracle/install/ivw/crs/resource/crs-nodescaler-flow-config.xml";
    public static final String DB_APPLICATION_CONFIG = "/oracle/install/ivw/db/resource/db-nodescaler-application-config.xml";

    public static void main(String[] args) {
        String oracleHome = "";
        for (String arg : args) {
            if (!arg.contains("ORACLE_HOME")) continue;
            oracleHome = arg.split("=")[1];
        }
        try {
            if (oracleHome != null && oracleHome.length() > 0 && InventoryInfo.getInstance().isInventoryExist()) {
                Class<?> clazz;
                if (InventoryInfo.getInstance().getComp(oracleHome, "oracle.crs") != null && (scaler = (NodeScaler)Application.getInstance(clazz = Class.forName("oracle.install.ivw.crs.driver.CRSNodeScaler"))) != null) {
                    scaler.startup(CRS_APPLICATION_CONFIG, CRS_FLOW_CONFIG, args);
                }
                if (InventoryInfo.getInstance().getComp(oracleHome, "oracle.server") != null && (scaler = (NodeScaler)Application.getInstance(clazz = Class.forName("oracle.install.ivw.db.driver.DBNodeScaler"))) != null) {
                    scaler.startup(DB_APPLICATION_CONFIG, DB_FLOW_CONFIG, args);
                }
            }
        }
        catch (Exception e) {
            ExceptionManager.handle((Throwable)e);
        }
    }
}

