/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.resource.AutoUpdatesErrorCode;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.autoupdates.AutoUpdatesInstallConstants;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.VendorClusterwareInfo;
import oracle.sysman.oii.oiii.OiiiInstallUpdate;

public class UpdatesRestartManager {
    private Logger logger = Logger.getLogger(UpdatesRestartManager.class.getName());
    private String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
    private UpdateManager updatesMngr = UpdateManager.getInstance();
    private static UpdatesRestartManager instance = null;

    public static UpdatesRestartManager getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (UpdatesRestartManager)(proxyFactory = ProxyFactory.getInstance()).createProxy(UpdatesRestartManager.class)) == null) {
            instance = new UpdatesRestartManager();
        }
        return instance;
    }

    public void prepareForRestart(AutoUpdatesInstallSettings autoBean) {
        try {
            XmlBeanStoreFormat format = new XmlBeanStoreFormat();
            BeanStoreUtils.storeAsXML((File)new File(this.scratchPathLoc, "restoreBeans.xml"), (XmlBeanStoreFormat)format, null, (boolean)true, (Object[])new Object[]{autoBean});
        }
        catch (BeanStoreException e) {
            this.logger.log(Level.WARNING, "The auto-updates bean was not successfully populated" + e.getCause());
        }
    }

    public void restartInstaller(String downloadLoc, int ouiBugID, int OPatchBugID) {
        String startupLoc = System.getProperty("oracle.installer.startup_location");
        String shiphomeLoc = new File(startupLoc).getParent();
        String scratchPath = System.getProperty("oracle.installer.scratchPath");
        String paramFile = startupLoc + File.separator + "oraparam.ini";
        String[] args = null;
        List argListPassed = Application.getInstance().getArguments();
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.addAll(argListPassed);
        if (ouiBugID == -1) {
            allArgs.add("-nobootStrap");
        }
        allArgs.add("-Doracle.installer.startup_location=" + startupLoc);
        String extraArgsForRestart = System.getProperty("RESTART_ARGS", "");
        if (extraArgsForRestart != null && extraArgsForRestart.length() > 0) {
            allArgs.add(extraArgsForRestart);
        } else if (PlatformInfo.getInstance().getCurrentPlatform() == 610) {
            allArgs.add("-J-Xbootclasspath/a:" + shiphomeLoc + "/stage/ext/jlib/emocmclnt.jar:" + shiphomeLoc + "/stage/ext/jlib/jsse.jar:" + shiphomeLoc + "/stage/ext/jlib/emocmclnt-14.jar:" + shiphomeLoc + "/stage/ext/jlib/emocmcommon.jar:" + shiphomeLoc + "/stage/ext/jlib/http_client.jar:" + shiphomeLoc + "/stage/ext/jlib/jcert.jar:" + shiphomeLoc + "/stage/ext/jlib/jnet.jar:" + shiphomeLoc + "/stage/ext/jlib/log4j-core.jar:" + shiphomeLoc + "/stage/ext/jlib/osdt_core3.jar:" + shiphomeLoc + "/stage/ext/jlib/osdt_jce.jar:" + shiphomeLoc + "/stage/ext/jlib/regexp.jar:" + shiphomeLoc + "/stage/ext/jlib/xmlparserv2.jar");
        }
        if (PlatformInfo.getInstance().getCurrentPlatform() == 610 || PlatformInfo.getInstance().getCurrentPlatform() == 173 && VendorClusterwareInfo.getInstance().isVendorClusterware()) {
            allArgs.add("oracle.install.skipRootPre=true");
        }
        args = allArgs.toArray(new String[0]);
        System.setProperty("oracle.installer.installerLocation", new File(startupLoc).getParent());
        this.logger.log(Level.INFO, "Calling restart API with the downloadLoc " + downloadLoc + " paramfile: " + paramFile + " ouiBugID: " + ouiBugID + " OPatchBugID:  " + OPatchBugID + " and args: ");
        for (String s : args) {
            this.logger.log(Level.INFO, "Arg: " + s);
        }
        File updatesDir = new File(downloadLoc, "LatestUpdates");
        String[] bugs = new File(updatesDir, "Shiphome").list();
        if (bugs != null && bugs.length > 0) {
            for (String b : bugs) {
                String sourceDir = updatesDir + File.separator + "Shiphome" + File.separator + b + File.separator + AutoUpdatesInstallConstants.RESTART_SHIPHOME_UPDATES_DIR;
                String destDir = scratchPath + File.separator + AutoUpdatesInstallConstants.SCRATCHPATH_SHIPHOME_UPDATES_DIR;
                File f = new File(sourceDir);
                if (!f.exists()) continue;
                this.copyUpdatesToScratch(sourceDir, destDir);
            }
        }
        this.updatesMngr.doRestart(args, downloadLoc, paramFile, ouiBugID, OPatchBugID);
    }

    public void copyUpdatesToScratch(String srcLoc, String destLoc) {
        this.logger.log(Level.INFO, "Copying the files from " + srcLoc + " to " + destLoc);
        String[] files = new File(srcLoc).list();
        if (files != null && files.length > 0) {
            for (String f : files) {
                File srcFile = new File(srcLoc, f);
                File destFile = new File(destLoc, f);
                if (!destFile.exists()) continue;
                try {
                    FileSystem.copy((File)srcFile, (File)destFile, (boolean)true);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "File: " + destFile.getAbsolutePath() + " could not be overwritten by " + srcFile.getAbsolutePath());
                }
            }
        }
    }

    public void prepareAutoBeanPostRestart(AutoUpdatesInstallSettings autoBean) {
        String val = System.getProperty("oracle.install.restartSession");
        if (val != null && val.equalsIgnoreCase("true")) {
            this.logger.log(Level.INFO, "Restart of the install completed successfully.");
            File restoreBeanFile = new File(this.scratchPathLoc, "restoreBeans.xml");
            AutoUpdatesInstallSettings autoUpdBean = null;
            if (restoreBeanFile != null && restoreBeanFile.exists()) {
                autoUpdBean = (AutoUpdatesInstallSettings)((Object)BeanStoreUtils.restoreFromXML((File)restoreBeanFile, AutoUpdatesInstallSettings.class));
                autoBean.setPatchDownloadLocation(autoUpdBean.getPatchDownloadLocation());
                autoBean.setDownloadType(autoUpdBean.getDownloadType());
            }
            if (autoUpdBean != null) {
                String downloadLoc = autoUpdBean.getPatchDownloadLocation();
                if (autoUpdBean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD && (downloadLoc == null || downloadLoc.length() == 0)) {
                    downloadLoc = this.scratchPathLoc;
                }
                UpdateManager updateManager = UpdateManager.getInstance();
                int platform = oracle.install.commons.base.util.PlatformInfo.getInstance().getARUId();
                String destDir = downloadLoc + File.separator + "metadata";
                if (new File(destDir).exists()) {
                    File[] metadataDir = new File(destDir).listFiles();
                    Application application = Application.getInstance();
                    String homeType = application.getString("product.name", null, new Object[0]);
                    try {
                        if (metadataDir != null && metadataDir.length > 0 && metadataDir[0] != null && metadataDir[0].getName() != null) {
                            OiiiInstallUpdate.setDownloadDir((String)new File(downloadLoc, "LatestUpdates").getPath());
                            OiiiInstallUpdate.setFlagUseLocalCopy((boolean)true);
                            updateManager.parseMetadata(new File(metadataDir[0], "patches.xml").getAbsolutePath(), platform, homeType);
                        }
                    }
                    catch (Exception e) {
                        ExceptionManager.handle((Throwable)e);
                    }
                    autoUpdBean.setApplyUpdates(true);
                    autoBean.setApplyUpdates(true);
                } else {
                    autoUpdBean.setApplyUpdates(false);
                    autoBean.setApplyUpdates(false);
                    ExceptionManager.handle((Throwable)((Object)new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.PATCHDOWNLOAD_LOCATION_INVALID, new Object[0])));
                }
            }
        }
    }
}

