/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;

public class InventoryValidator
implements CompositeValidator {
    private String inventoryLoc;
    private static Logger logger = Logger.getLogger(InventoryValidator.class.getName());
    private boolean isSharedDir = false;
    private boolean isWritableLocalNode = false;
    private StatusMessages<ValidationStatusMessage> errorMessages = new StatusMessages();

    public void validate(FlowContext flowContext) throws ValidationException {
        String invGroup;
        if (this.errorMessages.size() > 0) {
            this.errorMessages.clear();
        }
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        this.inventoryLoc = cenInv.getInventoryLocation();
        if (this.checkEmptiness(this.inventoryLoc) == null) {
            this.checkInvalidChars(this.inventoryLoc);
            this.errorMessages.add((StatusMessage)this.checkCompliance(this.inventoryLoc));
            this.checkAbsolutePath(this.inventoryLoc);
            this.checkGenericInventoryValidation(this.inventoryLoc);
            this.checkUnixWritable(this.inventoryLoc);
            this.checkDirtyInventory(this.inventoryLoc);
        }
        if ((invGroup = cenInv.getGroupOwnership()) == null || invGroup.trim().length() == 0) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ORAINVENTORY_GROUP_NOT_SPECIFIED, new Object[0]));
        } else {
            List<String> arrOsGroups = Arrays.asList(InventoryInfo.getInstance().getOSGroups());
            if (!arrOsGroups.contains(invGroup)) {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INVALID_ORAINVENTORY_GROUP, new Object[0]));
            }
        }
        this.checkChangeGroupPermission(this.inventoryLoc, invGroup);
    }

    public void validateOraInventoryLocation(String oraInvLoc, String oraBase) {
        File fileInvLoc = new File(oraInvLoc);
        File fileBase = new File(oraBase);
        try {
            String strBase = fileBase.getCanonicalPath();
            if (!strBase.endsWith(File.separator)) {
                strBase = strBase + File.separator;
            }
            if (fileInvLoc.getCanonicalPath().startsWith(strBase)) {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INVENTORY_IN_ORACLE_BASE, new Object[0]));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ValidationStatusMessage checkCompliance(String inventoryLocation) {
        File userHomeDir;
        File invLoc;
        logger.log(Level.INFO, "Checking whether the given inventory location {0} is user home or not...", inventoryLocation);
        ValidationStatusMessage errorMessage = null;
        if (inventoryLocation != null && (invLoc = new File(inventoryLocation)).exists() && invLoc.equals(userHomeDir = FileSystem.getHomeDirectory())) {
            errorMessage = new ValidationStatusMessage((ErrorCode)CommonErrorCode.USER_HOME_NOT_ALLOWED_AS_INV_LOC, new Object[0]);
        }
        return errorMessage;
    }

    public StatusMessage checkEmptiness(String input) {
        ValidationStatusMessage retVal = null;
        if (input == null || input.trim().length() < 1) {
            CommonErrorCode key = CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_EMPTY_ERR;
            retVal = new ValidationStatusMessage((ErrorCode)key, new Object[0]);
            this.errorMessages.add((StatusMessage)retVal);
        }
        return retVal;
    }

    public void checkDirtyInventory(String invLoc) {
        File file = new File(invLoc);
        if (file.exists()) {
            if (file.isDirectory()) {
                String[] files = file.list();
                boolean validPath = true;
                if (files != null && files.length != 0) {
                    File inventoryFile = new File(invLoc, "ContentsXML/inventory.xml");
                    boolean bl = validPath = !inventoryFile.exists();
                    if (validPath) {
                        File logPath = new File(invLoc, "logs");
                        if (logPath != null && logPath.exists()) {
                            String[] fileList = logPath.list();
                            if (fileList != null) {
                                String timeStamp = InstallHelper.getInstallerTimeStamp();
                                for (String s : fileList) {
                                    if (s.contains(timeStamp)) continue;
                                    validPath = false;
                                    break;
                                }
                            } else {
                                validPath = false;
                            }
                        } else {
                            validPath = false;
                        }
                    }
                }
                if (!validPath) {
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_DIRTY, new Object[]{invLoc}));
                }
            } else {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_DIRTY, new Object[]{invLoc}));
            }
        }
    }

    public void checkAbsolutePath(String input) throws ValidationException {
        String pathDesc = "inventory";
        ValidationStatusMessage msg = null;
        msg = GenericValidation.checkAbsolutePath(input, pathDesc);
        if (msg != null) {
            throw new ValidationException(msg.getErrorInfo().getErrorCode(), msg.getErrorInfo().getMessageArgs());
        }
    }

    public void checkInvalidChars(String input) throws ValidationException {
        String invalidChars = BaseInstallLocationValidator.getBadCharsForLocation();
        if (!GenericValidation.isFilenameValid(input, invalidChars)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_INV_INVALID_CHARS, new Object[0]);
        }
    }

    public void checkGenericInventoryValidation(String input) {
        Object retVal = null;
        boolean bool = false;
        CommonErrorCode message = CommonErrorCode.INSTALL_COMMON_INVENTORY_INVALID_INV_LOCATION_ERR;
        try {
            bool = InventoryInfo.getInstance().validateInvLocForSetup(input);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        if (!bool) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)message, new Object[0]));
        }
    }

    public void checkUnixWritable(String input) {
        if (!PlatformInfo.getInstance().isUnix()) {
            return;
        }
        if (input == null || input.trim().equals("")) {
            return;
        }
        boolean bool = false;
        CommonErrorCode key = CommonErrorCode.INSTALL_COMMON_INVENTORY_INV_NO_WRITE_PERMISSION_ERR;
        this.isWritableLocalNode = bool = this.isLeafWritable(input);
        if (!bool) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)key, new Object[]{input}));
        }
    }

    private boolean isLeafWritable(String dir) {
        boolean bool = false;
        File f = new File(dir);
        while (!bool) {
            bool = f.exists();
            if (bool) continue;
            f = new File(f.getParent());
        }
        return f.canWrite();
    }

    public void checkForSharedLocation(List<String> nodes) {
        if (nodes != null && nodes.size() > 1) {
            try {
                if (FileSystemInfo.getInstance().isLocationOnCFS(this.inventoryLoc, nodes)) {
                    this.isSharedDir = true;
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INVENTORY_ON_SHARED_LOC, new Object[]{this.inventoryLoc}));
                }
            }
            catch (InstallException installException) {
                // empty catch block
            }
        }
    }

    public void checkRemoteWritableLocation(List<String> nodes) {
        if (!PlatformInfo.getInstance().isUnix()) {
            return;
        }
        if (this.isSharedDir) {
            return;
        }
        if (!this.isWritableLocalNode) {
            return;
        }
        if (nodes != null && nodes.size() > 1) {
            for (String node : nodes) {
                if (MachineInfo.getInstance().isLocalHost(node)) continue;
                boolean fileExists = false;
                String dirToCheck = this.inventoryLoc;
                try {
                    while (!fileExists) {
                        fileExists = FileInfo.getInstance().doesRemoteDirExist(node, dirToCheck);
                        if (fileExists) continue;
                        if (dirToCheck.lastIndexOf(File.separatorChar) == 0) {
                            dirToCheck = File.separator;
                            continue;
                        }
                        dirToCheck = dirToCheck.substring(0, dirToCheck.lastIndexOf(File.separatorChar));
                    }
                    boolean canWrite = FileInfo.getInstance().isRemoteDirWriatble(node, dirToCheck);
                    if (canWrite) continue;
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.DIRECTORY_NOT_WRITABLE_ON_NODE, new Object[]{this.inventoryLoc, node}));
                }
                catch (Throwable t) {
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage(t));
                }
            }
        }
    }

    public void checkChangeGroupPermission(String invLoc, String invGroup) {
        if (invLoc != null && invGroup != null && new File(invLoc).exists()) {
            try {
                int retCode = FileInfo.getInstance().changeGroup(invLoc, invGroup);
                if (retCode != 0) {
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INV_USER_GROUP_MATCH_ERR, new Object[0]));
                }
            }
            catch (Exception e) {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INV_USER_GROUP_MATCH_ERR, new Object[0]));
            }
        }
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.errorMessages;
    }
}

