/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.MachineInfo;
import oracle.sysman.oii.oiix.OiixRegistryOps;

public class MTSValidationHelper {
    public static Logger logger = Logger.getLogger(MTSValidationHelper.class.getName());

    public static void validateMTSPort(Integer mtsPort) throws ValidationException {
        int portNumber = 0;
        String key = "HKEY_LOCAL_MACHINE";
        String subKey = "software\\oracle\\OracleMTSRecoveryService\\Protid_0";
        try {
            if (OiixRegistryOps.RegKeyExists((String)key, (String)subKey)) {
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not read the ORA MTS registry key properly");
            return;
        }
        String mtsPortNumber = InstallHelper.getValue("MTS_PORT");
        if (mtsPortNumber != null && mtsPortNumber.length() > 0) {
            int port = 0;
            try {
                port = Integer.parseInt(mtsPortNumber);
            }
            catch (Exception e) {
                ErrorInfo errorInfo = ErrorInfo.getInstance((ErrorCode)CommonErrorCode.INVALID_MTS_PORT, (Object[])new Object[0]);
                throw new IllegalArgumentException(errorInfo.getMessage());
            }
            if (mtsPort == null) {
                throw new ValidationException((ErrorCode)CommonErrorCode.INVALID_MTS_PORT, new Object[0]);
            }
            portNumber = mtsPort;
            if (portNumber < 1024 || portNumber > 65535) {
                throw new ValidationException((ErrorCode)CommonErrorCode.OUT_OF_RANGE_MTS_PORT, new Object[]{portNumber});
            }
            if (!MachineInfo.getInstance().isLocalPortAvailable(portNumber)) {
                throw new ValidationException((ErrorCode)CommonErrorCode.MTS_PORT_NOT_AVAILABLE, new Object[]{portNumber});
            }
        }
    }
}

