/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.ivw.common.bean.RootConfigurationSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.install.library.util.cvu.CVUValidationStatusMessage;

public class RootConfigValidationHelper {
    private static Logger logger = Logger.getLogger(RootConfigValidationHelper.class.getName());

    public StatusMessages<ValidationStatusMessage> validate(RootConfigurationSettings configSettings) {
        logger.log(Level.INFO, "Node list is empty. So considering local node for validation");
        String localNode = MachineInfo.getInstance().getLocalMachineName();
        return this.validate(configSettings, Arrays.asList(localNode));
    }

    public StatusMessages<ValidationStatusMessage> validate(RootConfigurationSettings configSettings, List<String> nodes) {
        StatusMessages messages = new StatusMessages();
        RootConfigurationSettings.ConfigMethod configMethod = configSettings.getConfigMethod();
        if (configSettings.isExecuteRootScript()) {
            switch (configMethod) {
                case ROOT: {
                    messages.addAll(this.validateRootPassword(configSettings.getRootPassword(), nodes));
                    break;
                }
                case SUDO: {
                    messages.addAll(this.validateSudoOption(configSettings.getSudoProgramPath(), configSettings.getSudoUserName(), configSettings.getSudoPassword(), nodes));
                    break;
                }
                case PB: {
                    messages.addAll(this.validatePBRunOption(configSettings.getPowerBrokerPath(), configSettings.getPowerBrokerUserName(), configSettings.getPbPassword(), nodes));
                }
            }
        }
        return messages;
    }

    public StatusMessages<ValidationStatusMessage> validateRootPassword(String password, List<String> nodes) {
        StatusMessages messages = new StatusMessages();
        if (password == null || password.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ROOT_CONFIG_ROOT_USER_PASSWORD_EMPTY, new Object[0]));
            return messages;
        }
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkRootUserPassword(nodes.toArray(new String[0]), password)) {
            messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.ROOT_USER_PASSWORD_INVALID, new Object[0]));
        }
        return messages;
    }

    public StatusMessages<ValidationStatusMessage> validateSudoOption(String sudoLocation, String userName, String password, List<String> nodes) {
        StatusMessages messages = new StatusMessages();
        if (sudoLocation == null || sudoLocation.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_LOCATION_EMPTY, new Object[0]));
        }
        if (messages.size() > 0) {
            return messages;
        }
        if (password == null || password.length() == 0) {
            if (userName != null && !userName.equals(System.getProperty("user.name"))) {
                messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_CONFIG_PASSWORD_EMPTY, Severity.WARNING, new Object[]{"Sudo", System.getProperty("user.name")}));
            }
            password = "";
        }
        if (!sudoLocation.startsWith(File.separator)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_LOCATION_ABSOLUTE_PATH_NOT_SPECIFIED, new Object[]{sudoLocation}));
        }
        CVUHelper instance = CVUHelper.getInstance();
        if (userName == null || userName.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_USER_NAME_EMPTY, new Object[0]));
        } else if (!instance.checkUserExistance(userName, nodes)) {
            messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_USERNAME_EXISTANCE_CHECK_ERROR, userName));
        }
        if (!instance.checkSudoExistance(nodes.toArray(new String[0]), sudoLocation, userName, password)) {
            messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_CONFIG_DETAILS_INVALID, new Object[0]));
            return messages;
        }
        if (!instance.checkSudoExecution(nodes.toArray(new String[0]), sudoLocation, userName, password)) {
            messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_EXCECUTION_PERMISSION_ERROR, userName));
        }
        return messages;
    }

    public StatusMessages<ValidationStatusMessage> validatePBRunOption(String pbRunLocation, String userName, String password, List<String> nodes) {
        StatusMessages messages = new StatusMessages();
        if (pbRunLocation == null || pbRunLocation.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_LOCATION_EMPTY, new Object[0]));
        }
        if (messages.size() > 0) {
            return messages;
        }
        if (password == null || password.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ROOT_CONFIG_PASSWORD_EMPTY, Severity.WARNING, new Object[]{"Power Broker"}));
            password = "";
        }
        if (!pbRunLocation.startsWith(File.separator)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_LOCATION_ABSOLUTE_PATH_NOT_SPECIFIED, new Object[]{pbRunLocation}));
        }
        CVUHelper instance = CVUHelper.getInstance();
        if (userName == null || userName.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_USER_NAME_EMPTY, new Object[0]));
        } else if (!instance.checkUserExistance(userName, nodes)) {
            messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_USERNAME_EXISTANCE_CHECK_ERROR, userName));
        }
        if (!instance.checkPBRunExistance(nodes.toArray(new String[0]), pbRunLocation, userName, password)) {
            messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_CONFIG_DETAILS_INVALID, new Object[0]));
            return messages;
        }
        if (!instance.checkPBRunExecution(nodes.toArray(new String[0]), pbRunLocation, userName, password)) {
            messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_EXCECUTION_PERMISSION_ERROR, userName));
        }
        return messages;
    }
}

