/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.install.commons.base.util.ComponentConfig;
import oracle.install.commons.base.util.ComponentConfigSource;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.view.ComponentSelectionPane;

public class ComponentChooser
extends JDialog {
    private static ComponentSelectionPane componentSelectionPane;
    private boolean accepted;

    public static ComponentConfig showDialog(Component owner, ComponentConfigSource source, String ... selectedComponents) {
        ComponentConfig componentConfig;
        if (componentSelectionPane == null) {
            componentSelectionPane = new ComponentSelectionPane(source);
        }
        if (selectedComponents != null && (componentConfig = componentSelectionPane.getComponentBean()) != null) {
            componentConfig.setSelectedVisibleComponents(selectedComponents);
        }
        Frame frame = JOptionPane.getFrameForComponent(owner);
        ComponentChooser dialog = new ComponentChooser(frame, source);
        dialog.setConfigSource(source);
        dialog.localize();
        dialog.reset();
        dialog.setVisible(true);
        return dialog.getComponentBean();
    }

    private ComponentChooser(Frame owner, ComponentConfigSource source) {
        super(owner, "", true);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ComponentChooser.this.accepted = false;
                    ComponentChooser.this.dispose();
                }
                if (e.getKeyCode() == 10) {
                    ComponentChooser.this.accepted = true;
                    ComponentChooser.this.dispose();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        ActionListener OKListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentChooser.this.accepted = true;
                ComponentChooser.this.dispose();
            }
        };
        ActionListener CancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentChooser.this.accepted = false;
                ComponentChooser.this.dispose();
            }
        };
        componentSelectionPane.addFinishActionListeners(OKListener, CancelListener, keyListener);
        this.getContentPane().add((Component)componentSelectionPane, "Center");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void setConfigSource(ComponentConfigSource source) {
        componentSelectionPane.setConfigSource(source);
    }

    public void reset() {
        this.accepted = false;
    }

    public ComponentConfig getComponentBean() {
        return this.accepted ? componentSelectionPane.getComponentBean() : null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 350);
    }

    public void localize() {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
        this.setTitle(resource.getString("ComponentChooser.title.text", "Component Chooser", new Object[0]));
    }
}

