/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellRenderer;
import oracle.install.commons.base.util.ComponentConfig;
import oracle.install.commons.base.util.ComponentConfigBuilder;
import oracle.install.commons.base.util.ComponentConfigSource;
import oracle.install.commons.base.util.InstallComponent;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.ToggleButtonTableCellRenderer;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.view.ComponentTableModel;

public class ComponentSelectionPane
extends JPanel {
    private Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
    private JTable compTable;
    private JButton btnResetDefaults;
    private JButton btnSlectAll;
    private JButton btnDeSlectAll;
    private JButton btnOK;
    private JButton btnCancel;
    private ComponentTableModel compTableModel;
    private ComponentConfigSource configSource;
    private ComponentConfig componentBean;

    public ComponentSelectionPane(ComponentConfigSource source) {
        this.setFocusable(true);
        this.configSource = source;
        this.loadComponentBean(false);
        this.compTableModel = new ComponentTableModel(this.componentBean.getVisibleComponents());
        this.buildUI();
    }

    public void setConfigSource(ComponentConfigSource source) {
        if (source != this.configSource) {
            this.configSource = source;
            this.loadComponentBean(false);
            this.compTableModel.setComponents(this.componentBean.getVisibleComponents());
        }
    }

    private ComponentConfig loadComponentBean(boolean reload) {
        try {
            ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
            this.componentBean = builder.getComponentBean(this.configSource, reload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.componentBean;
    }

    private void buildUI() {
        this.compTable = new JTable();
        this.btnResetDefaults = new JButton();
        this.btnSlectAll = new JButton();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.btnDeSlectAll = new JButton();
        JScrollPane scrollPane = new JScrollPane(this.compTable);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selectAll = e.getActionCommand().equalsIgnoreCase("SelectAll");
                ComponentSelectionPane.this.selectALLComponents(selectAll);
            }
        };
        this.btnSlectAll.setActionCommand("SelectAll");
        this.btnDeSlectAll.setActionCommand("De-SelectAll");
        this.btnSlectAll.addActionListener(listener);
        this.btnDeSlectAll.addActionListener(listener);
        this.btnResetDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentSelectionPane.this.loadComponentBean(true);
                ComponentSelectionPane.this.compTableModel.setComponents(ComponentSelectionPane.this.componentBean.getVisibleComponents());
            }
        });
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)scrollPane, (Container)this, (int)0, (int)0, (int)5, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        LayoutUtils.addComponent((Component)this.btnResetDefaults, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)0, (int)12, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnSlectAll, (Container)this, (int)1, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnDeSlectAll, (Container)this, (int)2, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnOK, (Container)this, (int)3, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnCancel, (Container)this, (int)4, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        this.localize();
        this.btnOK.setVisible(false);
        this.btnCancel.setVisible(false);
        this.compTable.setModel(this.compTableModel);
        this.compTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ToggleButtonTableCellRenderer((JToggleButton)new JCheckBox()));
        this.compTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.compTable.getTableHeader().setReorderingAllowed(false);
    }

    public ComponentConfig getComponentBean() {
        return this.componentBean;
    }

    public void setComponentBean(ComponentConfig componentBean) {
        this.componentBean = componentBean;
    }

    private void selectALLComponents(boolean selectAll) {
        if (this.componentBean != null) {
            InstallComponent component = null;
            List compList = this.componentBean.getVisibleComponents();
            for (int i = 0; i < compList.size(); ++i) {
                component = (InstallComponent)compList.get(i);
                if (!component.isEnabledForSelection() || !component.isVisible()) continue;
                this.compTableModel.setValueAt((Object)selectAll, i, 0);
            }
        }
    }

    public void addFinishActionListeners(ActionListener OKListener, ActionListener CancelListener, KeyListener keyListener) {
        this.btnOK.addActionListener(OKListener);
        this.btnCancel.addActionListener(CancelListener);
        this.addKeyListener(keyListener);
        this.btnOK.setVisible(true);
        this.btnCancel.setVisible(true);
    }

    public void localize() {
        String buttonText = this.resource.getString("ComponentSelectionPane.btnSlectAll.text", "&Select all*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnSlectAll, (String)buttonText);
        buttonText = this.resource.getString("ComponentSelectionPane.btnResetDefaults.text", "&Reset defaults*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnResetDefaults, (String)buttonText);
        buttonText = this.resource.getString("ComponentSelectionPane.btnDeSlectAll.text", "De-Select all*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnDeSlectAll, (String)buttonText);
        buttonText = this.resource.getString("ComponentSelectionPane.btnOK.text", "OK*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnOK, (String)buttonText);
        buttonText = this.resource.getString("ComponentSelectionPane.btnCancel.text", "Cancel*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnCancel, (String)buttonText);
        this.compTableModel.setColumnNames(new String[]{" ", this.resource.getString("ComponentSelectionPane.compTable.column.compName", "Name", new Object[0])});
    }
}

