/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import oracle.bali.ewt.validate.AbstractValidationComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.UIUtil;

public class WindowsSecureOptionPane
extends JPanel
implements ItemListener {
    private static final Logger logger = Logger.getLogger(WindowsSecureOptionPane.class.getName());
    public static final int COMBOWIDTH = 100;
    private Resource resource;
    private MultilineLabel lblPageDesc;
    private JRadioButton jRadioBtnBuiltInUser;
    private JRadioButton jRadioBtnExistingUser;
    private JLabel lblExistingUserName;
    private JTextField jTxtFldExistingUserName;
    private JLabel lblExistingPassword;
    private JPasswordField txtExistingUserPassword;
    public JRadioButton jRadioBtnNewUser;
    private JLabel lblNewUserPrompt;
    private JLabel lblNewUserName;
    private JTextField jTxtFldNewUserName;
    private JLabel lblNewUserPassword;
    private JPasswordField txtNewUserPassword;
    private JLabel lblConfirmPassword;
    private JPasswordField txtConfirmPassword;
    public JCheckBox chkBoxDeclineSecureOption;
    private MultilineLabel lblDeclineDesc;
    private ButtonGroup group = new ButtonGroup();
    private JPanel existingUserPanel = new JPanel();
    private JPanel newUserPanel = new JPanel();
    private TogglePane existingUserTogglePane;
    private TogglePane newUserTogglePane;
    private boolean bEnableexistingUserPassword;
    private boolean bEnableexistingUser;
    private boolean bEnableNewUser;
    private boolean bDeclineSecureOption;
    private boolean bDeclineSecureOptionSelection;
    private String lblPageDescStr;

    public WindowsSecureOptionPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource(CommonDialogLabelResID.class.getName());
        this.buildUI();
        this.inlinevalidation();
    }

    private void buildUI() {
        this.lblPageDesc = new MultilineLabel();
        this.lblPageDesc.setName("lblPageDesc");
        this.jRadioBtnExistingUser = new JRadioButton();
        this.jRadioBtnExistingUser.setName("jRadioBtnExistingUser");
        this.jRadioBtnNewUser = new JRadioButton();
        this.jRadioBtnNewUser.setName("jRadioBtnNewUser");
        this.jRadioBtnBuiltInUser = new JRadioButton();
        this.jRadioBtnBuiltInUser.setName("jRadioBtnBuiltInUser");
        this.group = new ButtonGroup();
        this.group.add(this.jRadioBtnExistingUser);
        this.group.add(this.jRadioBtnNewUser);
        this.group.add(this.jRadioBtnBuiltInUser);
        this.jRadioBtnExistingUser.addItemListener(this);
        this.lblNewUserName = new JLabel();
        this.lblNewUserName.setName("lblNewUserName");
        this.lblNewUserPrompt = new JLabel();
        this.lblNewUserPrompt.setName("lblNewUserPrompt");
        this.jTxtFldNewUserName = new JTextField();
        this.jTxtFldNewUserName.setName("jTxtFldNewUserName");
        this.lblNewUserPassword = new JLabel();
        this.lblNewUserPassword.setName("lblNewUserPassword");
        this.txtNewUserPassword = new JPasswordField();
        this.txtNewUserPassword.setName("pwdNewUserPassword");
        this.chkBoxDeclineSecureOption = new JCheckBox();
        this.chkBoxDeclineSecureOption.setName("chkBoxDeclineSecureOption");
        this.chkBoxDeclineSecureOption.addItemListener(this);
        this.lblDeclineDesc = new MultilineLabel();
        this.existingUserPanel = new JPanel();
        this.newUserPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblPageDesc, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)0.0);
        this.existingUserPanel = this.getPnlExistingUser();
        this.existingUserTogglePane = new TogglePane((JToggleButton)this.jRadioBtnExistingUser, (Component)this.existingUserPanel);
        this.existingUserTogglePane.setContentDisabledOnDeselect(true);
        this.jRadioBtnExistingUser.setSelected(true);
        LayoutUtils.addComponent((Component)this.existingUserTogglePane, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        this.newUserPanel = this.getNewUserPanel();
        this.newUserTogglePane = new TogglePane((JToggleButton)this.jRadioBtnNewUser, (Component)this.newUserPanel);
        this.newUserTogglePane.setContentDisabledOnDeselect(true);
        LayoutUtils.addComponent((Component)this.newUserTogglePane, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.jRadioBtnBuiltInUser, (Container)this, (int)0, (int)3, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)4, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.setComponentEnabled((Component)this.newUserPanel, (boolean)false);
        ActiveHelpManager.registerComponent((JComponent)this.jRadioBtnExistingUser, (String)"WindowsSecureOptionPane.jRadioBtnExistingUser");
        ActiveHelpManager.registerComponent((JComponent)this.jRadioBtnNewUser, (String)"WindowsSecureOptionPane.jRadioBtnNewUser");
        ActiveHelpManager.registerComponent((JComponent)this.jRadioBtnBuiltInUser, (String)"WindowsSecureOptionPane.jRadioBtnBuiltInUser");
        ActiveHelpManager.registerComponent((JComponent)this.jTxtFldExistingUserName, (String)"WindowsSecureOptionPane.jTxtFldExistingUserName");
        ActiveHelpManager.registerComponent((JComponent)this.txtExistingUserPassword, (String)"WindowsSecureOptionPane.txtExistingUserPassword");
        ActiveHelpManager.registerComponent((JComponent)this.jTxtFldNewUserName, (String)"WindowsSecureOptionPane.jTxtFldNewUserName");
        ActiveHelpManager.registerComponent((JComponent)this.txtNewUserPassword, (String)"WindowsSecureOptionPane.txtNewUserPassword");
        ActiveHelpManager.registerComponent((JComponent)this.txtConfirmPassword, (String)"WindowsSecureOptionPane.txtConfirmPassword");
    }

    public void enableExistingUser(boolean bExistingUserEnabled) {
        this.bEnableexistingUser = bExistingUserEnabled;
        this.existingUserTogglePane.setEnabled(bExistingUserEnabled);
        this.jRadioBtnExistingUser.setEnabled(bExistingUserEnabled);
    }

    public void enableNewUser(boolean bNewUserEnabled) {
        this.bEnableNewUser = bNewUserEnabled;
        this.newUserTogglePane.setEnabled(bNewUserEnabled);
        this.jRadioBtnNewUser.setEnabled(bNewUserEnabled);
    }

    public void enableDeclineOption(boolean bDeclineOption) {
        this.chkBoxDeclineSecureOption.setEnabled(bDeclineOption);
        this.jRadioBtnBuiltInUser.setEnabled(bDeclineOption);
    }

    public void selectDeclineOption(boolean bDeclineOptionSelected) {
        this.jRadioBtnBuiltInUser.setSelected(bDeclineOptionSelected);
        this.jRadioBtnExistingUser.setSelected(!bDeclineOptionSelected);
    }

    public void selectNewUserOption(boolean bDeclineOptionSelected) {
        this.jRadioBtnBuiltInUser.setSelected(!bDeclineOptionSelected);
        this.jRadioBtnExistingUser.setSelected(!bDeclineOptionSelected);
        this.jRadioBtnNewUser.setSelected(bDeclineOptionSelected);
    }

    public void selectExistingUserOption(boolean bDeclineOptionSelected) {
        this.jRadioBtnBuiltInUser.setSelected(!bDeclineOptionSelected);
        this.jRadioBtnExistingUser.setSelected(bDeclineOptionSelected);
        this.jRadioBtnNewUser.setSelected(!bDeclineOptionSelected);
    }

    public void enableExistingUserName(boolean bExistingUserNameEnabled) {
        this.lblExistingUserName.setEnabled(bExistingUserNameEnabled);
        this.jTxtFldExistingUserName.setEnabled(bExistingUserNameEnabled);
    }

    public void enableExistingUserPassword(boolean bExistingPasswordEnabled) {
        this.bEnableexistingUserPassword = bExistingPasswordEnabled;
        this.lblExistingPassword.setEnabled(bExistingPasswordEnabled);
        this.txtExistingUserPassword.setEnabled(bExistingPasswordEnabled);
    }

    public JPanel getPnlExistingUser() {
        JPanel pnlExistingUser = new JPanel();
        pnlExistingUser.setLayout(new GridBagLayout());
        this.lblExistingUserName = new JLabel();
        this.lblExistingPassword = new JLabel();
        this.txtExistingUserPassword = new JPasswordField();
        this.jTxtFldExistingUserName = new JTextField();
        this.lblExistingUserName.setLabelFor(this.jTxtFldExistingUserName);
        this.lblExistingPassword.setLabelFor(this.txtExistingUserPassword);
        LayoutUtils.addComponent((Component)this.lblExistingUserName, (Container)pnlExistingUser, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.jTxtFldExistingUserName, (Container)pnlExistingUser, (int)1, (int)0, (int)2, (int)1, (int)1, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(5, 40, 5, 20));
        LayoutUtils.addComponent((Component)this.lblExistingPassword, (Container)pnlExistingUser, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtExistingUserPassword, (Container)pnlExistingUser, (int)1, (int)1, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(5, 40, 5, 20));
        return pnlExistingUser;
    }

    public JPanel getNewUserPanel() {
        this.newUserPanel.setLayout(new GridBagLayout());
        this.lblNewUserName = new JLabel();
        this.lblNewUserName.setName("lblNewUserName");
        this.jTxtFldNewUserName = new JTextField();
        this.jTxtFldNewUserName.setName("jTxtFldNewUserName");
        this.lblNewUserPassword = new JLabel();
        this.lblNewUserPassword.setName("lblNewUserPassword");
        this.txtNewUserPassword = new JPasswordField();
        this.txtNewUserPassword.setName("pwdNewUserPassword");
        this.lblConfirmPassword = new JLabel();
        this.lblConfirmPassword.setName("lblConfirmPassword");
        this.txtConfirmPassword = new JPasswordField();
        this.txtConfirmPassword.setName("pwdConfirmPassword");
        this.lblNewUserName.setLabelFor(this.jTxtFldNewUserName);
        this.lblNewUserPassword.setLabelFor(this.txtNewUserPassword);
        this.lblConfirmPassword.setLabelFor(this.txtConfirmPassword);
        LayoutUtils.addComponent((Component)this.lblNewUserName, (Container)this.newUserPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.jTxtFldNewUserName, (Container)this.newUserPanel, (int)1, (int)0, (int)2, (int)1, (int)1, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 20));
        LayoutUtils.addComponent((Component)this.lblNewUserPassword, (Container)this.newUserPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtNewUserPassword, (Container)this.newUserPanel, (int)1, (int)1, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 20));
        LayoutUtils.addComponent((Component)this.lblConfirmPassword, (Container)this.newUserPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtConfirmPassword, (Container)this.newUserPanel, (int)1, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 20));
        LayoutUtils.addComponent((Component)this.lblNewUserPrompt, (Container)this.newUserPanel, (int)0, (int)3, (int)2, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        return this.newUserPanel;
    }

    public void localize() {
        String userName = InstallHelper.getValue("oracle.install.OracleHomeUserName");
        if (userName != null) {
            if (this.jRadioBtnExistingUser.isSelected()) {
                this.jRadioBtnNewUser.setSelected(false);
                this.jTxtFldExistingUserName.setText(userName);
            } else {
                this.jRadioBtnExistingUser.setSelected(false);
                this.jTxtFldNewUserName.setText(userName);
            }
        }
        this.lblPageDesc.setText(this.lblPageDescStr);
        SwingUtils.setText((AbstractButton)this.jRadioBtnExistingUser, (String)this.resource.getString("WindowsSecureOption.ExistingUser.text", "Use E&xisting Windows User", new Object[0]));
        SwingUtils.setText((AbstractButton)this.jRadioBtnNewUser, (String)this.resource.getString("WindowsSecureOption.CreateUser.text", "&Create New Windows User", new Object[0]));
        SwingUtils.setText((JLabel)this.lblExistingUserName, (String)this.resource.getString("WindowsSecureOption.UserName.text", "&User Name:", new Object[0]));
        SwingUtils.setText((JLabel)this.lblExistingPassword, (String)this.resource.getString("WindowsSecureOption.Password.text", "&Password:", new Object[0]));
        SwingUtils.setText((JLabel)this.lblNewUserName, (String)this.resource.getString("WindowsSecureOption.NewUserName.text", "U&ser Name:", new Object[0]));
        SwingUtils.setText((JLabel)this.lblNewUserPassword, (String)this.resource.getString("WindowsSecureOption.NewPassword.text", "Pa&ssword:", new Object[0]));
        SwingUtils.setText((JLabel)this.lblConfirmPassword, (String)this.resource.getString("WindowsSecureOption.ConfirmPassword.text", "C&onfirm Password:", new Object[0]));
        SwingUtils.setText((JLabel)this.lblNewUserPrompt, (String)this.resource.getString("WindowsSecureOption.NewUser.prompt.text", "The newly created user is denied Windows logon privileges.", new Object[0]));
        SwingUtils.setText((AbstractButton)this.jRadioBtnBuiltInUser, (String)this.resource.getString("WindowsSecureOption.BuiltInUser.text", "Use Windows Bui&lt-in Account", new Object[0]));
        SwingUtils.setText((AbstractButton)this.chkBoxDeclineSecureOption, (String)this.resource.getString("WindowsSecureOptionPane.declineSecureOptionDesc.text", "&Decline secure option. All the services will be installed and run as System user.", new Object[0]));
    }

    public boolean isExistingUserPasswordRequired() {
        return this.bEnableexistingUserPassword;
    }

    public void setisExistingUserPasswordRequired(boolean bpasswordRequired) {
        this.bEnableexistingUserPassword = bpasswordRequired;
    }

    public boolean isExistingUser() {
        return this.jRadioBtnExistingUser.isSelected();
    }

    public boolean isNewUser() {
        return this.jRadioBtnNewUser.isSelected();
    }

    public void setLblPageDesc(String lblPageDesc) {
        this.lblPageDescStr = lblPageDesc;
    }

    public String getLblPageDesc() {
        return this.lblPageDescStr;
    }

    public void setExistingUserName(String existingUserName) {
        this.jTxtFldExistingUserName.setText(existingUserName);
    }

    public String getExistingUserName() {
        return this.jTxtFldExistingUserName.getText();
    }

    public void setExistingUserPassword(String existingUserPassword) {
        this.txtExistingUserPassword.setText(existingUserPassword);
    }

    public String getExistingUserPassword() {
        return new String(this.txtExistingUserPassword.getPassword());
    }

    public void setNewUserName(String newUserName) {
        this.jTxtFldNewUserName.setText(newUserName);
    }

    public String getNewUserName() {
        return this.jTxtFldNewUserName.getText();
    }

    public void setNewUserPassword(String newUserPassword) {
        this.txtNewUserPassword.setText(newUserPassword);
    }

    public String getNewUserPassword() {
        return new String(this.txtNewUserPassword.getPassword());
    }

    public void setConfirmPassword(String confirmPassword) {
        this.txtConfirmPassword.setText(confirmPassword);
    }

    public String getConfirmPassword() {
        return new String(this.txtConfirmPassword.getPassword());
    }

    public void setDeclineSecureOption(boolean declineSecureOption) {
        this.chkBoxDeclineSecureOption.setSelected(declineSecureOption);
        this.jRadioBtnBuiltInUser.setSelected(declineSecureOption);
    }

    public boolean isDeclineSecureOption() {
        return this.jRadioBtnBuiltInUser.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.jRadioBtnExistingUser.isSelected()) {
            Component[] components = this.existingUserPanel.getComponents();
            if (components != null && components.length > 0) {
                int count = components.length;
                for (int i = 0; i < count; ++i) {
                    components[i].setEnabled(true);
                }
            }
            this.enableExistingUserPassword(this.bEnableexistingUserPassword);
        }
    }

    public void inlinevalidation() {
        UIUtil.registerInlineValidator(this, this.txtNewUserPassword, this.txtConfirmPassword, "", (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                ValidationStatusMessage msg = null;
                return msg;
            }
        }, ValidationComponent.MODEL_CHANGE_VALIDATOR);
    }

    class WindowsSecureOptionValidationComponent
    extends AbstractValidationComponent
    implements ValidationComponent {
        public WindowsSecureOptionValidationComponent(JCheckBox rdoRedundancy) {
            super((Component)rdoRedundancy);
            CompositeListener cl = new CompositeListener();
            rdoRedundancy.addItemListener(cl);
        }

        public Object getData() {
            return ((JCheckBox)super.getComponent()).isSelected();
        }

        class CompositeListener
        implements ItemListener {
            CompositeListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                WindowsSecureOptionValidationComponent.this.validateComponent(ValidationComponent.FOCUS_CHANGE_VALIDATOR);
            }
        }
    }
}

