/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.db;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;

public class RAC92Helper {
    private static final Logger logger = Logger.getLogger(RAC92Helper.class.getName());
    private static String SCRATCH_PATH = null;
    public static final String[] libsORACM = new String[]{"libcmdll.so", "libwddapi.so"};
    public static final Properties RAC92statusDirs = new Properties();

    public static String runLSNodesUnix(String lsnodes, String ... args) {
        try {
            String[] cmd = new String[]{"/bin/sh", RAC92Helper.getScratchPathExtBin() + File.separator + "coex" + File.separator + lsnodes};
            ProcessBuilder pb = new ProcessBuilder(cmd);
            for (String arg : args) {
                pb.command().add(arg);
            }
            CMDLineParser lineParse = new CMDLineParser();
            ProcessLaunchInfo pli = new ProcessLaunchInfo(pb, (OutputProcessor)lineParse, null);
            ProcessLauncher.launch((ProcessLaunchInfo)pli);
            return lineParse.outStore;
        }
        catch (Exception e) {
            logger.severe("Failed to execute lsnodes.sh " + e);
            return "";
        }
    }

    public static void copyORACMLibsLinux(String versionedORACMDir) {
        File src = null;
        File des = null;
        try {
            String scratch_area = System.getProperty("oracle.installer.scratchPath");
            logger.info("Copying .so files to " + scratch_area);
            for (String lib : libsORACM) {
                if (Boolean.getBoolean("oracle.installer.configWizard")) {
                    src = new File(scratch_area + File.separator + "ext" + File.separator + "bin" + File.separator + "coex" + File.separator + versionedORACMDir, lib);
                    des = new File(System.getenv("ORACLE_HOME") + File.separator + "install", lib);
                } else {
                    src = new File(RAC92Helper.getScratchPathExtBin() + File.separator + "coex" + File.separator + versionedORACMDir, lib);
                    des = new File(scratch_area, lib);
                }
                FileSystem.copy((File)src, (File)des);
            }
        }
        catch (Exception e) {
            logger.severe("Failed to copy " + src.getAbsolutePath() + "into" + des.getAbsolutePath() + "\noccured" + e);
        }
    }

    static String getScratchPathExtBin() {
        if (SCRATCH_PATH == null) {
            SCRATCH_PATH = System.getProperty("oracle.installer.scratchPath");
        }
        return SCRATCH_PATH + File.separator + "ext" + File.separator + "bin";
    }

    static {
        RAC92statusDirs.put("CL", "CL");
        RAC92statusDirs.put("901", "9014");
        RAC92statusDirs.put("9201", "9201");
        RAC92statusDirs.put("9204", "9204");
    }

    private static class CMDLineParser
    extends AbstractLineProcessor {
        private String outStore = new String("");
        private boolean appendNewline = false;

        CMDLineParser() {
        }

        public void processLine(String line, int lineNumber) {
            if (this.appendNewline) {
                line = line + '\n';
            }
            this.outStore = this.outStore + line + " ";
        }
    }
}

