/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.memory;

import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.util.PlatformInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgMemory;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class MemoryInfo {
    private static MemoryInfo instance;

    protected MemoryInfo() {
    }

    public static MemoryInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (MemoryInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(MemoryInfo.class)) == null) {
            instance = new MemoryInfo();
        }
        return instance;
    }

    public long getTotalPhysicalMemory() {
        return OiipgMemory.getTotalPhysicalMemory();
    }

    public long getFreeDiskSpace(String fileLocation) {
        int platID = PlatformInfo.getInstance().getCurrentPlatform();
        long freeSpace = -1L;
        long MB = 0x100000L;
        if (OiixPlatform.isPlatInGroup((int)-1, (int)platID)) {
            freeSpace = OiixFileOps.getVolumeFreeSpace((String)fileLocation) / MB;
        }
        if (OiixPlatform.isPlatInGroup((int)-3, (int)platID)) {
            String driveName = fileLocation.substring(0, fileLocation.indexOf(92) + 1);
            freeSpace = OiixFileOps.getVolumeFreeSpace((String)driveName) / MB;
        }
        return freeSpace;
    }

    public long getClusterMaxFreeDiskSpace(String[] nodes, String fileLocation) {
        long maxSharedMem = 0L;
        long MB = 1024L;
        ClusterCmd cc = new ClusterCmd();
        for (int i = 0; i < nodes.length; ++i) {
            try {
                long sharedMemForNode = cc.getFreeSpace(nodes[i], fileLocation) / MB;
                if (i == 0) {
                    maxSharedMem = (int)sharedMemForNode;
                }
                if (sharedMemForNode >= maxSharedMem) continue;
                maxSharedMem = sharedMemForNode;
                continue;
            }
            catch (ClusterException e) {
                maxSharedMem = 0L;
            }
        }
        return maxSharedMem;
    }
}

