/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.processes;

import java.io.IOException;
import java.util.Vector;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.processes.StreamGobbler;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;

class RunLocalUnixCommand {
    public String[] outStore = null;
    public String[] errStore = null;
    boolean errorOccured = false;

    void setErrorOccured(boolean val) {
        this.errorOccured = val;
    }

    RunLocalUnixCommand(String command, String[] envp) throws InstallException {
        Process kmproc = null;
        Vector store = new Vector();
        try {
            kmproc = Runtime.getRuntime().exec(command, envp);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.RUNNING_PROCESSES_RUNTIME_EXCEPTION, new Object[0]);
        }
        StreamGobbler outputGobbler = new StreamGobbler(kmproc.getInputStream(), this, "OUTPUT");
        outputGobbler.start();
        StreamGobbler errorGobbler = new StreamGobbler(kmproc.getErrorStream(), this, "ERROR");
        errorGobbler.start();
        try {
            kmproc.waitFor();
            outputGobbler.join();
            errorGobbler.join();
        }
        catch (InterruptedException e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.RUNNING_PROCESSES_RUNTIME_EXCEPTION, new Object[0]);
        }
        if (this.errorOccured) {
            throw new InstallException((ErrorCode)CommonErrorCode.RUNNING_PROCESSES_RUNTIME_EXCEPTION, new Object[0]);
        }
    }
}

