/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.HashMap;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.ProxyFactory;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.ClusterWindows;

public class IPMIWrapper {
    private static IPMIWrapper instance = null;
    private static final String strIPMIFile = "/dev/ipmi0";
    private static final String strIPMIRegistryKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\IPMIDrv";
    private static final HashMap<Integer, String> supportedPlatforms = new HashMap();

    protected IPMIWrapper() {
    }

    public static IPMIWrapper getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (IPMIWrapper)(proxyFactory = ProxyFactory.getInstance()).createProxy(IPMIWrapper.class)) == null) {
            instance = new IPMIWrapper();
        }
        return instance;
    }

    public boolean isIPMIDriverInstalled(String[] arrNodes) {
        ClusterCmd ccmd = new ClusterCmd();
        String regKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\IPMIDRV";
        if (PlatformInfo.getInstance().isWindows()) {
            boolean keyExists = true;
            try {
                String arrNode;
                ClusterWindows clusterWindows = new ClusterWindows();
                String[] arr$ = arrNodes;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (keyExists = clusterWindows.regKeyExistsOnNode("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\IPMIDRV", arrNode = arr$[i$])); ++i$) {
                }
                return keyExists;
            }
            catch (ClusterException e) {}
        } else {
            try {
                return ccmd.pathExists(arrNodes, strIPMIFile, 0);
            }
            catch (ClusterException e) {
            }
            catch (ClusterOperationException e) {
                // empty catch block
            }
        }
        return false;
    }

    public String getUserCredCookie(String strBMCUsername, String strBMCPassword) {
        return "ImplementaionPending";
    }

    public boolean isCurrentPlatformSupported() {
        PlatformInfo pInfo = PlatformInfo.getInstance();
        if (pInfo.isWindows()) {
            return true;
        }
        return supportedPlatforms.containsKey(pInfo.getCurrentPlatform());
    }

    public String getIPMIString() {
        PlatformInfo pInfo = PlatformInfo.getInstance();
        if (pInfo.isWindows()) {
            return strIPMIRegistryKey;
        }
        int currentPlatform = pInfo.getCurrentPlatform();
        if (supportedPlatforms.containsKey(currentPlatform)) {
            return supportedPlatforms.get(currentPlatform);
        }
        return null;
    }

    public HashMap getSupportedPlatforms() {
        return supportedPlatforms;
    }

    static {
        supportedPlatforms.put(46, strIPMIFile);
    }
}

