/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.PlatformInfo;

public class JarUtil {
    private static JarUtil instance = null;

    public static JarUtil getInstance() {
        if (instance == null) {
            instance = new JarUtil();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipDirectoryContentOnly(String dirLocation, File zipFile, String dirInZipFile) throws IOException, Exception {
        boolean bCreate;
        File dir;
        ZipEntry entry = null;
        FileOutputStream out = null;
        ZipInputStream zis = null;
        if (zipFile == null) {
            throw new Exception("Zip File specified is null");
        }
        if (dirLocation != null && !(dir = new File(dirLocation)).exists() && !(bCreate = dir.mkdirs())) {
            throw new IOException("Error Creating directory: " + dir);
        }
        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        try {
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || dirLocation == null) continue;
                String fileName = entry.getName();
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                String dirName = entry.getName();
                int slashIndex = dirName.lastIndexOf("/");
                if (slashIndex > 0) {
                    dirName = dirName.substring(0, slashIndex);
                }
                if (slashIndex != -1 && !dirName.equals(dirInZipFile)) continue;
                out = new FileOutputStream(new File(dirLocation + File.separatorChar + fileName));
                JarUtil.copyStream(zis, out);
                if (PlatformInfo.getInstance().isWindows()) continue;
                InstallHelper.setPermission(dirLocation + File.separatorChar + fileName, "755");
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            entry = null;
            zis = null;
        }
    }

    public static void unzipFile(String dirLocation, File zipFile) throws IOException, Exception {
        boolean bCreate;
        File dir;
        ZipInputStream zis = null;
        if (zipFile == null) {
            throw new Exception("Zip File specified is null");
        }
        if (dirLocation != null && !(dir = new File(dirLocation)).exists() && !(bCreate = dir.mkdirs())) {
            throw new IOException("Error Creating directory: " + dir);
        }
        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        JarUtil.unzipFile(dirLocation, zis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(String dirLocation, ZipInputStream zis) throws IOException, Exception {
        ZipEntry entry = null;
        FileOutputStream out = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                File parentDir;
                if (entry.isDirectory()) {
                    File zipDir = null;
                    if (dirLocation != null) {
                        zipDir = new File(dirLocation + File.separatorChar + entry.getName());
                    }
                    if (zipDir.exists()) continue;
                    zipDir.mkdirs();
                    continue;
                }
                if (dirLocation != null) {
                    parentDir = new File(dirLocation + File.separatorChar + entry.getName()).getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    out = new FileOutputStream(new File(dirLocation + File.separatorChar + entry.getName()));
                } else {
                    parentDir = new File(entry.getName()).getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    out = new FileOutputStream(new File(entry.getName()));
                }
                JarUtil.copyStream(zis, out);
                if (PlatformInfo.getInstance().isWindows()) continue;
                if (dirLocation != null) {
                    InstallHelper.setPermission(dirLocation + File.separatorChar + entry.getName(), "755");
                    continue;
                }
                InstallHelper.setPermission(entry.getName(), "755");
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            entry = null;
            zis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipSpecifiedFileOnly(String dirLocation, File zipFile) throws IOException, Exception {
        boolean bCreate;
        File dir;
        ZipEntry entry = null;
        FileOutputStream out = null;
        ZipInputStream zis = null;
        if (zipFile == null) {
            throw new Exception("Zip File specified is null");
        }
        if (dirLocation != null && !(dir = new File(dirLocation)).exists() && !(bCreate = dir.mkdirs())) {
            throw new IOException("Error Creating directory: " + dir);
        }
        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        try {
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                if (dirLocation != null) {
                    String fileName = entry.getName();
                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                    out = new FileOutputStream(new File(dirLocation + File.separatorChar + fileName));
                } else {
                    File parentDir = new File(entry.getName()).getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    out = new FileOutputStream(new File(entry.getName()));
                }
                JarUtil.copyStream(zis, out);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            entry = null;
            zis = null;
        }
    }

    private static final void copyStream(ZipInputStream in, FileOutputStream out) throws IOException {
        int count;
        if (in == null || out == null) {
            return;
        }
        BufferedOutputStream destination = null;
        byte[] databuff = new byte[2048];
        destination = new BufferedOutputStream(out, 2048);
        while ((count = in.read(databuff, 0, 2048)) != -1) {
            destination.write(databuff, 0, count);
        }
        destination.flush();
        destination.close();
    }

    public static void main(String[] args) {
        try {
            JarUtil.unzipDirectoryContentOnly("D:\\test7788", new File("D:\\Assignments.zip"), "Assignments/Assignments");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

