/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixRegistryOps;

public class MachineInfo {
    private static final Logger logger = Logger.getLogger(MachineInfo.class.getName());
    private static MachineInfo instance = null;
    private Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());

    protected MachineInfo() {
    }

    public static MachineInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (MachineInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(MachineInfo.class)) == null) {
            instance = new MachineInfo();
        }
        return instance;
    }

    public String getDomainName(String strHostName) throws InstallException {
        String fullHostName;
        String ipAddress;
        try {
            ipAddress = this.getIPAddressForHostName(strHostName);
        }
        catch (UnknownHostException e) {
            throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOST_NAME_INVALID, strHostName);
        }
        try {
            fullHostName = this.getHostNameForIPAddress(ipAddress);
        }
        catch (UnknownHostException e) {
            throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOST_NAME_NOT_RESOLVED, strHostName);
        }
        String domainName = OiixNetOps.getDomainName((String)fullHostName);
        return domainName;
    }

    public boolean isHostExadata() {
        boolean isExadata = false;
        String tstExadata = System.getProperty("oracle.install.isExadata");
        if (tstExadata != null && tstExadata.length() > 0 && tstExadata.equalsIgnoreCase("true")) {
            return true;
        }
        if ((PlatformInfo.getInstance().isLinux() || PlatformInfo.getInstance().isSolaris() || PlatformInfo.getInstance().isSolarisSparc64() || PlatformInfo.getInstance().isIntelSolaris()) && new File("/etc/oracle/cell/network-config/cellip.ora").exists()) {
            isExadata = true;
        }
        return isExadata;
    }

    public String getFullQualifiedHostName(String hostName) {
        String fqnName = hostName;
        if (hostName != null && hostName.indexOf(46) == -1) {
            try {
                String domainName = MachineInfo.getInstance().getDomainName(hostName);
                if (domainName != null && domainName.length() > 0) {
                    fqnName = hostName + "." + domainName;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to retrieve the full host name");
            }
        }
        return fqnName;
    }

    public String getFullHostName() {
        Application.showStatus((String)this.resource.getString("FETCHING_HOSTNAME", "Gathering system details...", new Object[0]));
        SetupDriver setupDriver = SetupDriver.getInstance();
        Properties clArgs = setupDriver.getCommandLineArgs();
        String sOracleHostname = null;
        if (clArgs != null && (sOracleHostname = clArgs.getProperty("oracle_hostname")) != null) {
            Application.hideStatus();
            return sOracleHostname;
        }
        String hostname = OiixNetOps.getFullHostName();
        if (hostname == null || hostname.equalsIgnoreCase("localhost") || GenericValidation.validateIP(hostname)) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.WARNING, "UnknownHostException occurred while getting local node", e.getMessage());
            }
        }
        Application.hideStatus();
        return hostname;
    }

    public String getDefPubName(String strNode) {
        return strNode;
    }

    public String getDefVIPName(String strNode) {
        int iIndex = strNode.indexOf(".");
        String strVIP = iIndex != -1 ? strNode.substring(0, iIndex) + "-vip" + strNode.substring(iIndex) : strNode + "-vip";
        return strVIP;
    }

    public String getMachineName(String strNode) {
        return OiixNetOps.getMachineName((String)strNode);
    }

    public String getHostIPAddress() {
        return OiixNetOps.getHostIPAddress();
    }

    public String getHostNameForIPAddress(String ipAddress) throws UnknownHostException {
        return OiixNetOps.getHostNameForIPAddress((String)ipAddress);
    }

    public String getIPAddressForHostName(String hostName) throws UnknownHostException {
        return OiixNetOps.getIPAddressForHostName((String)hostName);
    }

    public String[] getAllHostNames() {
        return OiixNetOps.getAllHostNames();
    }

    public String[] getAllIPAddressesForHostName(String hostName) throws UnknownHostException {
        return OiixNetOps.getAllIPAddressesForHostName((String)hostName);
    }

    public boolean isLocalHost(String hostName) {
        boolean localHost = false;
        try {
            InetAddress[] addresses = InetAddress.getAllByName(hostName);
            for (int i = 0; i < addresses.length; ++i) {
                NetworkInterface networkInterface = NetworkInterface.getByInetAddress(addresses[i]);
                if (networkInterface == null) continue;
                localHost = true;
                break;
            }
        }
        catch (UnknownHostException e) {
            logger.log(Level.FINE, "Unknown Host: {0}. Error: {1}", new Object[]{hostName, e.getMessage()});
        }
        catch (SocketException e) {
            logger.log(Level.FINE, "Invalid Host: {0}. Error: {1}", new Object[]{hostName, e.getMessage()});
        }
        return localHost;
    }

    public String getDomainName() {
        String domain = null;
        try {
            String host = this.getFullHostName();
            domain = this.getDomainName(host);
        }
        catch (InstallException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        return domain;
    }

    public boolean isLocalPortAvailable(int iPortNumber) {
        String[] strNode = new String[]{this.getHostIPAddress()};
        try {
            return Cluster.isPortAvailable((String[])strNode, (int)iPortNumber);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getFreePort(int minPort, int maxPort) {
        for (int i = minPort; i <= maxPort; ++i) {
            if (!this.isLocalPortAvailable(i)) continue;
            return String.valueOf(i);
        }
        return null;
    }

    public boolean isIPv4InterfacePresent() throws InstallException {
        try {
            Enumeration<NetworkInterface> enumInterfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> arrInterfaces = new ArrayList<NetworkInterface>();
            while (enumInterfaces.hasMoreElements()) {
                arrInterfaces.add(enumInterfaces.nextElement());
            }
            for (NetworkInterface oInterface : arrInterfaces) {
                if (oInterface.equals(NetworkInterface.getByInetAddress(InetAddress.getByName(null)))) continue;
                Enumeration<InetAddress> enumInetAddress = oInterface.getInetAddresses();
                ArrayList<InetAddress> arrInetAddress = new ArrayList<InetAddress>();
                while (enumInetAddress.hasMoreElements()) {
                    arrInetAddress.add(enumInetAddress.nextElement());
                }
                for (InetAddress oInetAddress : arrInetAddress) {
                    if (oInetAddress instanceof Inet4Address) {
                        logger.info(oInetAddress.getHostAddress() + " is ipv4\n");
                        return true;
                    }
                    if (!(oInetAddress instanceof Inet6Address) || !((Inet6Address)oInetAddress).isIPv4CompatibleAddress()) continue;
                    logger.info(oInetAddress.getHostAddress() + " is ipv4 compatible\n");
                    return true;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            throw new InstallException(e);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new InstallException(e);
        }
        return false;
    }

    public boolean checkGroupExistance(String groupName) throws UnhandledDriverException {
        boolean groupExists = false;
        try {
            VerificationResult result = CVUHelper.getInstance().checkGroupExistence(groupName);
            if (result != null) {
                NodeResultStatus nodeResult = result.getNodeResultStatus();
                if (nodeResult == NodeResultStatus.OPERATION_FAILED) {
                    throw new UnhandledDriverException((ErrorCode)CommonErrorCode.GROUP_EXISTANCE_CHECK_FAILED, new Object[0]);
                }
                if (nodeResult == NodeResultStatus.VERIFICATION_FAILED) {
                    groupExists = false;
                }
                if (nodeResult == NodeResultStatus.SUCCESSFUL) {
                    groupExists = true;
                }
            }
        }
        catch (VerificationException e) {
            logger.log(Level.INFO, "failed to check the groups on the local node", e);
            throw new UnhandledDriverException((ErrorCode)CommonErrorCode.GROUP_EXISTANCE_CHECK_FAILED, new Object[0]);
        }
        return groupExists;
    }

    public String getMTSPortNumber() {
        String defaultPortNumber = null;
        defaultPortNumber = InstallHelper.getValue("MTS_PORT");
        try {
            String key = "HKEY_LOCAL_MACHINE";
            String subKey = "software\\oracle\\OracleMTSRecoveryService\\Protid_0";
            if (OiixRegistryOps.RegKeyExists((String)key, (String)subKey)) {
                if (defaultPortNumber != null && defaultPortNumber.length() > 0) {
                    logger.log(Level.FINEST, "Port number provided in the command line will not be honored because there is a registry entry for MTS port already.");
                }
                defaultPortNumber = OiixRegistryOps.RegGetValue((String)key, (String)subKey, (String)"Port");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not retrieve the value of the OraMTS port registry key");
        }
        if (defaultPortNumber == null || defaultPortNumber.equalsIgnoreCase("")) {
            defaultPortNumber = MachineInfo.getInstance().getFreePort(InstallConstants.WIN_PORT_NUMBER_RANGE_MIN, InstallConstants.WIN_PORT_NUMBER_RANGE_MAX);
        }
        return defaultPortNumber;
    }

    public String getLocalMachineName() {
        Application.showStatus((String)this.resource.getString("FETCHING_HOSTNAME", "Gathering system details...", new Object[0]));
        SetupDriver setupDriver = SetupDriver.getInstance();
        Properties clArgs = setupDriver.getCommandLineArgs();
        String sOracleHostname = null;
        if (clArgs != null && (sOracleHostname = clArgs.getProperty("oracle_hostname")) != null) {
            Application.hideStatus();
            return this.getMachineName(sOracleHostname);
        }
        String hostname = "";
        try {
            hostname = this.getMachineName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "UnknownHostException occurred while getting local node", e.getMessage());
        }
        Application.hideStatus();
        return hostname;
    }

    public static void main(String[] args) {
    }
}

