/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.List;
import java.util.logging.Logger;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.message.Content;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.cvu.CVUHelper;

public class NetworkInterfaceInfo {
    private static Logger logger = Logger.getLogger(NetworkInterfaceInfo.class.getName());

    public static boolean checkInterfaceConnectionAcrossNodes(String interfaceName, List<String> nodeList, String subnet) {
        VerificationResultSet resultSet = null;
        try {
            CVUHelper clusterVerification = CVUHelper.getInstance();
            resultSet = clusterVerification.checkNodeConnectivity(nodeList.toArray(new String[0]), interfaceName, subnet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
        }
        catch (VerificationException e) {
            throw new UnhandledDriverException((Content)UnhandledDriverException.createExtraDetails(resultSet), (ErrorCode)CommonErrorCode.NODE_CONECTIVITY_CHECK_FAILED_FOR_INTERFACE, new Object[]{interfaceName});
        }
        return false;
    }
}

