/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.NtSetEnv;
import oracle.sysman.oii.oiix.OiixGeneralQueries;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class PlatformInfo {
    private static PlatformInfo instance;

    protected PlatformInfo() {
    }

    public static PlatformInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (PlatformInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(PlatformInfo.class)) == null) {
            instance = new PlatformInfo();
        }
        return instance;
    }

    public int getCurrentPlatform() {
        return OiixPlatform.getCurrentPlatform();
    }

    public int getPlatGroup(int platId) {
        return OiixPlatform.getPlatGroup((int)platId);
    }

    public String getEnv(String varName) {
        return OiixGeneralQueries.getEnv((String)varName);
    }

    public void setEnv(String varName, String value) {
        OiixGeneralQueries.setEnv((String)varName, (String)value);
    }

    public String getDomainName(String hostName) {
        return OiixNetOps.getDomainName((String)hostName);
    }

    public String getFullHostName() {
        try {
            String hostname = MachineInfo.getInstance().getFullHostName();
            if (hostname != null) {
                return hostname;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getDefaultCharset() {
        return "WE8MSWIN1252";
    }

    public boolean isWindows() {
        boolean windows = false;
        int platform = OiixPlatform.getCurrentPlatform();
        switch (platform) {
            case 50: 
            case 208: 
            case 233: 
            case 615: 
            case 912: {
                windows = true;
            }
        }
        return windows;
    }

    public boolean isLinux() {
        return OiixPlatform.getCurrentPlatform() == 46;
    }

    public boolean isLinux64() {
        return OiixPlatform.getCurrentPlatform() == 226;
    }

    public boolean isUnix() {
        return this.getPlatGroup(this.getCurrentPlatform()) == -1;
    }

    public boolean isSolarisSparc64() {
        return OiixPlatform.getCurrentPlatform() == 23;
    }

    public boolean isSolaris() {
        return OiixPlatform.getCurrentPlatform() == 453;
    }

    public boolean isIntelSolaris() {
        return OiixPlatform.getCurrentPlatform() == 173;
    }

    public boolean isAix() {
        return OiixPlatform.getCurrentPlatform() == 610 || OiixPlatform.getCurrentPlatform() == 212;
    }

    public boolean isZlinux() {
        return OiixPlatform.getCurrentPlatform() == 211;
    }

    public void setEnvForWindows(String varname, String value) {
        NtSetEnv nativeObj = new NtSetEnv();
        nativeObj.setenv(varname, value, "session");
    }

    public boolean isWin32System() {
        String arch;
        boolean win32 = false;
        if (this.isWindows() && (arch = OiixPlatform.getCurrentPlatformArch()) != null && arch.equals("x86")) {
            win32 = true;
        }
        return win32;
    }
}

