/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.db.RAC92Info;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterwareType;
import oracle.install.library.util.cluster.SingleClusterNode;
import oracle.ops.mgmt.cluster.Cluster;

public class VendorClusterwareInfo {
    private static VendorClusterwareInfo instance = null;
    private static final Logger logger = Logger.getLogger(VendorClusterwareInfo.class.getName());
    private static List<String> nodeList;

    protected VendorClusterwareInfo() {
    }

    public static VendorClusterwareInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (VendorClusterwareInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(VendorClusterwareInfo.class)) == null) {
            instance = new VendorClusterwareInfo();
        }
        return instance;
    }

    public boolean isVendorClusterware() {
        if (PlatformInfo.getInstance().isWindows()) {
            return false;
        }
        return Cluster.isVendorCluster();
    }

    public ClusterConfig getClusterConfig() {
        ClusterConfig clusterConfig = null;
        MachineInfo machineInfo = MachineInfo.getInstance();
        List<String> nodeList = this.getNodeList();
        if (nodeList != null) {
            ArrayList<Object> rac92Nodes = new ArrayList();
            RAC92Info rac92Info = RAC92Info.getInstance();
            if (rac92Info.is92RACPresent()) {
                rac92Nodes = rac92Info.getNodeList(machineInfo.getFullHostName());
            }
            clusterConfig = new ClusterConfig();
            clusterConfig.setClusterwareType(ClusterwareType.VENDOR_CLUSTERWARE);
            ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
            for (int i = 0; i < nodeList.size(); ++i) {
                SingleClusterNode clusterNode = new SingleClusterNode();
                String publicNodeName = nodeList.get(i).toString();
                clusterNode.setPublicNodeName(publicNodeName);
                clusterNode.setVirtualHostName(machineInfo.getDefVIPName(publicNodeName));
                if (rac92Nodes.contains(publicNodeName)) {
                    clusterNode.setOracle9iRACDetected(true);
                }
                clusterNodes.add(clusterNode);
            }
            clusterConfig.setClusterNodes(clusterNodes);
        }
        return clusterConfig;
    }

    public List<String> getNodeList() {
        return this.getNodeList(true);
    }

    public List<String> getNodeList(boolean reload) {
        if (reload) {
            nodeList = this.loadNodeList();
        }
        return nodeList;
    }

    private List<String> loadNodeList() {
        String binpath = InstallHelper.getInstallBinariesPath();
        final ArrayList<String> nodelist = new ArrayList<String>();
        if (binpath == null) {
            return nodelist;
        }
        File file = new File(binpath, "lsnodes");
        if (!file.exists()) {
            return nodelist;
        }
        String execpath = file.getAbsolutePath();
        ProcessBuilder pb = new ProcessBuilder(execpath);
        pb.environment().remove("LD_LIBRARY_PATH");
        pb.environment().remove("LIBPATH");
        pb.environment().remove("SHLIB_PATH");
        try {
            AbstractLineProcessor lineParse = new AbstractLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    nodelist.add(line);
                }
            };
            ProcessLaunchInfo pli = new ProcessLaunchInfo(pb, (OutputProcessor)lineParse, null);
            ProcessLauncher.launch((ProcessLaunchInfo)pli);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed while executing lsnodes command", e);
        }
        return nodelist;
    }
}

