/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.cluster.credentials.ASMProperties;
import oracle.cluster.credentials.GNSProperties;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import org.w3c.dom.Document;

public class WrapfileUtil {
    private static WrapfileUtil instance;

    private WrapfileUtil() {
    }

    public static WrapfileUtil getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (WrapfileUtil)(proxyFactory = ProxyFactory.getInstance()).createProxy(WrapfileUtil.class)) == null) {
            instance = new WrapfileUtil();
        }
        return instance;
    }

    public Wrapfile getWrapfileObj(String sWrapfile) throws InstallException {
        return new Wrapfile(sWrapfile);
    }

    public ASMWrapfile getASMWrapfileObj(String sWrapfile) throws InstallException {
        return new ASMWrapfile(sWrapfile);
    }

    public GNSWrapfile getGNSWrapfileObj(String sWrapfile) throws InstallException {
        return new GNSWrapfile(sWrapfile);
    }

    public class ASMWrapfile
    extends Wrapfile {
        ASMProperties props;

        public ASMWrapfile(String sWrapFile) throws InstallException {
            super(sWrapFile, WrapfileType.ASM);
            this.validate();
        }

        @Override
        public void validate() throws InstallException {
            super.validate();
        }
    }

    public class GNSWrapfile
    extends Wrapfile {
        private GNSProperties props;

        public GNSWrapfile(String sWrapFile) throws InstallException {
            super(sWrapFile, WrapfileType.GNS);
            this.validate();
        }

        @Override
        public void validate() throws InstallException {
            super.validate();
        }
    }

    public class Wrapfile {
        private String path;
        private WrapfileType type;

        public Wrapfile(String filePath, WrapfileType fileType) throws InstallException {
            this.path = filePath;
            this.type = fileType;
            this.validate();
        }

        public Wrapfile(String filePath) throws InstallException {
            this(filePath, WrapfileType.DEFAULT);
        }

        public String getPath() {
            return this.path;
        }

        public WrapfileType getType() {
            return this.type;
        }

        public void validate() throws InstallException {
            if (this.path == null || this.path.trim().length() == 0) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_PATH_EMPTY, new Object[0]);
            }
            File oFile = new File(this.path.trim());
            if (!(oFile.isFile() && oFile.exists() && oFile.canRead())) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_INVALID, new Object[0]);
            }
            DocumentBuilderFactory documentfactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentbuilder = documentfactory.newDocumentBuilder();
                Document document = documentbuilder.parse(oFile);
            }
            catch (Exception e) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_NOT_WELL_FORMED, new Object[0]);
            }
        }
    }

    public static enum WrapfileType {
        DEFAULT,
        ASM,
        GNS;

    }
}

