/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.db.RAC92Info;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.VendorClusterwareInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterConfigException;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterwareType;
import oracle.install.library.util.cluster.SingleClusterNode;

public class ClusterSupport {
    private static final Logger logger = Logger.getLogger(ClusterSupport.class.getName());
    private static ClusterSupport instance = null;
    private ClusterConfig clusterConfig = null;
    private SingleClusterNode localClusterNode;

    public static ClusterSupport getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (ClusterSupport)(proxyFactory = ProxyFactory.getInstance()).createProxy(ClusterSupport.class)) == null) {
            instance = new ClusterSupport();
        }
        return instance;
    }

    protected ClusterSupport() {
    }

    public ClusterConfig createClusterConfig(boolean isAutoVIPEnabled) {
        ClusterConfig clusterConfig = new ClusterConfig();
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        clusterConfig.setClusterwareType(ClusterwareType.ORACLE_CLUSTERWARE);
        clusterConfig.setClusterNodes(clusterNodes);
        clusterNodes.add(this.getLocalClusterNode(isAutoVIPEnabled));
        return clusterConfig;
    }

    public SingleClusterNode getLocalClusterNode(boolean isAutoVIPEnabled) {
        if (this.localClusterNode == null) {
            MachineInfo machineInfo = MachineInfo.getInstance();
            String localHostName = machineInfo.getFullHostName();
            this.localClusterNode = new SingleClusterNode();
            this.localClusterNode.setLocalNode(true);
            this.localClusterNode.setPublicNodeName(machineInfo.getDefPubName(localHostName));
            if (!isAutoVIPEnabled) {
                this.localClusterNode.setVirtualHostName(machineInfo.getDefVIPName(localHostName));
            } else {
                this.localClusterNode.setVirtualHostName("AUTO");
            }
        }
        return this.localClusterNode;
    }

    public ClusterConfig getDefaultClusterConfig() {
        if (this.clusterConfig == null) {
            VendorClusterwareInfo vendorClusterwareInfo = VendorClusterwareInfo.getInstance();
            if (vendorClusterwareInfo.isVendorClusterware()) {
                logger.info("Found Vendor Clusterware. Fetching Cluster Configuration");
                this.clusterConfig = vendorClusterwareInfo.getClusterConfig();
            } else {
                RAC92Info rac92Info = RAC92Info.getInstance();
                if (rac92Info.is92RACPresent()) {
                    logger.info("Found Oracle 9i RAC. Fetching Cluster Configuration");
                    this.clusterConfig = rac92Info.getClusterConfig();
                }
            }
        }
        return this.clusterConfig == null ? null : (ClusterConfig)((Object)this.clusterConfig.clone());
    }

    public ClusterConfig loadClusterConfiguration(File ccf, boolean isBigCluster) throws ClusterConfigException {
        ClusterConfig clusterConfig = null;
        FileInputStream ccfIn = null;
        try {
            ccfIn = new FileInputStream(ccf);
            clusterConfig = this.loadClusterConfiguration(ccfIn, isBigCluster);
            clusterConfig.setClusterwareType(ClusterwareType.ORACLE_CLUSTERWARE);
        }
        catch (FileNotFoundException e) {
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        finally {
            if (ccfIn != null) {
                try {
                    ccfIn.close();
                }
                catch (IOException e) {
                    throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
                }
            }
        }
        return clusterConfig;
    }

    public ClusterConfig loadClusterConfiguration(InputStream ccfIn, boolean isBigCluster) throws ClusterConfigException {
        ClusterConfig clusterConfig = new ClusterConfig();
        String line = null;
        String[] data = null;
        int ccfLineNumber = 0;
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        clusterConfig.setClusterNodes(clusterNodes);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(ccfIn));
            while ((line = in.readLine()) != null) {
                ++ccfLineNumber;
                line = line.trim().replaceAll("\\t", " ").replaceAll("\\s{2,}", " ");
                logger.log(Level.FINEST, "Processing line: {0}", line);
                if (line.length() == 0 || line.startsWith("#")) continue;
                data = line.split(" ");
                SingleClusterNode clusterNode = new SingleClusterNode();
                if (data.length == 1) {
                    clusterNode.setPublicNodeName(data[0]);
                } else if (data.length == 2) {
                    clusterNode.setPublicNodeName(data[0]);
                    if (data[1].startsWith("/")) {
                        clusterNode.setVirtualHostName("");
                        if (data[1].substring(1).trim().length() > 0) {
                            clusterNode.setNodeType(this.getNodeType(data[1].substring(1).trim(), isBigCluster, String.valueOf(ccfLineNumber)));
                        }
                    } else {
                        clusterNode.setVirtualHostName(data[1]);
                    }
                } else if (data.length == 3) {
                    clusterNode.setPublicNodeName(data[0]);
                    if (data[2].startsWith("/")) {
                        if (data[2].substring(1).trim().length() > 0) {
                            clusterNode.setNodeType(this.getNodeType(data[2].substring(1).trim(), isBigCluster, String.valueOf(ccfLineNumber)));
                        }
                        clusterNode.setVirtualHostName(data[1]);
                    } else {
                        clusterNode.setVirtualHostName(data[2]);
                    }
                } else {
                    throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_INCORRECT_FORMAT, new Object[0]);
                }
                this.validateClusterNode(clusterNode, isBigCluster, String.valueOf(ccfLineNumber));
                clusterNodes.add(clusterNode);
            }
        }
        catch (IOException e) {
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            logger.severe("Exception occurred while reading from cluster config file" + e);
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        ClusterNode localClusterNode = this.getLocalClusterNode(false);
        int index = clusterNodes.indexOf(localClusterNode);
        if (index != -1) {
            localClusterNode = clusterNodes.get(index);
            localClusterNode.setLocalNode(true);
        }
        return clusterConfig;
    }

    private void validateClusterNode(SingleClusterNode clusterNode, boolean isBigCluster, String ccfLineNumber) throws ClusterConfigException {
        if (isBigCluster) {
            if (clusterNode.getNodeType() == null) {
                clusterNode.setNodeType(ClusterNode.NodeType.HUB);
            }
        } else if (clusterNode.getNodeType() != null) {
            clusterNode.setNodeType(null);
        }
        this.validatePublicHostName(clusterNode.getPublicNodeName(), ccfLineNumber);
        this.validatePrivateHostName(clusterNode.getVirtualHostName(), clusterNode.getNodeType(), ccfLineNumber);
    }

    private void validatePublicHostName(String nodeHostName, String ccfLineNumber) throws ClusterConfigException {
        String strBadCharsFound = GenericValidation.validateBadCharGetString(" !@%^&*()+=\\|`~[{]};'\",<>/?#$:", nodeHostName);
        if (!GenericValidation.validateForEmptiness(strBadCharsFound)) {
            throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_NODE_HOSTNAME_BADCHAR, nodeHostName, ccfLineNumber);
        }
    }

    private void validatePrivateHostName(String nodeHostName, ClusterNode.NodeType nodeType, String ccfLineNumber) throws ClusterConfigException {
        if (nodeType != ClusterNode.NodeType.RIM || !GenericValidation.validateForEmptiness(nodeHostName)) {
            if (GenericValidation.validateForEmptiness(nodeHostName)) {
                throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_NODE_PRIVATE_HOSTNAME_BLANK, ccfLineNumber);
            }
            String strBadCharsFound = GenericValidation.validateBadCharGetString(" !@%^&*()+=\\|`~[{]};'\",<>/?#$:", nodeHostName);
            if (!GenericValidation.validateForEmptiness(strBadCharsFound)) {
                throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_NODE_HOSTNAME_BADCHAR, nodeHostName, ccfLineNumber);
            }
        }
    }

    private ClusterNode.NodeType getNodeType(String nodeTypeStr, boolean isBigCluster, String ccfLineNumber) throws ClusterConfigException {
        if (nodeTypeStr != null && nodeTypeStr.length() > 0) {
            if (nodeTypeStr.equalsIgnoreCase("HUB")) {
                return ClusterNode.NodeType.HUB;
            }
            if (nodeTypeStr.equalsIgnoreCase("LEAF")) {
                return ClusterNode.NodeType.RIM;
            }
            if (nodeTypeStr.equalsIgnoreCase("AUTO")) {
                return ClusterNode.NodeType.AUTO;
            }
            if (isBigCluster) {
                throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_INCORRECT_NODE_TYPE, nodeTypeStr, ccfLineNumber);
            }
        }
        return null;
    }

    public static ClusterConfig updateClusterConfig(ClusterConfig clusterCfgFromClusterSupport, ClusterConfig clusterConfig) {
        if (clusterCfgFromClusterSupport != null && clusterConfig != null) {
            List<ClusterNode> nodeList = clusterCfgFromClusterSupport.getClusterNodes();
            HashMap<String, ClusterNode> map = new HashMap<String, ClusterNode>();
            for (ClusterNode node : nodeList) {
                if (!(node instanceof SingleClusterNode)) continue;
                map.put(((SingleClusterNode)node).getPublicNodeName(), node);
            }
            for (ClusterNode nodeFromTable : clusterConfig.getClusterNodes()) {
                ClusterNode node;
                if (nodeFromTable == null || !(nodeFromTable instanceof SingleClusterNode)) continue;
                String pubNodeName = ((SingleClusterNode)nodeFromTable).getPublicNodeName();
                if (pubNodeName.indexOf(".") != -1) {
                    pubNodeName = pubNodeName.substring(0, pubNodeName.indexOf("."));
                }
                if ((node = (ClusterNode)map.get(pubNodeName)) != null || (node = (ClusterNode)map.get(((SingleClusterNode)nodeFromTable).getPublicNodeName())) != null) {
                    if (node instanceof SingleClusterNode) {
                        ((SingleClusterNode)node).setVirtualHostName(((SingleClusterNode)nodeFromTable).getVirtualHostName());
                        ((SingleClusterNode)node).setPublicNodeName(((SingleClusterNode)nodeFromTable).getPublicNodeName());
                    }
                } else {
                    nodeList.add(nodeFromTable);
                }
                map.remove(pubNodeName);
                map.remove(((SingleClusterNode)nodeFromTable).getPublicNodeName());
            }
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                nodeList.remove(map.get(i.next()));
            }
            clusterCfgFromClusterSupport.setClusterNodes(nodeList);
        }
        return clusterCfgFromClusterSupport;
    }
}

