/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.library.util.Node;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.SingleClusterNode;

@BeanDef(value="MultiClusterNode")
public class MultiClusterNode
extends ClusterNode {
    private int lowerBound;
    private int higherBound;
    private String hostSuffix;
    private String hostPrefix;
    private String vipSuffix;
    private Logger logger = Logger.getLogger(MultiClusterNode.class.getName());

    @PropertyDef(value="HostPrefix")
    public String getHostPrefix() {
        return this.hostPrefix;
    }

    public void setHostPrefix(String hostPrefix) {
        this.hostPrefix = hostPrefix;
    }

    @PropertyDef(value="VirtualIPSuffix")
    public String getVipSuffix() {
        return this.vipSuffix;
    }

    public void setVipSuffix(String vipSuffix) {
        this.vipSuffix = vipSuffix;
    }

    @PropertyDef(value="HostSuffix")
    public String getHostSuffix() {
        return this.hostSuffix;
    }

    public void setHostSuffix(String hostSuffix) {
        this.hostSuffix = hostSuffix == null ? "" : hostSuffix;
    }

    @PropertyDef(value="HigherBound")
    public int getHigherBound() {
        return this.higherBound;
    }

    public void setHigherBound(int higherBound) {
        this.higherBound = higherBound;
    }

    @PropertyDef(value="LowerBound")
    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public List<SingleClusterNode> getExpandedClusterNodeList() {
        return this.getExpandedClusterNodeList(false);
    }

    public List<SingleClusterNode> getExpandedClusterNodeList(boolean isDHCP) {
        ArrayList<SingleClusterNode> listOfNodes = new ArrayList<SingleClusterNode>();
        if (this.higherBound > this.lowerBound) {
            for (int i = this.lowerBound; i <= this.higherBound; ++i) {
                SingleClusterNode n = new SingleClusterNode();
                if (super.getNodeType() != null) {
                    super.setNodeType(super.getNodeType());
                }
                String suffix = this.hostSuffix == null ? "" : this.hostSuffix;
                n.setPublicNodeName(this.hostPrefix + Integer.toString(i) + suffix);
                if (isDHCP) {
                    n.setVirtualHostName("AUTO");
                } else if (this.getNodeType() == ClusterNode.NodeType.RIM) {
                    n.setVirtualHostName("");
                } else if (this.vipSuffix != null && this.vipSuffix.length() > 0) {
                    n.setVirtualHostName(this.hostPrefix + Integer.toString(i) + suffix + this.vipSuffix);
                } else {
                    n.setVirtualHostName("");
                }
                listOfNodes.add(n);
            }
        }
        return listOfNodes;
    }

    public List<String> getAllPublicNodeNames() {
        String suffix;
        ArrayList<String> publicNodeNames = new ArrayList<String>();
        String string = suffix = this.hostSuffix == null ? "" : this.hostSuffix;
        if (this.lowerBound <= this.higherBound) {
            for (int i = this.lowerBound; i <= this.higherBound; ++i) {
                String nodeName = this.hostPrefix + i + suffix;
                publicNodeNames.add(nodeName);
            }
        }
        return publicNodeNames;
    }

    public List<String> getAllVirtualHostNames() {
        String suffix;
        ArrayList<String> virtualHostNames = new ArrayList<String>();
        String string = suffix = this.hostSuffix == null ? "" : this.hostSuffix;
        if (this.lowerBound <= this.higherBound) {
            for (int i = this.lowerBound; i <= this.higherBound; ++i) {
                if (!this.vipSuffix.equalsIgnoreCase("AUTO")) {
                    String nodeName = "";
                    if (this.vipSuffix != null && this.vipSuffix.length() > 0) {
                        nodeName = this.hostPrefix + i + suffix + this.vipSuffix;
                    }
                    virtualHostNames.add(nodeName);
                    continue;
                }
                virtualHostNames.add("AUTO");
            }
        }
        return virtualHostNames;
    }

    public List<String> getAllPublicNodeNames(boolean fqn) {
        String suffix;
        ArrayList<String> publicNodeNames = new ArrayList<String>();
        String string = suffix = this.hostSuffix == null ? "" : this.hostSuffix;
        if (this.lowerBound <= this.higherBound) {
            for (int i = this.lowerBound; i <= this.higherBound; ++i) {
                String nodeName = this.hostPrefix + i + suffix;
                nodeName = Node.getHostName(nodeName, fqn);
                publicNodeNames.add(nodeName);
            }
        }
        return publicNodeNames;
    }

    public List<String> getAllVirtualHostNames(boolean fqn) {
        String suffix;
        ArrayList<String> virtualHostNames = new ArrayList<String>();
        String string = suffix = this.hostSuffix == null ? "" : this.hostSuffix;
        if (this.lowerBound <= this.higherBound) {
            for (int i = this.lowerBound; i <= this.higherBound; ++i) {
                if (!this.vipSuffix.equalsIgnoreCase("AUTO")) {
                    String nodeName = "";
                    if (this.vipSuffix != null && this.vipSuffix.length() > 0) {
                        nodeName = this.hostPrefix + i + suffix + this.vipSuffix;
                    }
                    virtualHostNames.add(nodeName);
                    continue;
                }
                virtualHostNames.add("AUTO");
            }
        }
        return virtualHostNames;
    }

    public List<String> getNamesOfNodes() {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (int i = this.lowerBound; i <= this.higherBound; ++i) {
            String suffix = this.hostSuffix == null ? "" : this.hostSuffix;
            String node = this.hostPrefix + i + suffix;
            nodeNames.add(node);
        }
        return nodeNames;
    }

    public String getPublicNodeName() {
        String suffix = this.hostSuffix == null ? "" : this.hostSuffix;
        return this.hostPrefix + this.lowerBound + suffix + "-" + this.hostPrefix + this.higherBound + suffix;
    }

    public String getVirtualNodeName() {
        String suffix;
        String vip = this.vipSuffix;
        if (this.getNodeType() != null && this.getNodeType() == ClusterNode.NodeType.RIM) {
            vip = "";
        }
        String string = suffix = this.hostSuffix == null ? "" : this.hostSuffix;
        if (!this.vipSuffix.equalsIgnoreCase("AUTO")) {
            if (this.vipSuffix != null && this.vipSuffix.length() > 0) {
                vip = this.hostPrefix + this.lowerBound + suffix + vip + "-" + this.hostPrefix + this.higherBound + suffix + this.vipSuffix;
            }
        } else {
            vip = "AUTO";
        }
        return vip;
    }

    public String toString() {
        String vip = this.vipSuffix;
        String suffix = this.hostSuffix == null ? "" : this.hostSuffix;
        String pattern = "%s:%s-%s:%s:%s";
        String multiClusterNodeString = String.format(pattern, this.hostPrefix, this.lowerBound, this.higherBound, suffix, vip);
        if (this.getNodeType() != null) {
            multiClusterNodeString = String.format("%s:%s-%s:%s:%s:%s", new Object[]{this.hostPrefix, this.lowerBound, this.higherBound, suffix, vip, this.getNodeType()});
        }
        return multiClusterNodeString;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        MultiClusterNode multiClusterNode = (MultiClusterNode)obj;
        if (multiClusterNode != null) {
            String prefix1 = this.hostPrefix;
            String prefix2 = multiClusterNode.hostPrefix;
            int upper1 = this.higherBound;
            int upper2 = multiClusterNode.higherBound;
            int lower1 = this.lowerBound;
            int lower2 = multiClusterNode.lowerBound;
            String suffix1 = this.hostSuffix;
            String suffix2 = multiClusterNode.hostSuffix;
            if (suffix1 != null && suffix2 != null) {
                result = prefix1.equals(prefix2) || suffix1.equals(suffix2) || upper1 == upper2 || lower1 == lower2;
            } else {
                if (suffix1 == null && suffix2 != null || suffix1 != null && suffix2 == null) {
                    return false;
                }
                result = prefix1.equals(prefix2) || upper1 == upper2 || lower1 == lower2;
            }
        }
        return result;
    }
}

