/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.text.MessageFormat;
import java.text.ParseException;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.cluster.ClusterNode;

@BeanDef(value="SingleClusterNode")
public class SingleClusterNode
extends ClusterNode {
    private String publicNodeName;
    private String virtualHostName;
    private static final MessageFormat format = new MessageFormat("{0}:{1}");

    public SingleClusterNode() {
    }

    public SingleClusterNode(String publicNodeName, String virtualHostName) {
        this.publicNodeName = publicNodeName;
        super.setName(publicNodeName);
        this.virtualHostName = virtualHostName;
    }

    @PropertyDef(value="PublicNodeName")
    public String getPublicNodeName() {
        return this.publicNodeName;
    }

    public String getPublicNodeName(boolean fqn) {
        return SingleClusterNode.getHostName(this.publicNodeName, fqn);
    }

    public void setPublicNodeName(String publicNodeName) {
        this.publicNodeName = publicNodeName;
        super.setName(publicNodeName);
    }

    @PropertyDef(value="VirtualHostName")
    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getVirtualHostName(boolean fqn) {
        return this.virtualHostName;
    }

    public void setVirtualHostName(String virtualHostName) {
        this.virtualHostName = virtualHostName;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        SingleClusterNode clusterNode = (SingleClusterNode)obj;
        if (clusterNode != null) {
            if (this.isLocalNode() && clusterNode.isLocalNode()) {
                result = true;
            } else {
                String nodeName1 = this.publicNodeName;
                String nodeName2 = clusterNode.publicNodeName;
                int index1 = nodeName1.indexOf(".");
                int index2 = nodeName2.indexOf(".");
                String shortName1 = nodeName1;
                String shortName2 = nodeName2;
                if (index1 > 0) {
                    shortName1 = nodeName1.substring(0, index1);
                }
                if (index2 > 0) {
                    shortName2 = nodeName2.substring(0, index2);
                }
                result = nodeName1.equals(nodeName2) || shortName1.equals(shortName2);
            }
        }
        return result;
    }

    public static SingleClusterNode parseClusterNode(String text) throws IllegalArgumentException {
        SingleClusterNode clusterNode;
        block4: {
            clusterNode = null;
            try {
                Object[] args = format.parse(text);
                if (args != null && args.length == 2) {
                    clusterNode = new SingleClusterNode();
                    String publicNodeName = (String)args[0];
                    clusterNode.setPublicNodeName(publicNodeName);
                    String virtualHostName = (String)args[1];
                    clusterNode.setVirtualHostName(virtualHostName);
                    MachineInfo machineInfo = MachineInfo.getInstance();
                    if (machineInfo.isLocalHost(publicNodeName)) {
                        clusterNode.setLocalNode(true);
                    }
                    break block4;
                }
                throw new IllegalArgumentException(text);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return clusterNode;
    }

    public String toString() {
        String pattern = "%s:%s";
        String clusterNodeString = String.format(pattern, this.getPublicNodeName(false), this.getVirtualHostName(false));
        if (this.getNodeType() != null) {
            clusterNodeString = String.format("%s:%s:%s", new Object[]{this.getPublicNodeName(false), this.getVirtualHostName(false), this.getNodeType()});
        }
        return clusterNodeString;
    }
}

