/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import oracle.security.oca.install.OCAInvalidCNValueException;
import oracle.security.oca.install.OCAInvalidCValueException;
import oracle.security.oca.install.OCAInvalidDNFormatException;
import oracle.security.oca.install.OCAMissingOException;
import oracle.security.oca.install.OCANotSupportedRDNException;
import oracle.security.oca.install.OCANullDNException;
import oracle.security.oca.install.OCAValidateDN;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OCADNValidation
implements OiilQuery {
    public Object performQuery(Vector inputs) throws OiilQueryException {
        String dn = (String)this.retItem(inputs, "dn");
        String hostname = (String)this.retItem(inputs, "hostname");
        String normDN = null;
        try {
            normDN = OCAValidateDN.validate(dn, hostname);
        }
        catch (OCAInvalidCNValueException cne) {
            System.out.println(cne.getMessage());
            String exName = "InvalidCNException";
            String exString = OiQueryFileRes.getString("InvalidCNException_desc");
            throw new OiilQueryException(exName, exString);
        }
        catch (OCAInvalidCValueException ce) {
            System.out.println(ce.getMessage());
            String exName = "InvalidCException";
            String exString = OiQueryFileRes.getString("InvalidCException_desc");
            throw new OiilQueryException(exName, exString);
        }
        catch (OCAInvalidDNFormatException dne) {
            System.out.println(dne.getMessage());
            String exName = "InvalidDNfmtException";
            String exString = OiQueryFileRes.getString("InvalidDNfmtException_desc");
            throw new OiilQueryException(exName, exString);
        }
        catch (OCAMissingOException oe) {
            System.out.println(oe.getMessage());
            String exName = "MissingOException";
            String exString = OiQueryFileRes.getString("MissingOException_desc");
            throw new OiilQueryException(exName, exString);
        }
        catch (OCANotSupportedRDNException rdne) {
            System.out.println(rdne.getMessage());
            String exName = "InvalidRDNException";
            String exString = OiQueryFileRes.getString("InvalidRDNException_desc");
            throw new OiilQueryException(exName, exString);
        }
        catch (OCANullDNException ndne) {
            System.out.println(ndne.getMessage());
            String exName = "NullDNException";
            String exString = OiQueryFileRes.getString("NullDNException_desc");
            throw new OiilQueryException(exName, exString);
        }
        System.out.println("validatingDN:" + normDN);
        return normDN;
    }

    Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public static void main(String[] args) {
        OCADNValidation tst = new OCADNValidation();
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        inputs.addElement(new OiilActionInputElement("dn", (Object)args[0]));
        inputs.addElement(new OiilActionInputElement("hostname", (Object)args[1]));
        try {
            String retVal = (String)tst.performQuery(inputs);
            System.out.println("Ret Val : " + retVal);
        }
        catch (OiilQueryException q) {
            System.out.println(q.getMessage());
        }
    }
}

