/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ContainerDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectoryContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectoryMatchContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FileLevelContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FilesContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FilesMatchContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.IfDefineContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.IfModuleContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.IncludeDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.LimitContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.LimitExceptContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.LocationContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.LocationMatchContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParameterList;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.PerlContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.PrimitiveDirective;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.VirtualHostContainer;

public class DirectiveFactory {
    public static Directive create(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return DirectiveFactory.create(string, new ParameterList(string2), true);
    }

    public static Directive create(String string, ParameterList parameterList) {
        return DirectiveFactory.create(string, parameterList, true);
    }

    protected static Directive create(String string, ParameterList parameterList, boolean bl) {
        ContainerDirective containerDirective = DirectiveFactory.createContainerDirective(string, parameterList, bl);
        if (containerDirective == null) {
            return DirectiveFactory.createPrimitiveDirective(string, parameterList, bl);
        }
        return containerDirective;
    }

    public static PrimitiveDirective createPrimitiveDirective(String string, String string2) {
        return DirectiveFactory.createPrimitiveDirective(string, new ParameterList(string2), true);
    }

    public static PrimitiveDirective createPrimitiveDirective(String string, ParameterList parameterList) {
        return DirectiveFactory.createPrimitiveDirective(string, parameterList, true);
    }

    protected static PrimitiveDirective createPrimitiveDirective(String string, ParameterList parameterList, boolean bl) {
        PrimitiveDirective primitiveDirective = null;
        if (string.equalsIgnoreCase("Include")) {
            String string2 = parameterList.elementAt(0).toString();
            int n = string2.length();
            if (string2.charAt(0) == '\"' && string2.charAt(n - 1) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n - 1) == '\'') {
                string2 = string2.substring(1, n - 1);
            }
            primitiveDirective = new IncludeDirective(string2);
        } else {
            primitiveDirective = new PrimitiveDirective(string, parameterList);
        }
        DirectiveFactory.setCloneType(primitiveDirective, bl);
        return primitiveDirective;
    }

    public static ContainerDirective createContainerDirective(String string, String string2) {
        return DirectiveFactory.createContainerDirective(string, new ParameterList(string2), true);
    }

    public static ContainerDirective createContainerDirective(String string, ParameterList parameterList) {
        return DirectiveFactory.createContainerDirective(string, parameterList, true);
    }

    protected static ContainerDirective createContainerDirective(String string, ParameterList parameterList, boolean bl) {
        ContainerDirective containerDirective = null;
        if (string.equals("FileLevelContainer")) {
            containerDirective = new FileLevelContainer(parameterList.elementAt(0).toString());
        } else if (string.equalsIgnoreCase("Directory")) {
            containerDirective = new DirectoryContainer(parameterList);
        } else if (string.equalsIgnoreCase("DirectoryMatch")) {
            containerDirective = new DirectoryMatchContainer(parameterList.elementAt(0));
        } else if (string.equalsIgnoreCase("Files")) {
            containerDirective = new FilesContainer(parameterList);
        } else if (string.equalsIgnoreCase("FilesMatch")) {
            containerDirective = new FilesMatchContainer(parameterList.elementAt(0));
        } else if (string.equalsIgnoreCase("IfDefine")) {
            containerDirective = new IfDefineContainer(parameterList.elementAt(0));
        } else if (string.equalsIgnoreCase("IfModule")) {
            containerDirective = new IfModuleContainer(parameterList.elementAt(0));
        } else if (string.equalsIgnoreCase("Limit")) {
            containerDirective = new LimitContainer(parameterList);
        } else if (string.equalsIgnoreCase("LimitExcept")) {
            containerDirective = new LimitExceptContainer(parameterList);
        } else if (string.equalsIgnoreCase("Location")) {
            containerDirective = new LocationContainer(parameterList);
        } else if (string.equalsIgnoreCase("LocationMatch")) {
            containerDirective = new LocationMatchContainer(parameterList.elementAt(0));
        } else if (string.equalsIgnoreCase("Perl")) {
            containerDirective = new PerlContainer(parameterList.elementAt(0).toString());
        } else if (string.equalsIgnoreCase("VirtualHost")) {
            containerDirective = new VirtualHostContainer(parameterList);
        } else {
            return null;
        }
        DirectiveFactory.setCloneType(containerDirective, bl);
        return containerDirective;
    }

    private static void setCloneType(Directive directive, boolean bl) {
        if (directive == null) {
            return;
        }
        if (bl) {
            directive.cloneType = (byte)2;
            return;
        }
        directive.cloneType = 0;
    }
}

