/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.helper.helper12101;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.ASMMode;
import oracle.cluster.asm.ClusterASM;
import oracle.cluster.asm.IOServer;
import oracle.cluster.common.NodeRole;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanFactory;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.GridNamingService;
import oracle.gridnamingservice.GridNamingServiceException;
import oracle.gridnamingservice.QueryTypes;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OneOffEntry;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.helper.helper12101.CVUHelper;

public class CVUHelper12101
extends CVUHelper {
    public CVUHelper12101() {
        this.addCommandLineOption("-getNetworkInfo", 2, "getNetworkInfo", "Get subnet, interface and classification for given network");
        this.addCommandLineOption("-vipExists", 2, "isVIPExists", "checks that there is at least one VIP configured on the cluster");
        this.addCommandLineOption("-getscan", 1, "getScanInfo", "Gets scan name and IP's");
        this.addCommandLineOption("-isValidOCRStorage", 2, "isValidOCRStorage", "check if given location is valid ocr storage");
        this.addCommandLineOption("-getCRSUser", 1, "getCRSUser", "gets the clusterware home user name");
        this.addCommandLineOption("-getGNSDomainAndVip", 1, "getGNSDomainAndVIP", "gets the gns domain name and vip if any");
        this.addCommandLineOption("-getGNSResourceStatus", 2, "getGNSResourceStatus", "gets the gns and GNSVIP resource status on all nodes");
        this.addCommandLineOption("-getScanName", 1, "getScanName", "gets the SCAN name");
        this.addCommandLineOption("-checkASMRunning", 2, "checkASMRunning", "check if ASM is running on nodes");
        this.addCommandLineOption("-getIOServerNodes", 1, "getIOServerNodes", "get nodes IOServers are running");
        this.addCommandLineOption("-getDiskGroupCount", 1, "getDiskGroupCount", "get number of diskgroups from crs");
        this.addCommandLineOption("-getOPatchStatus", 3, "getOPatchStatus", "return status (installed/missing) for a given oracle patch for the give oracle home");
        this.addCommandLineOption("-getCSSMode", 1, "getCSSMode", "return CSS mode");
        this.addCommandLineOption("-getASMResourceAttribute", 2, "getASMResourceAttribute", "return ASM resource attribute value");
        this.addCommandLineOption("-getNodeRole", 3, "getNodeRole", "returns either configured or active node role");
        this.addCommandLineOption("-getNodeNames", 2, "getNodeNames", "Gets list of cluster node names of specified role");
        this.addCommandLineOption("-validateGNSCredential", 2, "validateGNSCredential", "It validates the data client file and returns domain name");
    }

    public int getNetworkInfo(String[] args) {
        int status = 0;
        try {
            int networkNumber = Integer.parseInt(args[1]);
            NodeAppsFactory naf = NodeAppsFactory.getInstance();
            Trace.out((String)"got nodeapps factor");
            Network nw = naf.getNetwork(networkNumber);
            Subnet subnet = nw.subnet();
            Trace.out((String)"got subnet");
            String subnetTypeStr = "PVT";
            if (networkNumber == 1) {
                subnetTypeStr = "PUB";
            }
            List ifsList = nw.networkAdapters();
            StringBuilder ifStr = new StringBuilder();
            if (ifsList == null || ifsList.size() == 0) {
                Trace.out((String)"iflist is empty");
                ifStr.append("");
            } else {
                Iterator iter = ifsList.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    NetworkAdapter na = (NetworkAdapter)iter.next();
                    ifStr.append(na.getAdapterName());
                    if (i < ifsList.size() - 1) {
                        ifStr.append(":");
                    }
                    ++i;
                }
                Trace.out((String)"creating non-empty iflist");
            }
            this.displaySuccessResult("<NET_INTERFACE>" + ifStr.toString() + "</NET_INTERFACE>" + "<NET_SUBDOMAIN>" + subnet.getName() + "</NET_SUBDOMAIN>" + "<NET_CLASS>" + subnetTypeStr + "</NET_CLASS>");
            this.displayVRESStatus(0);
        }
        catch (NotExistsException e) {
            Trace.out((String)"network resource does not exist");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        catch (NumberFormatException e) {
            this.displayErrorResult("invalid network number", 2);
            status = 0;
        }
        catch (NetworkException e) {
            Trace.out((String)"network resource error");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)"out of space");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        return status;
    }

    public int isVIPExists(String[] args) {
        String nodeName = args[1];
        int status = 0;
        Trace.out((int)2, (String)"Entry");
        try {
            NodeAppsFactory naf = NodeAppsFactory.getInstance();
            List viplist = naf.getVIPs(nodeName, null);
            if (viplist.size() == 0) {
                this.displayWarningResult("no vips", 1);
            } else {
                this.displaySuccessResult("vip's found", 0);
                status = 0;
            }
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("software module exception" + e.getMessage()));
            this.displayErrorResult("error checking", 2);
        }
        Trace.out((int)2, (String)"Exit");
        return status;
    }

    public int getScanName(String[] args) {
        Trace.out((int)2, (String)"Entry");
        try {
            ScanFactory sf = ScanFactory.getInstance();
            Scan scan = sf.getScan();
            this.displaySuccessResult("<SCN_NME>" + scan.getScanName() + "</SCN_NME>", 0);
            return 0;
        }
        catch (ScanException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getDiskGroupCount(String[] args) {
        Trace.out((int)2, (String)"Entry");
        List ldg = null;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            ldg = asmfact.getDiskGroups();
        }
        catch (ASMException e) {
            Trace.out((String)("ASMException occurred when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            Trace.out((String)("NotExistsException returned when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("SoftwareModuleException returned when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        Trace.out((int)2, (String)"Exit");
        this.displaySuccessResult("<ASMDG_COUNT>" + ldg.size() + "</ASMDG_COUNT>", 0);
        return 0;
    }

    public int getIOServerNodes(String[] args) {
        int ioserverCount = 0;
        StringBuilder runNodesSB = new StringBuilder();
        Trace.out((String)"Entry");
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            IOServer ios = asmfact.getIOServer();
            ioserverCount = ios.getCount();
            Trace.out((String)("IOServer count " + ioserverCount));
            CRSResource crsRes = ios.crsResource();
            List runNodes = crsRes.fetchRunningNodes();
            if (runNodes != null) {
                for (Node node : runNodes) {
                    runNodesSB.append(node.getName());
                    runNodesSB.append(",");
                }
                runNodesSB.deleteCharAt(runNodesSB.length() - 1);
                Trace.out((String)("IOServers running on nodes" + runNodesSB.toString()));
            }
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (CRSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NodeException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        Trace.out((int)2, (String)"Exit");
        this.displaySuccessResult("<IOS_COUNT>" + ioserverCount + "</IOS_COUNT>" + "<IOS_NODES>" + runNodesSB.toString() + "</IOS_NODES>", 0);
        return 0;
    }

    public int checkASMRunning(String[] args) {
        String[] nodeArray = args[1].split(",");
        boolean failNodes = false;
        boolean succNodes = false;
        ASMFactory asmfact = null;
        ASM asm = null;
        ClusterASM clustASM = null;
        try {
            asmfact = ASMFactory.getInstance();
            try {
                asm = asmfact.getASM();
            }
            catch (NotExistsException e) {
                clustASM = asmfact.getClusterASM();
            }
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        for (String nodename : nodeArray) {
            try {
                Node node = ServerFactory.getInstance().getNode(nodename);
                if (asm != null) {
                    if (asm.isRunning(node)) {
                        Trace.out((int)5, (String)("ASM is running on node " + nodename));
                        succNodes = true;
                        this.displaySuccessResult("<ASM_SUCC_NODE>" + nodename + "</ASM_SUCC_NODE>");
                        continue;
                    }
                    Trace.out((int)5, (String)("ASM is NOT running on node " + nodename));
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                    continue;
                }
                if (clustASM == null) continue;
                if (clustASM.isRunning(node)) {
                    Trace.out((int)5, (String)("ASM is running on node " + nodename));
                    succNodes = true;
                    this.displaySuccessResult("<ASM_SUCC_NODE>" + nodename + "</ASM_SUCC_NODE>");
                    continue;
                }
                Trace.out((int)5, (String)("ASM is NOT running on node " + nodename));
                failNodes = true;
                this.displayWarningResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
            }
            catch (ServerException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + e.getMessage()));
            }
            catch (NodeException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + e.getMessage()));
            }
            catch (SoftwareModuleException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + e.getMessage()));
            }
        }
        if (succNodes) {
            if (failNodes) {
                this.displayVRESStatus(1);
                return 0;
            }
            this.displayVRESStatus(0);
            return 0;
        }
        this.displayVRESStatus(2);
        return 0;
    }

    public int getGNSResourceStatus(String[] args) {
        GNSFactory gnsFactory = null;
        GNS gns = null;
        GNSVIP gnsVIP = null;
        String[] nodeArray = args[1].split(",");
        try {
            Trace.out((String)"getting GNS factory");
            gnsFactory = GNSFactory.getInstance();
            gns = gnsFactory.getGNS();
            gnsVIP = gnsFactory.getVIP();
            ServerFactory sf = ServerFactory.getInstance();
            for (String nodeName : nodeArray) {
                Trace.out((String)("checking node " + nodeName));
                Node node = sf.getNode(nodeName);
                boolean isGNSVIPEnabled = gnsVIP.isEnabled(node);
                boolean nodeGNSVIPRunningState = gnsVIP.isRunning(node);
                boolean isGNSEnabled = gns.isEnabled(node);
                boolean nodeGNSRunningState = gns.isRunning(node);
                this.displaySuccessResult("<GNS_DETAILS><GNS_NODE>" + nodeName + "</GNS_NODE>" + "<GNS_ENABLE>" + isGNSEnabled + "</GNS_ENABLE>" + "<GNS_RUN>" + nodeGNSRunningState + "</GNS_RUN>" + "<VIP_ENABLE>" + isGNSVIPEnabled + "</VIP_ENABLE>" + "<VIP_RUN>" + nodeGNSVIPRunningState + "</VIP_RUN>" + "</GNS_DETAILS>");
            }
            this.displayVRESStatus(0);
            return 0;
        }
        catch (VIPNotFoundException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GNSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (ServerException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NodeException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getGNSDomainAndVIP(String[] args) {
        String gnsDomainName = null;
        String gnsVIP = null;
        GNSFactory gnsFactory = null;
        GNS gns = null;
        try {
            Trace.out((String)"getting GNS factory");
            gnsFactory = GNSFactory.getInstance();
            gns = gnsFactory.getGNS();
            gnsDomainName = GridNamingService.query((QueryTypes[])new QueryTypes[]{QueryTypes.SUBDOMAIN}).getSubdomain();
            gnsVIP = gns.address().getHostName();
            if (gnsDomainName == null) {
                gnsDomainName = "";
            }
            this.displaySuccessResult("<GNS_DOMAIN_NAME>" + gnsDomainName + "</GNS_DOMAIN_NAME>" + "<GNS_VIP_NAME>" + gnsVIP + "</GNS_VIP_NAME>", 0);
            Trace.out((String)("domain=" + gnsDomainName));
            Trace.out((String)("vip=" + gnsVIP));
            return 0;
        }
        catch (VIPNotFoundException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GNSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GridNamingServiceException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getCRSUser(String[] args) {
        String crsHome = System.getProperty("GI_HOME");
        try {
            Util hasUtil = new Util();
            this.displaySuccessResult(hasUtil.getOracleUser(crsHome, null), 0);
            return 0;
        }
        catch (UtilException e) {
            Trace.out((String)"Couldn't get oracle user");
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int isValidOCRStorage(String[] args) {
        int isSupported = 2;
        try {
            isSupported = ClusterInfo.checkOCRStorageType((String)args[1]);
        }
        catch (ClusterInfoException ci) {
            String msg = ci.getMessage();
            Trace.out((String)("get ocr locations failed with " + msg));
            this.displayErrorResult(msg, 2);
            return 1;
        }
        switch (isSupported) {
            case 0: {
                Trace.out((String)(" OCR location " + args[1] + " is on valid Storage."));
                this.displaySuccessResult("valid", 0);
                return 0;
            }
            case 1: {
                Trace.out((String)(" OCR location " + args[1] + " is on invalid Storage."));
                this.displayErrorResult("invalid", 1);
                return 0;
            }
        }
        Trace.out((String)(" Unable to check validity of OCR location " + args[1] + " storage type."));
        this.displayErrorResult("unknown", 2);
        return 0;
    }

    public int getScanInfo(String[] args) {
        List scanList;
        ScanFactory sf;
        Object m_localName = null;
        MessageBundle s_msgBundle = MessageBundle.getMessageBundle((String)"Prvf");
        String errMsg = s_msgBundle.getMessage("5054", true);
        Object warnMsg = null;
        Object cause = null;
        Object action = null;
        String scanName = null;
        String scanUserAssignedName = null;
        String lsnrName = null;
        String runNode = null;
        Object exceptionMsg = null;
        ScanListener scanLsnr = null;
        boolean vipRun = false;
        boolean lsnrRun = false;
        int status = 0;
        int port = 0;
        ArrayList<String> scanVIPRunningNodes = new ArrayList<String>();
        Map scanAddrTypeMap = null;
        try {
            sf = ScanFactory.getInstance();
            scanList = sf.getScans();
            Trace.out((String)("Number SCANs found : " + scanList.size()));
        }
        catch (SoftwareModuleException sme) {
            errMsg = errMsg + LSEP + sme.getMessage();
            Trace.out((String)("SOFTWAREMODULEEXCEPTION: \n" + sme.getMessage()));
            this.displayErrorResult(errMsg, 2);
            return 1;
        }
        errMsg = s_msgBundle.getMessage("5059", true);
        StringBuilder sb = new StringBuilder();
        for (Scan scan : scanList) {
            boolean scanNameErr = false;
            boolean scanLsnrErr = false;
            boolean scanErr = false;
            boolean lsnrNameErr = false;
            ArrayList<String> scanNameList = new ArrayList<String>();
            sb.delete(0, sb.length());
            String exMsg = null;
            try {
                List svipList = scan.vips();
                if (svipList.size() == 0) {
                    Trace.out((String)"no scan vips configured");
                    sf.getScanVIPs();
                }
                Network net = scan.network();
                sb.append("<SCN_NME>");
                sb.append(scan.getScanName());
                sb.append("</SCN_NME>");
                sb.append("<NET_DETAILS>");
                sb.append("<NET_NUM>");
                sb.append(net.getNumber());
                sb.append("</NET_NUM>");
                Trace.out((String)("NET_NUM: " + net.getNumber() + ", dhcpServerType: " + net.dhcpServerType()));
                if (net.dhcpServerType() != null) {
                    sb.append("<DHCP_TYPE_IPV4>");
                    sb.append(net.dhcpServerType());
                    sb.append("</DHCP_TYPE_IPV4>");
                }
                Trace.out((String)("NET_NUM: " + net.getNumber() + ", dhcpServerTypeIPv6: " + net.dhcpServerTypeIPv6()));
                if (net.dhcpServerTypeIPv6() != null) {
                    sb.append("<DHCP_TYPE_IPV6>");
                    sb.append(net.dhcpServerTypeIPv6());
                    sb.append("</DHCP_TYPE_IPV6>");
                }
                Map subs = net.subnets();
                sb.append("<SUBNETS>");
                for (IPAddressUtil.IPAddrType addrType : subs.keySet()) {
                    sb.append("<SUBNET_DETAILS>");
                    sb.append("<SUBNET_TYPE>");
                    sb.append(addrType);
                    sb.append("</SUBNET_TYPE>");
                    sb.append("<SUBNET>");
                    sb.append(((Subnet)subs.get(addrType)).getName());
                    sb.append("</SUBNET>");
                    sb.append("</SUBNET_DETAILS>");
                }
                sb.append("</SUBNETS>");
                sb.append("</NET_DETAILS>");
                for (ScanVIP svip : svipList) {
                    vipRun = false;
                    lsnrRun = false;
                    runNode = "unknown";
                    scanName = svip.getScanName();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("GOT NAME: " + scanName + "\n"));
                    }
                    scanUserAssignedName = svip.getUserAssignedName();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("GOT ASSIGNED NAME: " + scanUserAssignedName + "\n"));
                    }
                    scanAddrTypeMap = svip.addresses();
                    scanLsnr = svip.listener();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT LSNR \n");
                    }
                    Scan lsnrScan = scanLsnr.scan();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT SCAN \n");
                    }
                    lsnrName = scanLsnr.getUserAssignedName();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT LSNRNAME \n");
                    }
                    vipRun = svip.isRunning();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT VIP RUN STATE \n");
                    }
                    lsnrRun = scanLsnr.isRunning();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT LSNR RUN STATE \n");
                    }
                    if (vipRun && lsnrRun) {
                        CRSResource crsRes = scanLsnr.crsResource();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)"GOT CRS RESOURCE \n");
                        }
                        List runNodes = crsRes.fetchRunningNodes();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)"GOT RUN NODES \n");
                        }
                        if (!runNodes.isEmpty() && !scanVIPRunningNodes.contains(runNode = ((Node)runNodes.get(0)).getName())) {
                            scanVIPRunningNodes.add(runNode);
                        }
                    }
                    port = scanLsnr.getPort();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT PORT \n");
                    }
                    if (scanNameList.contains(scanUserAssignedName)) continue;
                    scanNameList.add(scanUserAssignedName);
                    sb.append("<SCN_DETAILS>");
                    sb.append("<SCN_NME>");
                    sb.append(scanName);
                    sb.append("</SCN_NME>");
                    sb.append("<USR_ASGN_NAME>");
                    sb.append(scanUserAssignedName);
                    sb.append("</USR_ASGN_NAME>");
                    for (IPAddressUtil.IPAddrType addrType : scanAddrTypeMap.keySet()) {
                        sb.append("<SCN_ADDR_DETAILS>");
                        sb.append("<ADDR_TYPE>");
                        sb.append(addrType);
                        sb.append("</ADDR_TYPE>");
                        sb.append("<SCN_ADDR>");
                        sb.append(scanAddrTypeMap.get(addrType));
                        sb.append("</SCN_ADDR>");
                        sb.append("</SCN_ADDR_DETAILS>");
                    }
                    sb.append("<RUN_NODE>");
                    sb.append(runNode);
                    sb.append("</RUN_NODE>");
                    sb.append("<LSNR_NME>");
                    sb.append(lsnrName);
                    sb.append("</LSNR_NME>");
                    sb.append("<LSNR_PORT>");
                    sb.append(port);
                    sb.append("</LSNR_PORT>");
                    sb.append("<VIP_RUN>");
                    sb.append(vipRun);
                    sb.append("</VIP_RUN>");
                    sb.append("<LSNR_RUN>");
                    sb.append(lsnrRun);
                    sb.append("</LSNR_RUN>");
                    sb.append("</SCN_DETAILS>");
                }
            }
            catch (ScanVIPException sve) {
                exMsg = sve.getMessage();
                Trace.out((String)("ScanVIPException: " + exMsg));
            }
            catch (NotExistsException nee) {
                exMsg = nee.getMessage();
                Trace.out((String)("NotExistsException: " + exMsg));
            }
            catch (ScanException se) {
                exMsg = se.getMessage();
                Trace.out((String)("ScanException: " + exMsg));
            }
            catch (CRSException crse) {
                exMsg = crse.getMessage();
                Trace.out((String)("CRSException: " + exMsg));
            }
            catch (SoftwareModuleException sme) {
                exMsg = sme.getMessage();
                Trace.out((String)("SoftwareModuleException: " + exMsg));
            }
            catch (NodeException ne) {
                exMsg = ne.getMessage();
                Trace.out((String)("NodeException: " + exMsg));
            }
            if (exMsg != null) {
                status = 1;
                this.displayErrorResult(errMsg + LSEP + exMsg);
                continue;
            }
            if (scanNameList.size() <= 0) continue;
            sb.append("<SCN_COUNT>");
            sb.append(scanNameList.size());
            sb.append("</SCN_COUNT>");
            this.displaySuccessResult(sb.toString());
        }
        this.displayVRESStatus(status);
        return status;
    }

    public int getOPatchStatus(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String oh = args[1];
        String patchId = args[2];
        int status = 0;
        ArrayList<String> oneOffEntryIds = new ArrayList<String>();
        OneOffEntry[] oneOffs = null;
        try {
            String[] requiredPatches;
            oneOffs = OPatchSDK.getAllOneOffEntry((String)oh);
            StringBuffer returnString = new StringBuffer();
            for (OneOffEntry patch : oneOffs) {
                oneOffEntryIds.add(patch.getID());
                oneOffEntryIds.addAll(Arrays.asList(patch.getBugIDsFixed()));
            }
            for (String requiredPatch : requiredPatches = patchId.split(",")) {
                String patchStatus = oneOffEntryIds.contains(requiredPatch) ? "installed" : "missing";
                returnString.append(requiredPatch + ":" + patchStatus + LSEP);
            }
            this.displaySuccessResult(returnString.toString());
        }
        catch (Exception e) {
            status = 1;
            String errMsg = e.getMessage();
            this.displayErrorResult(errMsg);
            Trace.out((String)("NODEEEXCEPTION: \n" + errMsg));
        }
        this.displayVRESStatus(status);
        return 0;
    }

    public int getCSSMode(String[] args) {
        Trace.out((int)2, (String)"Entry");
        try {
            ClusterUtil util = new ClusterUtil();
            this.displaySuccessResult(util.getCSSMode() + "", 0);
            return 0;
        }
        catch (ClusterUtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getASMResourceAttribute(String[] args) {
        Trace.out((int)2, (String)"Entry");
        boolean isFoundAttribute = false;
        String attributeName = args[1];
        String value = "";
        ASM asm = null;
        ClusterASM clustASM = null;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            try {
                asm = asmfact.getASM();
            }
            catch (NotExistsException e) {
                Trace.out((String)"legacy asm instance couldn't be created");
                clustASM = asmfact.getClusterASM();
            }
            if ("ASM_INSTANCE_COUNT".equals(attributeName)) {
                clustASM = asmfact.getClusterASM();
                Trace.out((String)"getting instance count");
                value = String.valueOf(clustASM.getCount());
                isFoundAttribute = true;
            } else if ("PRESENCE".equals(attributeName)) {
                Trace.out((String)"getting presence");
                try {
                    ClusterUtil clUtil = new ClusterUtil();
                    ASMMode asmMode = clUtil.getASMMode();
                    value = ASMMode.CLIENT.equals((Object)asmMode) ? "far" : (ASMMode.REMOTE.equals((Object)asmMode) ? ResourceLiterals.REMOTE.toString() : ResourceLiterals.LEGACY.toString());
                    isFoundAttribute = true;
                }
                catch (ClusterUtilException e) {
                    this.displayErrorResult(e.getMessage(), 2);
                    return 0;
                }
            }
            if (isFoundAttribute) {
                this.displaySuccessResult(value, 0);
                return 0;
            }
            this.displayWarningResult("failed to get attribute " + attributeName, 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            if ("PRESENCE".equals(attributeName)) {
                this.displaySuccessResult("far", 0);
                return 0;
            }
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getNodeRole(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String type = args[1];
        String node = args[2];
        String value = "";
        try {
            ClusterUtil clUtil = new ClusterUtil();
            if ("ACTIVE".equalsIgnoreCase(type)) {
                value = String.valueOf(clUtil.getNodeActiveRole().getRole());
            } else if ("CONFIGURED".equalsIgnoreCase(type)) {
                value = String.valueOf(clUtil.getNodeConfiguredRole(node).getRole());
            }
            this.displaySuccessResult(value, 0);
            return 0;
        }
        catch (ClusterUtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getNodeNames(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String nodeRoleStr = args[1];
        NodeRole nodeRole = NodeRole.getEnumMember((int)Integer.parseInt(nodeRoleStr));
        String value = "";
        try {
            ClusterUtil clUtil = new ClusterUtil();
            value = this.strArr2List(clUtil.getNodeNames(nodeRole));
            this.displaySuccessResult(value, 0);
            return 0;
        }
        catch (ClusterUtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int processCommandLine(String methodName, String[] args) {
        try {
            Class<?> helperClass = Class.forName("oracle.ops.verification.helper.helper12101.CVUHelper12101");
            Class[] clsArr = new Class[]{args.getClass()};
            Method cmdMethod = helperClass.getMethod(methodName, clsArr);
            Object[] arglist = new Object[]{args};
            Integer retVal = (Integer)cmdMethod.invoke(helperClass.newInstance(), arglist);
            return retVal;
        }
        catch (NoSuchMethodException e) {
            Trace.out((Exception)e);
            this.displayExecutionError("Method " + methodName + " not found");
            return 2;
        }
        catch (InstantiationException e) {
            this.displayExecutionError("error while instantiating method " + methodName);
            return 2;
        }
        catch (ClassNotFoundException e) {
            this.displayExecutionError("Class CVUHelper11202 not found");
            return 2;
        }
        catch (IllegalAccessException e) {
            this.displayExecutionError("Illegal Access while running method " + methodName);
            return 2;
        }
        catch (InvocationTargetException e) {
            this.displayExecutionError("error while invoking method " + methodName);
            Trace.out((Exception)e);
            return 2;
        }
    }

    public int validateGNSCredential(String[] gnsCredFile) {
        CredentialsFactory credFac = null;
        GNSProperties gnsProp = null;
        String gnsDomainName = null;
        Trace.out((String)("GNS data file is located in " + gnsCredFile[1]));
        try {
            credFac = CredentialsFactory.getInstance();
            gnsProp = credFac.getGNSProperties(gnsCredFile[1]);
            gnsDomainName = gnsProp.getGNSSubDomain();
            Trace.out((String)("Domain name readed from data file " + gnsDomainName));
        }
        catch (CredentialsException ex) {
            this.displayExecutionError(ex.getMessage());
            Trace.out((Exception)((Object)ex));
            return 0;
        }
        this.displaySuccessResult("<GNS_DOMAIN_NAME>" + gnsDomainName + "</GNS_DOMAIN_NAME>");
        return 0;
    }

    public static void main(String[] args) {
        int retVal = 2;
        CVUHelper12101.setupTracing();
        Trace.out((String)"CVUHelper12101 main");
        CVUHelper12101 cvuHelper = new CVUHelper12101();
        String methodName = cvuHelper.parseArguments(args);
        if (methodName != null) {
            retVal = cvuHelper.processCommandLine(methodName, args);
            if (retVal != 2) {
                cvuHelper.displayExecutionSuccess();
            } else {
                cvuHelper.displayExecutionError("exception returned by method : " + args[0]);
            }
        } else {
            cvuHelper.displayExecutionError("Invalid commandline argument :" + args[0]);
        }
        Trace.out((String)"==== cvuhelper exiting normally.");
        System.exit(retVal);
    }
}

