/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchAIXOS;
import oracle.sysman.oip.oipc.oipch.OipchAIXPackageReader;
import oracle.sysman.oip.oipc.oipch.OipchAIXPatch;
import oracle.sysman.oip.oipc.oipch.OipchAIXVersion;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchVendor;

class OipchAIXOSCreator
extends OipchOSCreator {
    private static final String OSINFO_FILE = "osinfo.txt";
    private static final String OSLEVEL = "/usr/bin/oslevel -r";
    private static final String LSLPP_PRODUCT_FILE = "lslpp_product.txt";
    private static final String LSLPP_PRODUCT_SCRIPT = "/usr/bin/lslpp -l 2>/dev/null";
    private OipchAIXOS m_oAIXOS;

    protected OipchAIXOSCreator(int iPlatID) {
        super(iPlatID);
    }

    protected OipchOS createOS() {
        this.m_oAIXOS = new OipchAIXOS();
        this.updateOSInfo();
        this.updatePackageAndPatchInfo();
        return this.m_oAIXOS;
    }

    protected void updateOSInfo() {
        this.m_oAIXOS.setPlatformID(OiixPlatform.getCurrentPlatform());
        this.m_oAIXOS.setOSName(OiixPlatform.getCurrentPlatformOSName());
        this.m_oAIXOS.setOSVersion(new OipchAIXVersion(this.getAIXOSVersion()));
        this.m_oAIXOS.setOSVendor(new OipchVendor(System.getProperty("java.vendor")));
        this.m_oAIXOS.setOSArch(OiixPlatform.getCurrentPlatformArch());
    }

    protected String getAIXOSVersion() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)OSINFO_FILE);
        File oFile = new File(sFile);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = "/usr/bin/oslevel -r>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            // empty catch block
        }
        if (result != 0) {
            return "";
        }
        String currentLine = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(sFile));
            currentLine = reader.readLine();
            reader.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        currentLine = currentLine.replace('-', '.');
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return currentLine;
    }

    private void updatePackageAndPatchInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)LSLPP_PRODUCT_FILE);
        File oFile = new File(sFile);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = "/usr/bin/lslpp -l 2>/dev/null>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        try {
            Collection oPackages = null;
            oPackages = OipchAIXPackageReader.readPackageDetails(sFile);
            Iterator iter = oPackages.iterator();
            while (iter.hasNext()) {
                String cur_elem = (String)iter.next();
                String name = cur_elem.substring(0, cur_elem.indexOf(":"));
                String vers = cur_elem.substring(cur_elem.indexOf(":") + 1);
                OipchPackage cur_pkg = OipchPackage.createNewInstance(this.m_iPlatID);
                try {
                    cur_pkg.setProperty("VALUE", name);
                    cur_pkg.setProperty("VERSION", vers);
                }
                catch (OipchIncorrectPackageFormatException e) {
                    // empty catch block
                }
                this.m_oAIXOS.addPackage(cur_pkg);
                OipchAIXPatch cur_patch = new OipchAIXPatch("", name, vers);
                this.m_oAIXOS.addPatch(cur_patch);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath", "");
    }
}

