/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateString;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchIHasKernel;
import oracle.sysman.oip.oipc.oipch.OipchIHasPackages;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchInverseRangeList;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchLinuxGlibcVersion;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOS;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSVersion;
import oracle.sysman.oip.oipc.oipch.OipchLinuxVersion;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSReader;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchRangeList;
import oracle.sysman.oip.oipc.oipch.OipchRefHostReader;
import oracle.sysman.oip.oipc.oipch.OipchRunCommand;
import oracle.sysman.oip.oipc.oipch.OipchStrKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchVendor;
import oracle.sysman.oip.oipc.oipch.OipchVerKernelProperty;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipchLinuxOSReader
extends OipchOSReader {
    private OipchLinuxOS m_oLinuxOS = null;

    protected OipchLinuxOSReader(Node oNode, int iPlatID) {
        super(oNode, iPlatID);
    }

    protected OipchOS createOS() throws OixdInvalidDocumentException {
        this.m_oLinuxOS = new OipchLinuxOS();
        this.m_oLinuxOS.setPlatformID(this.m_iPlatID);
        NodeList oOSNodes = this.m_oNode.getChildNodes();
        if (oOSNodes != null) {
            int nOSNodes = oOSNodes.getLength();
            Node oAttrib = null;
            NamedNodeMap oOSNodeAttribs = null;
            for (int i = 0; i < nOSNodes; ++i) {
                Object[] args;
                Node oOSNode = oOSNodes.item(i);
                if (oOSNode.getNodeType() != 1) continue;
                if (oOSNode.getNodeName().equalsIgnoreCase("VERSION")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"VERSION", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    try {
                        OipchLinuxVersion ver = new OipchLinuxVersion(oAttrib.getNodeValue());
                        this.m_oLinuxOS.setOSVersion(ver);
                        continue;
                    }
                    catch (OipchIncorrectVersionFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)((Object)e));
                    }
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("VENDOR")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"VENDOR", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    OipchVendor vendor = new OipchVendor(oAttrib.getNodeValue());
                    this.m_oLinuxOS.setOSVendor(vendor);
                    OipchLinuxOSVersion ver = new OipchLinuxOSVersion(this.m_oLinuxOS.getOSVendor() + "-" + this.m_oLinuxOS.getOSVersion());
                    this.m_oLinuxOS.setOSVersion(ver);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("NAME")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"NAME", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    this.m_oLinuxOS.setOSName(oAttrib.getNodeValue());
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("ARCHITECTURE")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"ARCHITECTURE", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    this.m_oLinuxOS.setOSArch(oAttrib.getNodeValue());
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("PACKAGES")) {
                    this.addPackageDetails(this.m_oLinuxOS, oOSNode);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("GLIBC")) {
                    if (Boolean.getBoolean(OipchRefHostReader.S_IF_REFHOST) || (oOSNodeAttribs = oOSNode.getAttributes()) == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"GLIBC", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    try {
                        this.m_oLinuxOS.setGLibCVersion(new OipchLinuxGlibcVersion(oAttrib.getNodeValue()));
                        continue;
                    }
                    catch (OipchIncorrectVersionFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)((Object)e));
                    }
                }
                if (!oOSNode.getNodeName().equalsIgnoreCase("KERNEL") || Boolean.getBoolean(OipchRefHostReader.S_IF_REFHOST)) continue;
                NodeList oKernelProps = oOSNode.getChildNodes();
                this.addKernelDetails(this.m_oLinuxOS, oKernelProps);
            }
        }
        return this.m_oLinuxOS;
    }

    /*
     * Unable to fully structure code
     */
    private void addPackageDetails(OipchIHasPackages oOS, Node oPackages) throws OixdInvalidDocumentException {
        oNodeAttribs = oPackages.getAttributes();
        oInvRangeList = null;
        bIfRangeParameter = false;
        oAttrib = oNodeAttribs.getNamedItem("VALUE");
        ogrh = new OipchGenericRefHost();
        if (oAttrib != null) {
            sPkgs = oAttrib.getNodeValue();
            asPkgs = OiixFunctionOps.explodeString((String)sPkgs, (String)",");
            for (i = 0; i < asPkgs.length; ++i) {
                oPkg = OipchPackage.createNewInstance(this.m_iPlatID);
                oPkg.setName(asPkgs[i]);
                oOS.addPackage(oPkg);
            }
        } else {
            oPackagesNodeList = oPackages.getChildNodes();
            nPackages = oPackagesNodeList.getLength();
            for (j = 0; j < nPackages; ++j) {
                oPkgNode = oPackagesNodeList.item(j);
                bIfRangeParameter = ogrh.isRangeProperty(oPkgNode);
                oAttrib = null;
                if (oPkgNode.getNodeType() != 1 || !oPkgNode.getNodeName().equalsIgnoreCase("PACKAGE") || (oNodeAttribs = oPkgNode.getAttributes()) == null) continue;
                oPkg = OipchPackage.createNewInstance(this.m_iPlatID);
                oRangeList = new OipchRangeList(oNodeAttribs);
                oInvList = "";
                oExcludeNodeAttribs = null;
                oExcludeNodes1 = oPkgNode.getChildNodes();
                if (oExcludeNodes1 != null) {
                    nExcludeNodes = oExcludeNodes1.getLength();
                    for (i = 0; i < nExcludeNodes; ++i) {
                        oExcludeNode = oExcludeNodes1.item(i);
                        if (oExcludeNode.getNodeType() == 1 && oExcludeNode.getNodeName().equalsIgnoreCase("EXCLUDE") && (oExcludeNodeAttribs = oExcludeNode.getAttributes()) != null) {
                            oInvRangeList = new OipchInverseRangeList(oExcludeNodeAttribs);
                            oInvList = oInvList + oInvRangeList.toString();
                        }
                        if (oInvRangeList != null) {
                            oPkg.addInverseRangeList(oInvRangeList);
                        }
                        oInvRangeList = null;
                    }
                }
                if (bIfRangeParameter) {
                    bExclude = true;
                    oExcludeNodes = oPkgNode.getChildNodes();
                    try {
                        if (oRangeList != null) {
                            oPkg.setRangeList(oRangeList);
                        }
                        if ((nameNode = oNodeAttribs.getNamedItem("NAME")) == null) ** GOTO lbl84
                        oPkg.setProperty(nameNode.getNodeName(), nameNode.getNodeValue());
                    }
                    catch (OipchIncorrectPackageFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)e);
                    }
                } else {
                    for (i = 0; i < oNodeAttribs.getLength(); ++i) {
                        oAttrib = oNodeAttribs.item(i);
                        if (oAttrib.getNodeName().equals("VAR")) {
                            if (oAttrib.getNodeValue().indexOf("%") != -1) {
                                kernelVer = new String[1];
                                try {
                                    kernelVer = OipchRunCommand.runLocalUnixCommand("uname -r");
                                }
                                catch (IOException ioe) {
                                    ioe.printStackTrace();
                                    kernelVer[0] = "";
                                }
                                verToAppend = kernelVer[0];
                                arg = new String[1];
                                arg1 = new String[1];
                                arg[0] = new String("%KERNEL_RELEASE%");
                                verToAppend = verToAppend.trim();
                                arg1[0] = new String(verToAppend);
                                tempPkgName = null;
                                tempPkgName = OiixInstantiateString.processString((String)oAttrib.getNodeValue(), (String[])arg, (String[])arg1);
                                try {
                                    oPkg.setProperty(oAttrib.getNodeName(), tempPkgName);
                                    continue;
                                }
                                catch (OipchIncorrectPackageFormatException e) {
                                    throw new OixdInvalidDocumentException((Throwable)e);
                                }
                            }
                            try {
                                oPkg.setProperty(oAttrib.getNodeName(), oAttrib.getNodeValue());
                                continue;
                            }
                            catch (OipchIncorrectPackageFormatException e) {
                                throw new OixdInvalidDocumentException((Throwable)e);
                            }
                        }
                        try {
                            oPkg.setProperty(oAttrib.getNodeName(), oAttrib.getNodeValue());
                            continue;
                        }
                        catch (OipchIncorrectPackageFormatException e) {
                            throw new OixdInvalidDocumentException((Throwable)e);
                        }
                    }
                }
lbl84:
                // 3 sources

                if (oPkg.getName() == null) {
                    args = new String[]{"NAME", "VALUE"};
                    throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                }
                oOS.addPackage(oPkg);
            }
        }
    }

    private void addKernelDetails(OipchIHasKernel oOS, NodeList oKernelProps) throws OixdInvalidDocumentException {
        OipchKernelInfo oKernelInfo = oOS.getKernel();
        int nKernelProps = oKernelProps.getLength();
        for (int i = 0; i < nKernelProps; ++i) {
            OipchKernelProperty oKernelProp;
            block10: {
                Object[] args;
                Node oKernelPropNode = oKernelProps.item(i);
                String sName = null;
                String sValue = null;
                if (oKernelPropNode.getNodeType() != 1 || !oKernelPropNode.getNodeName().equals("PROPERTY")) continue;
                NamedNodeMap oNodeAttribs = oKernelPropNode.getAttributes();
                oKernelProp = null;
                int nNodeAttribs = oNodeAttribs.getLength();
                Node oAttrib = oNodeAttribs.getNamedItem("NAME");
                if (oAttrib == null) {
                    args = new String[]{"PROPERTY", "NAME"};
                    throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                }
                sName = oAttrib.getNodeValue();
                oAttrib = oNodeAttribs.getNamedItem("VALUE");
                if (oAttrib == null) {
                    args = new String[]{"PROPERTY", "VALUE"};
                    throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                }
                sValue = oAttrib.getNodeValue();
                if (sName.equals("VERSION")) {
                    try {
                        OipchLinuxVersion oVer = new OipchLinuxVersion(sValue);
                        oKernelProp = new OipchVerKernelProperty(sName, oVer);
                    }
                    catch (OipchIncorrectVersionFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)((Object)e));
                    }
                }
                try {
                    Long lValue = new Long(sValue);
                    oKernelProp = new OipchNumKernelProperty(sName, lValue);
                }
                catch (NumberFormatException e) {
                    String sHexValue;
                    String sHex = "0x";
                    if (!sValue.toLowerCase().startsWith(sHex) || (sHexValue = sValue.substring(sHex.length())).length() <= 0) break block10;
                    try {
                        Long lValue = Long.valueOf(sHexValue, 16);
                        oKernelProp = new OipchNumKernelProperty(sName, lValue);
                    }
                    catch (NumberFormatException e2) {
                        oKernelProp = new OipchStrKernelProperty(sName, sValue);
                    }
                }
            }
            oKernelInfo.addProperty(oKernelProp);
        }
    }
}

