/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchICompatComparable;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchLinuxVersion;
import oracle.sysman.oip.oipc.oipch.OipchPackage;

public class OipchLinuxPackage
extends OipchPackage {
    private OipchLinuxVersion m_oVersion = null;
    private String m_arch = null;
    public static final String PACKAGE_SEPARATOR = "-";

    OipchLinuxPackage() {
    }

    public void setVersion(String epoch, String version, String release) throws OipchIncorrectVersionFormatException {
        this.m_oVersion = new OipchLinuxVersion(epoch, version, release);
    }

    public String getDisplayName() {
        String sDisplayName = this.getName();
        if (this.m_oVersion != null) {
            sDisplayName = sDisplayName + PACKAGE_SEPARATOR + this.m_oVersion.getDisplayName();
        }
        if (this.m_arch != null) {
            sDisplayName = sDisplayName + PACKAGE_SEPARATOR + this.m_arch;
        }
        return sDisplayName;
    }

    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            if (this == other) {
                iResult = 1;
            } else if (other instanceof OipchLinuxPackage) {
                OipchLinuxPackage pkg = (OipchLinuxPackage)other;
                iResult = this.compare(pkg);
            }
        }
        return iResult;
    }

    public int compare(OipchLinuxPackage other) {
        String expected;
        int iResult = 8;
        String actual = this.getName();
        if (actual.equals(expected = other.getName())) {
            String myArch = this.getArch();
            String hisArch = other.getArch();
            if (myArch == null || hisArch == null || myArch.equals(hisArch)) {
                OipchLinuxVersion oOtherVer = other.getVersionObj();
                iResult = this.m_oVersion == null ? (oOtherVer == null ? 1 : 2) : (oOtherVer == null ? 4 : this.m_oVersion.compare(oOtherVer));
            }
        }
        return iResult;
    }

    public boolean isCompatible(Object obj) {
        return true;
    }

    public boolean isCompatible(OipchICompatComparable p1) {
        return true;
    }

    public void setVersion(String vers) throws OipchIncorrectVersionFormatException {
        this.m_oVersion = vers != null ? new OipchLinuxVersion(vers) : null;
    }

    public OipchLinuxVersion getVersionObj() {
        return this.m_oVersion;
    }

    public String getVersion() {
        return this.m_oVersion == null ? null : this.m_oVersion.getDisplayName();
    }

    public void setArch(String arch) {
        if (arch != null && !arch.equals("")) {
            this.m_arch = arch;
        }
    }

    public String getArch() {
        return this.m_arch;
    }

    public void setProperty(String sPropName, String sValue) throws OipchIncorrectPackageFormatException {
        if (sPropName.equals("NAME") || sPropName.equals("VAR")) {
            this.setName(sValue);
        } else if (sPropName.equals("VERSION")) {
            try {
                this.setVersion(sValue);
            }
            catch (OipchIncorrectVersionFormatException e) {
                throw new OipchIncorrectPackageFormatException((Throwable)((Object)e));
            }
        } else if (sPropName.equals("VALUE")) {
            try {
                this.setVersion(sValue);
            }
            catch (OipchIncorrectVersionFormatException e) {
                throw new OipchIncorrectPackageFormatException((Throwable)((Object)e));
            }
        } else if (sPropName.equals("ARCHITECTURE")) {
            this.setArch(sValue);
        } else {
            Object[] args = new String[]{sPropName, sValue};
            throw new OipchIncorrectPackageFormatException("OUI-11104", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11104", (Object[])args));
        }
    }

    public void setParameter(String sParam) {
        try {
            this.setVersion(sParam);
        }
        catch (OipchIncorrectVersionFormatException e) {
            e.printStackTrace();
        }
    }
}

