/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchSystemReader;
import oracle.sysman.oip.oipc.oipch.OipchUnixBooleanMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixDevice;
import oracle.sysman.oip.oipc.oipch.OipchUnixGroup;
import oracle.sysman.oip.oipc.oipch.OipchUnixMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixNumberMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixPartition;
import oracle.sysman.oip.oipc.oipch.OipchUnixStringMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixUser;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipchLinuxSystemReader
extends OipchSystemReader {
    private OipchSystem m_oSystem = null;

    protected OipchLinuxSystemReader(Node oNode, int iPlatID) {
        super(oNode, iPlatID);
    }

    void addUsersGroupsDetails(OipchSystem oSystem, Node oUGNode) throws OixdInvalidDocumentException {
        ArrayList oUGList = new ArrayList();
        NodeList oUGDetails = oUGNode.getChildNodes();
        if (oUGDetails != null) {
            int nUGDetails = oUGDetails.getLength();
            for (int i = 0; i < nUGDetails; ++i) {
                OipchUnixGroup oGrp;
                Node oUGDetailNode = oUGDetails.item(i);
                Object oAttrib = null;
                Object oNodeAttribs = null;
                if (oUGDetailNode.getNodeType() != 1) continue;
                if (oUGDetailNode.getNodeName().equalsIgnoreCase("USER")) {
                    this.addUserInfo(oSystem, oUGDetailNode);
                    continue;
                }
                if (!oUGDetailNode.getNodeName().equalsIgnoreCase("GROUP") || (oGrp = this.getGroupInfo(oUGDetailNode)) == null) continue;
                oSystem.addGroup(oGrp);
            }
        }
    }

    private void addUserInfo(OipchSystem oSystem, Node oUsrNode) throws OixdInvalidDocumentException {
        ArrayList<OipchUnixGroup> oGrpList;
        OipchUnixUser oUsr = null;
        NamedNodeMap oGrpNodeAttribs = null;
        NamedNodeMap oNodeAttribs = oUsrNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            oAttrib = oNodeAttribs.getNamedItem("VAR");
            String sUserVar = null;
            if (oAttrib != null) {
                sUserVar = oAttrib.getNodeValue();
            }
            oAttrib = oNodeAttribs.getNamedItem("VALUE");
            String sUserVal = null;
            if (oAttrib != null) {
                sUserVal = oAttrib.getNodeValue();
            }
            oAttrib = oNodeAttribs.getNamedItem("ID");
            Integer oID = null;
            if (oAttrib != null) {
                oID = new Integer(oAttrib.getNodeValue());
            }
            oAttrib = oNodeAttribs.getNamedItem("ACTIVEGROUPVAR");
            String oActiveVar = null;
            if (oAttrib != null) {
                oActiveVar = oAttrib.getNodeValue();
            }
            oAttrib = oNodeAttribs.getNamedItem("ACTIVEGROUP");
            String oActive = null;
            if (oAttrib != null) {
                oActive = oAttrib.getNodeValue();
            }
            if (sUserVal == null && sUserVar == null) {
                String[] args = new String[]{"USER"};
                throw new OixdInvalidDocumentException("User tag does not have VAR or VALUE specifed");
            }
            oUsr = new OipchUnixUser();
            oUsr.setName(sUserVal);
            oUsr.setVar(sUserVar);
            if (oID != null) {
                oUsr.setID(oID);
            }
            oGrpList = new ArrayList<OipchUnixGroup>();
            NodeList oUserChildren = oUsrNode.getChildNodes();
            if (oUserChildren != null) {
                int nUserChildren = oUserChildren.getLength();
                for (int i = 0; i < nUserChildren; ++i) {
                    String activeGroup;
                    Node activeGroupNode;
                    String groupVar;
                    Node oGrpNode = oUserChildren.item(i);
                    if (oGrpNode.getNodeType() != 1 || !oGrpNode.getNodeName().equalsIgnoreCase("GROUP")) continue;
                    OipchUnixGroup oGroup = this.getGroupInfo(oGrpNode);
                    if (oGroup != null) {
                        oGrpList.add(oGroup);
                        oSystem.addGroup(oGroup);
                    }
                    if (oActive != null) {
                        String group = oGroup.getName(null);
                        if (group != null && group.equals(oActive)) {
                            oUsr.setActiveGroup(oGroup);
                        }
                    } else if (oActiveVar != null && (groupVar = oGroup.getVar()) != null && groupVar.equals(oActiveVar)) {
                        oUsr.setActiveGroup(oGroup);
                    }
                    oGrpNodeAttribs = oGrpNode.getAttributes();
                    if (oGrpNodeAttribs == null || (activeGroupNode = oGrpNodeAttribs.getNamedItem("ACTIVE")) == null || (activeGroup = activeGroupNode.getNodeValue()) == null) continue;
                    oUsr.setActiveGroup(oGroup);
                }
            }
        } else {
            Object[] args = new String[]{"USER"};
            throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
        }
        oUsr.setGroups(oGrpList);
        if (oUsr != null) {
            oSystem.addUser(oUsr);
        }
    }

    private OipchUnixGroup getGroupInfo(Node oGrpNode) throws OixdInvalidDocumentException {
        OipchUnixGroup oGrp = null;
        NamedNodeMap oNodeAttribs = oGrpNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            oAttrib = oNodeAttribs.getNamedItem("VAR");
            String sGrpVar = null;
            if (oAttrib != null) {
                sGrpVar = oAttrib.getNodeValue();
            }
            oAttrib = oNodeAttribs.getNamedItem("VALUE");
            String sGrpVal = null;
            if (oAttrib != null) {
                sGrpVal = oAttrib.getNodeValue();
            }
            oAttrib = oNodeAttribs.getNamedItem("ID");
            Integer oID = null;
            if (oAttrib != null) {
                oID = new Integer(oAttrib.getNodeValue());
            }
            if (sGrpVal == null && sGrpVar == null) {
                String[] args = new String[]{"GROUP"};
                throw new OixdInvalidDocumentException("Group does not gave VAR or VALUE tag present");
            }
            oGrp = new OipchUnixGroup();
            oGrp.setName(sGrpVal);
            oGrp.setVar(sGrpVar);
            if (oID != null) {
                oGrp.setID(oID);
            }
        } else {
            Object[] args = new String[]{"USER"};
            throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
        }
        return oGrp;
    }

    void addDeviceDetails(OipchSystem oSystem, Node oDevicesNode) throws OixdInvalidDocumentException {
        NodeList oDevicesDetails = oDevicesNode.getChildNodes();
        if (oDevicesDetails != null) {
            int nDevicesDetails = oDevicesDetails.getLength();
            for (int i = 0; i < nDevicesDetails; ++i) {
                Node oDeviceDetailNode = oDevicesDetails.item(i);
                Object oAttrib = null;
                Object oNodeAttribs = null;
                if (oDeviceDetailNode.getNodeType() != 1 || !oDeviceDetailNode.getNodeName().equalsIgnoreCase("DEVICE")) continue;
                this.addDeviceInfo(oSystem, oDeviceDetailNode);
            }
        }
    }

    private void addDeviceInfo(OipchSystem oSystem, Node oDeviceNode) throws OixdInvalidDocumentException {
        OipchUnixDevice oDevice = null;
        NamedNodeMap oNodeAttribs = oDeviceNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            Long oVal;
            String sVal;
            oDevice = new OipchUnixDevice();
            oAttrib = oNodeAttribs.getNamedItem("NAME");
            if (oAttrib != null) {
                sVal = oAttrib.getNodeValue();
                oDevice.setName(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("MOUNT")) != null) {
                sVal = oAttrib.getNodeValue();
                oDevice.setMount(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("USER")) != null) {
                sVal = oAttrib.getNodeValue();
                oDevice.setUser(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("GROUP")) != null) {
                sVal = oAttrib.getNodeValue();
                oDevice.setGroup(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("PERMS")) != null) {
                sVal = oAttrib.getNodeValue();
                oDevice.setPermissions(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("TOTAL")) != null) {
                sVal = oAttrib.getNodeValue();
                try {
                    oVal = new Long(sVal);
                    oDevice.setTotalMem(oVal);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("AVAILABLE")) != null) {
                sVal = oAttrib.getNodeValue();
                try {
                    oVal = new Long(sVal);
                    oDevice.setAvailMem(oVal);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("ASM_CANDIDATE")) != null) {
                sVal = oAttrib.getNodeValue();
                if (sVal.equals("TRUE")) {
                    oDevice.setASMCandidacy(true);
                } else {
                    oDevice.setASMCandidacy(false);
                }
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("ASM_STAMPED")) != null) {
                sVal = oAttrib.getNodeValue();
                if (sVal.equals("TRUE")) {
                    oDevice.setASMStamped(true);
                } else {
                    oDevice.setASMStamped(false);
                }
            }
        } else {
            Object[] args = new String[]{"DEVICE"};
            throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
        }
        if (oDevice != null) {
            oSystem.addDevice(oDevice);
        }
    }

    void addPartitionDetails(OipchSystem oSystem, Node oPartitionsNode) throws OixdInvalidDocumentException {
        NodeList oPartitionsDetails = oPartitionsNode.getChildNodes();
        if (oPartitionsDetails != null) {
            int nPartitionsDetails = oPartitionsDetails.getLength();
            for (int i = 0; i < nPartitionsDetails; ++i) {
                Node oPartitionDetailNode = oPartitionsDetails.item(i);
                Object oAttrib = null;
                Object oNodeAttribs = null;
                if (oPartitionDetailNode.getNodeType() != 1 || !oPartitionDetailNode.getNodeName().equalsIgnoreCase("PARTITION")) continue;
                this.addPartitionInfo(oSystem, oPartitionDetailNode);
            }
        }
    }

    private void addPartitionInfo(OipchSystem oSystem, Node oPartitionNode) throws OixdInvalidDocumentException {
        OipchUnixPartition oPartition = null;
        NamedNodeMap oNodeAttribs = oPartitionNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            String sValue;
            StringTokenizer stMtParams;
            String sVal;
            oPartition = new OipchUnixPartition();
            oAttrib = oNodeAttribs.getNamedItem("DEVICE");
            if (oAttrib != null) {
                sVal = oAttrib.getNodeValue();
                oPartition.setDevice(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("MOUNT")) != null) {
                sVal = oAttrib.getNodeValue();
                oPartition.setMount(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("TYPE")) != null) {
                sVal = oAttrib.getNodeValue();
                oPartition.setType(sVal);
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("PARAMS")) != null && (stMtParams = new StringTokenizer(sValue = oAttrib.getNodeValue(), ",")) != null) {
                ArrayList<OipchUnixMountParameter> oMtParams = new ArrayList<OipchUnixMountParameter>();
                while (stMtParams.hasMoreTokens()) {
                    String sParam = stMtParams.nextToken();
                    int iIdx = sParam.indexOf("=");
                    if (iIdx != -1) {
                        OipchUnixMountParameter oParam;
                        String sName = sParam.substring(0, iIdx);
                        String sVal2 = sParam.substring(iIdx + 1);
                        try {
                            Long oVal = new Long(sVal2);
                            oParam = new OipchUnixNumberMountParameter();
                            oParam.setName(sName);
                            ((OipchUnixNumberMountParameter)oParam).setValue(oVal);
                            oMtParams.add(oParam);
                        }
                        catch (NumberFormatException e) {
                            oParam = new OipchUnixStringMountParameter();
                            oParam.setName(sName);
                            ((OipchUnixStringMountParameter)oParam).setValue(sVal2);
                            oMtParams.add(oParam);
                        }
                        continue;
                    }
                    OipchUnixBooleanMountParameter oParam = new OipchUnixBooleanMountParameter();
                    oParam.setName(sParam);
                    oParam.setValue(Boolean.TRUE);
                    oMtParams.add(oParam);
                }
                oPartition.setParams(oMtParams);
            }
        } else {
            Object[] args = new String[]{"PARTITION"};
            throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
        }
        if (oPartition != null) {
            oSystem.addPartition(oPartition);
        }
    }
}

