/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchVersion;

public class OipchRefHost {
    private OipchSystem m_oSystem;
    private List m_oRefOSs;
    private List m_oOracleHomes;

    public OipchSystem getSystem() {
        return this.m_oSystem;
    }

    public Iterator getOSVersions() {
        ArrayList<OipchVersion> versions = null;
        if (this.m_oRefOSs != null) {
            int nOSs = this.m_oRefOSs.size();
            versions = new ArrayList<OipchVersion>(nOSs);
            for (int i = 0; i < nOSs; ++i) {
                OipchOS os = (OipchOS)this.m_oRefOSs.get(i);
                OipchVersion ver = os.getOSVersion();
                if (ver == null) continue;
                versions.add(ver);
            }
        }
        return versions == null ? null : versions.iterator();
    }

    public Iterator getOSUpdateVersions(OipchVersion oVer) {
        ArrayList<String> update_versions = null;
        if (this.m_oRefOSs != null) {
            int nOSs = this.m_oRefOSs.size();
            update_versions = new ArrayList<String>(nOSs);
            for (int i = 0; i < nOSs; ++i) {
                String up_ver;
                OipchOS os = (OipchOS)this.m_oRefOSs.get(i);
                if (os.getOSVersion().compare((Object)oVer) != 1 || (up_ver = os.getOSUpdateVersion()) == null) continue;
                update_versions.add(up_ver);
            }
        }
        return update_versions == null ? null : update_versions.iterator();
    }

    public Iterator getOSs() {
        return this.m_oRefOSs == null ? null : this.m_oRefOSs.iterator();
    }

    public OipchOS getOSForVersion(OipchVersion version) {
        OipchOS oOS = null;
        if (this.m_oRefOSs != null) {
            int nOSs = this.m_oRefOSs.size();
            for (int i = 0; i < nOSs; ++i) {
                OipchOS os = (OipchOS)this.m_oRefOSs.get(i);
                OipchVersion ver = os.getOSVersion();
                if (version == null || !version.equals(ver)) continue;
                oOS = os;
                break;
            }
        }
        return oOS;
    }

    public Iterator getOracleHomes() {
        return this.m_oOracleHomes == null ? null : this.m_oOracleHomes.iterator();
    }

    void setSystem(OipchSystem system) {
        this.m_oSystem = system;
    }

    void addOS(OipchOS os) {
        if (os != null) {
            if (this.m_oRefOSs == null) {
                this.m_oRefOSs = new ArrayList();
            }
            this.m_oRefOSs.add(os);
        }
    }
}

