/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oip.oipc.oipch.OipchCPU;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchUnixSystemCreator;

public class OipchSolarisSystemCreator
extends OipchUnixSystemCreator {
    public String SWAP_SCRIPT = "/usr/sbin/swap -s";
    public static final String CPUINFO_SCRIPT = "/usr/sbin/psrinfo -v | grep 'operates at'";

    String getSwapScript() {
        return this.SWAP_SCRIPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getSwapSpaceFromFile(String sFile) throws IOException {
        long lSwapSpace = 0L;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            String sLine = null;
            while ((sLine = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(sLine, " ");
                String sSwapSpace = "0";
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.endsWith("k")) continue;
                    sSwapSpace = token.substring(0, token.length() - 1);
                }
                lSwapSpace = Long.parseLong(sSwapSpace) / 1024L;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return lSwapSpace;
    }

    OipchSolarisSystemCreator(int iPlatID) {
        super(iPlatID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCPUInfo(OipchSystem oSystem) {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)"cpuinfo.txt");
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = "/usr/sbin/psrinfo -v | grep 'operates at'>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                // empty catch block
            }
            if (result != 0) {
                return;
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            String sLine = null;
            block21: while ((sLine = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(sLine, " ,");
                boolean bSpeedEncountered = false;
                String sSpeed = "";
                double dSpeed = 0.0;
                String sUnit = "Mhz";
                while (st.hasMoreTokens()) {
                    OipchCPU oCPU;
                    String token = st.nextToken();
                    if (!bSpeedEncountered) {
                        try {
                            dSpeed = Double.parseDouble(token);
                            bSpeedEncountered = true;
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (token.equalsIgnoreCase("Ghz")) {
                        oCPU = new OipchCPU();
                        oCPU.setSpeedInGhz((long)dSpeed);
                        oSystem.addCPU(oCPU);
                        continue block21;
                    }
                    if (!token.equalsIgnoreCase("Mhz")) continue;
                    oCPU = new OipchCPU();
                    oCPU.setSpeedInMhz((long)dSpeed);
                    oSystem.addCPU(oCPU);
                    continue block21;
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void updateShellDetails(OipchSystem oSystem) {
    }
}

