/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchCompatibilityComponent;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchOracleHomes;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipczCompatibilityChecks {
    private OipczCompatibilityChecks() {
    }

    public static OipcrIResult checkProductCompatibility(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OixdInvalidDocumentException {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                OiisVariable oVar = oContext.getVariable("ORACLE_HOME");
                String sOracleHome = (String)oVar.getValue();
                oResult = OipczCompatibilityChecks.checkProductCompatibility(oRulesEngine, sRefFile, sOracleHome);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        }
        return oResult;
    }

    public static OipcrIResult checkProductCompatibility(OipcrIRulesEngine oRulesEngine, String sRefFile, String sOracleHome) throws OixdInvalidDocumentException {
        OipcrIResult oResult;
        block23: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    Node oCompatibilityMatNode = null;
                    if (sOracleHome != null) {
                        OipchOracleHomes oOracleHomes = oHost.getOracleHomes();
                        boolean foundCompatibilityMatrix = false;
                        if (oOracleHomes != null) {
                            OiiiInstallInventory oInstallInventory = oOracleHomes.getInstallInventory();
                            if (oInstallInventory != null) {
                                OiiiOracleHomeInfo oOraHomeInfo = oInstallInventory.getHomeWithLocation(sOracleHome);
                                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                                Object sExpectedValue = null;
                                String sActualValue = null;
                                OipcrIResult oRes = null;
                                OipchCompatibilityComponent oAllowedComp = null;
                                OipchCompatibilityComponent oDisallowedComp = null;
                                Node oHomesNodes = oGenRefHost.getNode("ORACLE_HOME/HOMES");
                                Node oCompatibilityNode = oGenRefHost.getNode("ORACLE_HOME/COMPATIBILITY_MATRIX");
                                if (oCompatibilityNode != null) {
                                    oCompatibilityMatNode = oGenRefHost.getNode("ORACLE_HOME/COMPATIBILITY_MATRIX");
                                } else {
                                    NodeList oHomeNodes = oHomesNodes.getChildNodes();
                                    if (oHomeNodes != null) {
                                        int nHomeNodes = oHomeNodes.getLength();
                                        for (int i = 0; i < nHomeNodes; ++i) {
                                            NamedNodeMap oHomeLoc;
                                            String homeName;
                                            OiisVariable oVar;
                                            String homeNameFromContext;
                                            Node oHomeNode = oHomeNodes.item(i);
                                            NodeList oHomeChildNodes = oHomeNode.getChildNodes();
                                            oCompatibilityMatNode = oHomeNode.getAttributes().getNamedItem("COMPATIBILITY_MATRIX");
                                            Node childHomeNode = oHomeNode.getAttributes().getNamedItem("HOME_LOC");
                                            if (childHomeNode != null && (homeNameFromContext = (String)(oVar = oContext.getVariable(homeName = (oHomeLoc = childHomeNode.getAttributes()).getNamedItem("VAR").getNodeValue())).getValue()).equalsIgnoreCase(sOracleHome)) {
                                                foundCompatibilityMatrix = true;
                                            }
                                            if (foundCompatibilityMatrix) break;
                                        }
                                    }
                                }
                                if (oCompatibilityMatNode != null) {
                                    Node oAllowNode = oGenRefHost.getNode("ALLOW", oCompatibilityMatNode);
                                    Node oDisallowNode = oGenRefHost.getNode("DISALLOW", oCompatibilityMatNode);
                                    boolean bAllowed = false;
                                    if (oAllowNode != null) {
                                        Iterator oAllowList = OipczCompatibilityChecks.getComponentList(oAllowNode);
                                        oAllowedComp = OipczCompatibilityChecks.getCompatibleComp(oAllowList, oInstallInventory, oOraHomeInfo);
                                    }
                                    if (oAllowNode == null || oAllowedComp != null) {
                                        bAllowed = true;
                                        if (oAllowedComp != null) {
                                            sActualValue = oAllowedComp.toString();
                                        }
                                        if (oDisallowNode != null) {
                                            Iterator oDisallowList = OipczCompatibilityChecks.getComponentList(oDisallowNode);
                                            oDisallowedComp = OipczCompatibilityChecks.getCompatibleComp(oDisallowList, oInstallInventory, oOraHomeInfo);
                                        }
                                        if (oDisallowedComp != null) {
                                            sActualValue = oDisallowedComp.toString();
                                            bAllowed = false;
                                        }
                                    }
                                    oRes = bAllowed ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                    oResDetails.add(new OipcrResultDetails((Object)sActualValue, sExpectedValue, oRes));
                                    oResult = new OipcrResult(oResDetails);
                                } else {
                                    oResult = OipcrResult.NOT_EXECUTED_RESULT;
                                }
                                break block23;
                            }
                            throw new OipcrExecuteRuleException("S_NO_INVENTORY_INFO", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_NO_INVENTORY_INFO"));
                        }
                        throw new OipcrExecuteRuleException("S_NO_ORACLE_HOME_INFO", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_NO_ORACLE_HOME_INFO"));
                    }
                    throw new OipcrExecuteRuleException("S_NO_ORACLE_HOME_VAR", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_NO_ORACLE_HOME_VAR"));
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static Iterator getComponentList(Node oNode) {
        NodeList oCompNodes = oNode.getChildNodes();
        ArrayList<OipchCompatibilityComponent> oCompList = new ArrayList<OipchCompatibilityComponent>();
        String sCompName = null;
        String sUpperVer = null;
        String sLowerVer = null;
        if (oCompNodes != null) {
            int nCompNodes = oCompNodes.getLength();
            Node oAttrib = null;
            for (int i = 0; i < nCompNodes; ++i) {
                NamedNodeMap oCompNodeAttribs;
                Node oCompNode = oCompNodes.item(i);
                if (oCompNode.getNodeType() == 1 && oCompNode.getNodeName().equalsIgnoreCase("NEW_HOME")) {
                    oCompList.add(new OipchCompatibilityComponent(0));
                    continue;
                }
                if (oCompNode.getNodeType() == 1 && oCompNode.getNodeName().equalsIgnoreCase("ORCA_HOME")) {
                    oCompList.add(new OipchCompatibilityComponent(1));
                    continue;
                }
                if (oCompNode.getNodeType() != 1 || !oCompNode.getNodeName().equalsIgnoreCase("COMP") || (oCompNodeAttribs = oCompNode.getAttributes()) == null) continue;
                oAttrib = oCompNodeAttribs.getNamedItem("NAME");
                sCompName = null;
                if (oAttrib != null) {
                    sCompName = oAttrib.getNodeValue();
                }
                oAttrib = null;
                oAttrib = oCompNodeAttribs.getNamedItem("ATLEAST");
                sLowerVer = null;
                if (oAttrib != null) {
                    sLowerVer = oAttrib.getNodeValue();
                }
                oAttrib = null;
                oAttrib = oCompNodeAttribs.getNamedItem("ATMOST");
                sUpperVer = null;
                if (oAttrib != null) {
                    sUpperVer = oAttrib.getNodeValue();
                }
                oCompList.add(new OipchCompatibilityComponent(sCompName, sLowerVer, sUpperVer));
            }
        }
        return oCompList.iterator();
    }

    public static OipchCompatibilityComponent getCompatibleComp(Iterator oList, OiiiInstallInventory oInv, OiiiOracleHomeInfo oOhi) {
        OipchCompatibilityComponent oRetComp = null;
        boolean bAllowed = false;
        while (oList.hasNext() && !bAllowed) {
            OiiiInstallCompInvEntry entry;
            OipchCompatibilityComponent oComp = (OipchCompatibilityComponent)oList.next();
            if (oComp.getHomeType() == 0) {
                if (oOhi == null || oOhi.wasCreatedInThisSession()) {
                    bAllowed = true;
                    oRetComp = oComp;
                    continue;
                }
                bAllowed = false;
                oRetComp = null;
                continue;
            }
            if (oComp.getHomeType() == 1) {
                if (oOhi == null || oOhi.getHomeType() != 3) continue;
                bAllowed = true;
                oRetComp = oComp;
                continue;
            }
            if (oOhi == null || (entry = oInv.findCompInRange(oOhi.getIndex(), oComp.getCompName(), oComp.getLowerVer(), oComp.getUpperVer())) == null) continue;
            if (oComp.getUpperVer() != null) {
                if (entry.getCompInstallID().getVersion().laterThan(new OiiiVersion(oComp.getUpperVer()))) {
                    bAllowed = false;
                    continue;
                }
                bAllowed = true;
                oComp.setCompEntry(entry);
                oRetComp = oComp;
                continue;
            }
            bAllowed = true;
            oComp.setCompEntry(entry);
            oRetComp = oComp;
        }
        return oRetComp;
    }
}

