/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchDevice;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchUnixMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixPartition;
import oracle.sysman.oip.oipc.oipch.OipchUnixSystemCreator;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiskChecks {
    private DiskChecks() {
    }

    public static OipcrIResult checkDeviceAvailableSpace(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block13: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    Map oDeviceDetails = oSystem.getDeviceDetails();
                    List oRefDevicesInfo = DiskChecks.getReferenceDeviceInfo(oRulesEngine, sRefFile);
                    if (oRefDevicesInfo == null || oRefDevicesInfo.size() == 0) break block13;
                    int iSize = oRefDevicesInfo.size();
                    if (oDeviceDetails != null) {
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                        for (int j = 0; j < iSize; ++j) {
                            OipchDevice oDev = (OipchDevice)oRefDevicesInfo.get(j);
                            String sCurDeviceName = oDev.getName();
                            long lRefSize = oDev.getAvailMem() / 1024L;
                            Long oRefSize = new Long(lRefSize);
                            OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                            OipchDevice oHostDev = (OipchDevice)oDeviceDetails.get(sCurDeviceName);
                            String sActual = null;
                            if (oHostDev != null) {
                                Long oActSize = oHostDev.getAvailMem();
                                long lActSize = 0L;
                                if (oActSize != null) {
                                    lActSize = oActSize / 1024L;
                                    sActual = new Long(lActSize).toString();
                                }
                                if (lActSize >= lRefSize) {
                                    oRes = OipcrResult.PASSED_RESULT;
                                }
                            }
                            Object[] expArgs = new String[]{oDev.getName(), oRefSize.toString()};
                            String sExpected = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_DEVICE_NAME_SIZE_FORMAT", (Object[])expArgs);
                            oResDetails.add(new OipcrResultDetails((Object)sActual, (Object)sExpected, oRes));
                        }
                        oResult = new OipcrResult(oResDetails);
                        break block13;
                    }
                    throw new OipcrExecuteRuleException("S_NO_HOST_DEVICE_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_HOST_DEVICE_INFO"));
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static List getReferenceDeviceInfo(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        ArrayList<OipchDevice> oDevicesList = new ArrayList<OipchDevice>();
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oDevicesNode = oGenRefHost.getNode("REFERENCE_DEVICES");
        if (oDevicesNode != null) {
            NodeList oNodes = oDevicesNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("DEVICE")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String[] asDeviceInfo;
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_DEVICE_UNDER_REFERENCE_DEVICES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_DEVICE_UNDER_REFERENCE_DEVICES", (Object[])args));
                        }
                        sVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sVar);
                        if (oVar == null || (asDeviceInfo = (String[])oVar.getValue()) == null) continue;
                        for (int j = 0; j < asDeviceInfo.length; ++j) {
                            StringTokenizer oTokens = new StringTokenizer(asDeviceInfo[j], "%");
                            OipchDevice oDevice = null;
                            if (oTokens != null && oTokens.countTokens() >= 2) {
                                oDevice = new OipchDevice();
                                oDevice.setName(oTokens.nextToken());
                                try {
                                    Long oSize = new Long(oTokens.nextToken());
                                    long lSize = oSize * 1024L;
                                    oDevice.setAvailMem(new Long(lSize));
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                            }
                            if (oDevice == null) continue;
                            oDevicesList.add(oDevice);
                        }
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_DEVICE_UNDER_REFERENCE_DEVICES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_DEVICE_UNDER_REFERENCE_DEVICES", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_REF_DEVICES_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_REF_DEVICES_INFO", (Object[])args));
        }
        return oDevicesList;
    }

    public static OipcrIResult checkDeviceMountParameters(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block16: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    Iterator oPartitionDetails = oSystem.getPartitionDetails();
                    List oRefPartitionsInfo = DiskChecks.getReferencePartitionsInfo(oRulesEngine, sRefFile);
                    if (oRefPartitionsInfo != null && oRefPartitionsInfo.size() != 0) {
                        int iSize = oRefPartitionsInfo.size();
                        if (oPartitionDetails != null) {
                            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                            for (int j = 0; j < iSize; ++j) {
                                OipchUnixPartition oPart = (OipchUnixPartition)oRefPartitionsInfo.get(j);
                                String sCurDeviceName = oPart.getDevice();
                                OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                                OipchUnixPartition oHostPart = null;
                                oPartitionDetails = oSystem.getPartitionDetails();
                                boolean bFound = false;
                                while (oPartitionDetails.hasNext() && !bFound) {
                                    oHostPart = null;
                                    oHostPart = (OipchUnixPartition)oPartitionDetails.next();
                                    String sHostDevName = oHostPart.getDevice();
                                    if (!sHostDevName.equals(sCurDeviceName)) continue;
                                    bFound = true;
                                    List oRefParams = oPart.getParams();
                                    List oActParams = oHostPart.getParams();
                                    if (oRefParams == null || oRefParams.size() == 0) {
                                        oRes = OipcrResult.PASSED_RESULT;
                                        continue;
                                    }
                                    if (oActParams == null || oActParams.size() == 0) {
                                        oRes = OipcrResult.FAILED_RESULT;
                                        continue;
                                    }
                                    int iRefParamSize = oRefParams.size();
                                    int iActParamSize = oActParams.size();
                                    oRes = OipcrResult.PASSED_RESULT;
                                    for (int m = 0; m < iRefParamSize; ++m) {
                                        OipchUnixMountParameter oRefMtParam = (OipchUnixMountParameter)oRefParams.get(m);
                                        String sRefMtParamName = oRefMtParam.getName();
                                        boolean bParamFound = false;
                                        for (int n = 0; n < iActParamSize; ++n) {
                                            OipchUnixMountParameter oActMtParam = (OipchUnixMountParameter)oActParams.get(n);
                                            String sActMtParamName = oActMtParam.getName();
                                            if (!sActMtParamName.equals(sRefMtParamName)) continue;
                                            bParamFound = true;
                                            int iCompare = oRefMtParam.compare(oActMtParam);
                                            if (iCompare == 4 || iCompare == 1) continue;
                                            oRes = OipcrResult.FAILED_RESULT;
                                        }
                                        if (bParamFound) continue;
                                        oRes = OipcrResult.FAILED_RESULT;
                                    }
                                }
                                oResDetails.add(new OipcrResultDetails(oHostPart, (Object)oPart, oRes));
                            }
                            oResult = new OipcrResult(oResDetails);
                            break block16;
                        }
                        throw new OipcrExecuteRuleException("S_NO_HOST_PARTITIONS_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_HOST_PARTITIONS_INFO"));
                    }
                    oResult = OipcrResult.PASSED_RESULT;
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static List getReferencePartitionsInfo(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        ArrayList<OipchUnixPartition> oPartitionsList = new ArrayList<OipchUnixPartition>();
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oDevicesNode = oGenRefHost.getNode("REFERENCE_DEVICES");
        if (oDevicesNode != null) {
            NodeList oNodes = oDevicesNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("DEVICE")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String[] asDeviceInfo;
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_DEVICE_UNDER_REFERENCE_DEVICES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_DEVICE_UNDER_REFERENCE_DEVICES", (Object[])args));
                        }
                        sVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sVar);
                        if (oVar == null || (asDeviceInfo = (String[])oVar.getValue()) == null) continue;
                        for (int j = 0; j < asDeviceInfo.length; ++j) {
                            StringTokenizer oTokens = new StringTokenizer(asDeviceInfo[j], "%");
                            OipchUnixPartition oPartition = null;
                            if (oTokens != null && oTokens.countTokens() >= 5) {
                                oPartition = new OipchUnixPartition();
                                oPartition.setDevice(oTokens.nextToken());
                                oTokens.nextToken();
                                String sMountParamsName = oTokens.nextToken();
                                oPartition.setParams(DiskChecks.getRefMountParams(oDevicesNode, sMountParamsName));
                                oPartition.setMount(oTokens.nextToken());
                                oPartition.setType(oTokens.nextToken());
                            }
                            if (oPartition == null) continue;
                            oPartitionsList.add(oPartition);
                        }
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_DEVICE_UNDER_REFERENCE_DEVICES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_DEVICE_UNDER_REFERENCE_DEVICES", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_REF_DEVICES_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_REF_DEVICES_INFO", (Object[])args));
        }
        return oPartitionsList;
    }

    private static List getRefMountParams(Node oDevicesNode, String sParamName) {
        List oParams = null;
        NodeList oNodes = oDevicesNode.getChildNodes();
        if (oNodes != null) {
            int iNodes = oNodes.getLength();
            Node oNode = null;
            NamedNodeMap oNodeAttribs = null;
            Node oAttrib = null;
            boolean bNotFound = true;
            for (int i = 0; i < iNodes && bNotFound; ++i) {
                oNode = oNodes.item(i);
                if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("MOUNT_PARAMS") || (oNodeAttribs = oNode.getAttributes()) == null) continue;
                oAttrib = oNodeAttribs.getNamedItem("NAME");
                String sName = null;
                if (oAttrib != null) {
                    sName = oAttrib.getNodeValue();
                }
                if (sName == null || !sName.equals(sParamName)) continue;
                bNotFound = false;
                oAttrib = oNodeAttribs.getNamedItem("VALUE");
                String sParams = null;
                if (oAttrib == null || (sParams = oAttrib.getNodeValue()) == null) continue;
                oParams = OipchUnixSystemCreator.constructMountParameters(sParams);
            }
        }
        return oParams;
    }

    public static OipcrIResult checkRedundancy(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block13: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    Map oDeviceDetails = oSystem.getDeviceDetails();
                    List oRefInfo = DiskChecks.getReferenceRedundancyInfo(oRulesEngine, sRefFile);
                    if (oRefInfo == null || oRefInfo.size() == 0) break block13;
                    int iSize = oRefInfo.size();
                    if (oDeviceDetails != null) {
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                        for (int j = 0; j < iSize; ++j) {
                            OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                            String[] oLocations = (String[])oRefInfo.get(j);
                            boolean bRedundant = true;
                            String sExpected = OiixFunctionOps.implodeList((String[])oLocations, (String)",");
                            String[] asMountPoints = DiskChecks.getMountPoints(oLocations, oDeviceDetails);
                            for (int k = 0; k < asMountPoints.length; ++k) {
                                for (int l = k + 1; l < asMountPoints.length; ++l) {
                                    if (asMountPoints[k] == null || !asMountPoints[k].equals(asMountPoints[l])) continue;
                                    bRedundant = false;
                                }
                            }
                            if (bRedundant) {
                                oRes = OipcrResult.PASSED_RESULT;
                            }
                            oResDetails.add(new OipcrResultDetails(null, (Object)sExpected, oRes));
                        }
                        oResult = new OipcrResult(oResDetails);
                        break block13;
                    }
                    throw new OipcrExecuteRuleException("S_NO_HOST_DEVICE_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_HOST_DEVICE_INFO"));
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static List getReferenceRedundancyInfo(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        ArrayList<String[]> oList = new ArrayList<String[]>();
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oDevicesNode = oGenRefHost.getNode("REFERENCE_DEVICES");
        if (oDevicesNode != null) {
            NodeList oNodes = oDevicesNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("REDUNDANT_LOCS")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String[] asLocsInfo;
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_REDUNDANT_LOCS_UNDER_REFERENCE_DEVICES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_REDUNDANT_LOCS_UNDER_REFERENCE_DEVICES", (Object[])args));
                        }
                        sVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sVar);
                        if (oVar == null || (asLocsInfo = (String[])oVar.getValue()) == null) continue;
                        oList.add(asLocsInfo);
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_REDUNDANT_LOCS_UNDER_REFERENCE_DEVICES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_REDUNDANT_LOCS_UNDER_REFERENCE_DEVICES", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_REF_DEVICES_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_REF_DEVICES_INFO", (Object[])args));
        }
        return oList;
    }

    private static String[] getMountPoints(String[] asLocations, Map oDeviceDetails) {
        String[] asMtPts = null;
        if (asLocations != null) {
            asMtPts = new String[asLocations.length];
            for (int i = 0; i < asLocations.length; ++i) {
                Iterator oDevs;
                Collection oDevsVals = oDeviceDetails.values();
                if (oDevsVals == null || (oDevs = oDevsVals.iterator()) == null) continue;
                while (oDevs.hasNext()) {
                    OipchDevice oDev = (OipchDevice)oDevs.next();
                    String sMtPt = oDev.getMount();
                    if (sMtPt == null || sMtPt.equals("") || asLocations[i].indexOf(sMtPt) != 0) continue;
                    if (asMtPts[i] != null) {
                        if (asMtPts[i].length() >= sMtPt.length()) continue;
                        asMtPts[i] = sMtPt;
                        continue;
                    }
                    asMtPts[i] = sMtPt;
                }
            }
        }
        return asMtPts;
    }
}

