/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchEnvironmentDetails;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.RefEnvVar;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnvironmentChecks {
    private EnvironmentChecks() {
    }

    public static OipcrIResult checkEnvironmentVariables(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                ArrayList oVariablesList = new ArrayList();
                EnvironmentChecks.parseXMLToPrepareCheck(oRulesEngine, sRefFile, oVariablesList);
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OipchSystem oSys = oHost.getSystem();
                OipchEnvironmentDetails oEnvDetails = oSys.getEnvironmentDetails();
                if (oVariablesList != null && oVariablesList.size() > 0) {
                    int iSize = oVariablesList.size();
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    for (int i = 0; i < iSize; ++i) {
                        RefEnvVar RefEnv = (RefEnvVar)oVariablesList.get(i);
                        String sName = RefEnv.getName();
                        String actValue = oEnvDetails.getProperty(sName);
                        String sValue = RefEnv.getValue();
                        OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                        String sExpected = sName;
                        if (sValue == null || sValue.equals("")) {
                            if (actValue != null && !actValue.equals("")) {
                                oRes = OipcrResult.PASSED_RESULT;
                            }
                        } else {
                            sExpected = sExpected + "=" + sValue;
                            if (sValue.equals(actValue)) {
                                oRes = OipcrResult.PASSED_RESULT;
                            }
                        }
                        oResDetails.add(new OipcrResultDetails((Object)actValue, (Object)sExpected, oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static void parseXMLToPrepareCheck(OipcrIRulesEngine oRulesEngine, String sRefFile, List oEnvList) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oEnvNode = oGenRefHost.getNode("ENVIRONMENT");
        if (oEnvNode != null) {
            NodeList oNodes = oEnvNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("VARIABLE")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        OiisVariable oVar;
                        String sValue = null;
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sVar = null;
                        if (oAttrib != null && (oVar = oContext.getVariable(sVar = oAttrib.getNodeValue())) != null) {
                            sValue = (String)oVar.getValue();
                        }
                        if ((oAttrib = oNodeAttribs.getNamedItem("VALUE")) != null) {
                            sValue = oAttrib.getNodeValue();
                        }
                        oAttrib = oNodeAttribs.getNamedItem("NAME");
                        String sName = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_NAME_FOR_VARIABLE_UNDER_ENVIRONMENT", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_NAME_FOR_VARIABLE_UNDER_ENVIRONMENT", (Object[])args));
                        }
                        sName = oAttrib.getNodeValue();
                        oEnvList.add(new RefEnvVar(sName, sValue));
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_VARIABLE_UNDER_ENVIRONMENT", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_VARIABLE_UNDER_ENVIRONMENT", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_ENVIRONMENT_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ENVIRONMENT_INFO", (Object[])args));
        }
    }
}

